/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.util.Set;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessAttributes;
import org.zeroturnaround.exec.ProcessOutput;
import org.zeroturnaround.exec.ProcessResult;

class InvalidExitUtil {
    private static final int MAX_OUTPUT_SIZE_IN_ERROR_MESSAGE = 5000;

    InvalidExitUtil() {
    }

    public static void checkExit(ProcessAttributes attributes, ProcessResult result2) {
        Set<Integer> allowedExitValues = attributes.getAllowedExitValues();
        if (allowedExitValues != null && !allowedExitValues.contains(result2.getExitValue())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected exit value: ").append(result2.getExitValue());
            sb.append(", allowed exit values: ").append(allowedExitValues);
            InvalidExitUtil.addExceptionMessageSuffix(attributes, sb, result2.hasOutput() ? result2.getOutput() : null);
            throw new InvalidExitValueException(sb.toString(), result2);
        }
    }

    public static void addExceptionMessageSuffix(ProcessAttributes attributes, StringBuilder sb, ProcessOutput output) {
        sb.append(", executed command ").append(attributes.getCommand());
        if (attributes.getDirectory() != null) {
            sb.append(" in directory ").append(attributes.getDirectory());
        }
        if (!attributes.getEnvironment().isEmpty()) {
            sb.append(" with environment ").append(attributes.getEnvironment());
        }
        if (output != null) {
            int length = output.getBytes().length;
            String out2 = output.getString();
            if (out2.length() <= 5000) {
                sb.append(", output was ").append(length).append(" bytes:\n").append(out2.trim());
            } else {
                sb.append(", output was ").append(length).append(" bytes (truncated):\n");
                int halfLimit = 2500;
                sb.append(out2.substring(0, halfLimit)).append("\n...\n").append(out2.substring(out2.length() - halfLimit).trim());
            }
        }
    }
}

