/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a'\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0004\"\u00020\bH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aA\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\r0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aS\u0010\u0014\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u00020\u00172$\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\r0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001aA\u0010\u001c\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\r0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"componentInfoList", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "c", "", "([Lcom/github/ajalt/colormath/ColorComponentInfo;)Ljava/util/List;", "polarComponentInfo", "name", "", "rectangularComponentInfo", "names", "([Ljava/lang/String;)Ljava/util/List;", "adaptToThis", "T", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/WhitePointColorSpace;", "color", "convert", "Lkotlin/Function1;", "(Lcom/github/ajalt/colormath/WhitePointColorSpace;Lcom/github/ajalt/colormath/Color;Lkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "doCreate", "Lcom/github/ajalt/colormath/ColorSpace;", "components", "", "init", "Lkotlin/Function4;", "", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function4;)Lcom/github/ajalt/colormath/Color;", "withValidComps", "block", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "colormath"})
@SourceDebugExtension(value={"SMAP\nColorSpaceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,45:1\n12#1,5:46\n1#2:51\n1549#3:52\n1620#3,3:53\n970#4:56\n1041#4,3:57\n970#4:62\n1041#4,3:63\n37#5,2:60\n*S KotlinDebug\n*F\n+ 1 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n23#1:46,5\n35#1:52\n35#1:53,3\n39#1:56\n39#1:57,3\n42#1:62\n42#1:63,3\n39#1:60,2\n*E\n"})
public final class ColorSpaceUtilsKt {
    @NotNull
    public static final <T extends Color> T withValidComps(@NotNull ColorSpace<T> $this$withValidComps, @NotNull float[] components, @NotNull Function1<? super float[], ? extends T> block) {
        Intrinsics.checkNotNullParameter($this$withValidComps, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withValidComps = false;
        int size2 = $this$withValidComps.getComponents().size();
        int n = size2 - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size2 : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size2 - 1) + " or " + size2;
            throw new IllegalArgumentException(string.toString());
        }
        return (T)((Color)block.invoke((float[])components));
    }

    @NotNull
    public static final <T extends Color> T doCreate(@NotNull ColorSpace<T> $this$doCreate, @NotNull float[] components, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> init2) {
        float f;
        Intrinsics.checkNotNullParameter($this$doCreate, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(init2, "init");
        boolean $i$f$doCreate = false;
        ColorSpace<T> $this$withValidComps$iv = $this$doCreate;
        boolean $i$f$withValidComps = false;
        int size$iv = $this$withValidComps$iv.getComponents().size();
        int n = size$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it = components;
        boolean bl = false;
        Function4<Float, Float, Float, Float, T> function4 = init2;
        Float f2 = Float.valueOf(components[0]);
        Float f3 = Float.valueOf(components[1]);
        Float f4 = Float.valueOf(components[2]);
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex(fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            Float f5 = f4;
            Float f6 = f3;
            Float f7 = f2;
            Function4<Float, Float, Float, Float, T> function42 = function4;
            boolean bl2 = false;
            float f8 = 1.0f;
            function4 = function42;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        return (T)((Color)function4.invoke(f2, f3, f4, Float.valueOf(f)));
    }

    @NotNull
    public static final <T extends Color> T adaptToThis(@NotNull WhitePointColorSpace<T> $this$adaptToThis, @NotNull Color color, @NotNull Function1<? super Color, ? extends T> convert2) {
        Intrinsics.checkNotNullParameter($this$adaptToThis, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(convert2, "convert");
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        Object object = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        if (object == null || (object = object.getWhitePoint()) == null) {
            object = Illuminant.INSTANCE.getD65();
        }
        return (T)(Intrinsics.areEqual(object, $this$adaptToThis.getWhitePoint()) ? (Color)convert2.invoke(color) : (Color)convert2.invoke(color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis.getWhitePoint()))));
    }

    @NotNull
    public static final List<ColorComponentInfo> componentInfoList(ColorComponentInfo ... c) {
        Intrinsics.checkNotNullParameter(c, "c");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread(c);
        spreadBuilder.add(new ColorComponentInfo("alpha", false));
        return CollectionsKt.listOf(spreadBuilder.toArray(new ColorComponentInfo[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> rectangularComponentInfo(String ... names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)ArraysKt.asList(names), "alpha");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ColorComponentInfo((String)it, false));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> rectangularComponentInfo(@NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence $this$map$iv = name;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((char)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return ColorSpaceUtilsKt.rectangularComponentInfo(Arrays.copyOf(stringArray, stringArray.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> polarComponentInfo(@NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence $this$map$iv = name;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ColorComponentInfo(String.valueOf((char)it), it == 72));
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), new ColorComponentInfo("alpha", false));
    }
}

