---
myst:
  html_meta:
    keywords: LaTeX, programmation, syntaxe, validation de syntaxe, document long en latex,
              gros document latex
---

# Comment vérifier la syntaxe de mon code LaTeX ?

Les vérificateurs de syntaxe sont soit des extensions LaTeX, 
soit des programmes externes, qu'ils soient indépendants ou inclus 
dans des environnements intégrés de développement (IDE). Dans ce dernier cas, 
la vérification syntaxique peut se faire en même temps que l'on saisit le code
 ("en ligne"), ou par appel d'une option de menu.

## Vérificateurs internes à LaTeX

### L'extension <ctanpkg:syntonly>

Si vous travaillez sur un gros document et que vous souhaitez savoir rapidement 
si votre code est correct ou non, vous pouvez utiliser l'extension 
<ctanpkg:syntonly>. Elle permet de compiler votre document sans produire 
de fichier de sortie, ce qui fait gagner du temps.


Ajoutez simplement ces deux lignes à votre préambule :

```{noedit}
\usepackage{syntonly}
\syntaxonly
% suite ...
```

LaTeX ne produira plus aucune page, mais il vérifiera que votre syntaxe 
est correcte et que votre document compile. Le `log` devrait dire 
quelque chose comme ça :

```text
No pages of output.
Transcript written on mon_document.log.
```

Pour restaurer un fonctionnement normal, mettez juste la commande 
`\syntaxonly` en commentaire :

```{noedit}
\usepackage{syntonly}
% \syntaxonly
```

À titre de test, nous avons compilé 
[la documentation](texdoc:memman) de la classe "memoir" avec 
et sans `\syntaxonly` sur un MacBook pro de 2018, dix fois :

| `\syntaxonly` | Durée de la compilation |
|---------------|-------------------------|
| **Sans**      | 4,33s ± 0,06            |
| **Avec**      | 1,92s ± 0,04            |

soit un gain d'un facteur supérieur à 2 pour un document de 567 pages.


### L'extension <ctanpkg:refcheck>

L'extension <ctanpkg:refcheck> permet, elle, de vérifier les références 
d'un document. Il suffit de la charger :

```{noedit}
\usepackage{refcheck}
```

Puis il faut compiler deux fois le document. L'extension signale alors 
les étiquettes inutiles, les équations non référencées, les références 
bibliographiques non appelées, et peut vous aider à maintenir 
votre document en affichant les noms des étiquettes `\label` dans la marge.

Il n'est pas influencé par les options `final`/`draft`. Il faudra 
donc bien penser à le retirer manuellement pour produire la version finale 
de votre document !

:::{important}
Attention à charger <ctanpkg:refcheck> **après** <ctanpkg:amslatex> 
et <ctanpkg:hyperref>, car il modifie certaines de leurs macros.
:::


### L'extension <ctanpkg:nag>

L'extension <ctanpkg:nag> n'est pas à proprement parler un vérificateur 
de syntaxe, mais elle vous prévient si vous utilisez des commandes, 
extensions ou classes considérées comme obsolètes.


## Vérificateurs externes à LaTeX

### Le programme <ctanpkg:lacheck>

Le programme <ctanpkg:lacheck> est disponible avec la distribution 
[AUCTeX](ctanpkg:auctex) (mode AllTeX pour `Emacs`). Il est capable 
de vérifier la syntaxe LaTeX et de détecter les erreurs les plus fréquentes.


### Le programme <ctanpkg:chktex>

Le programme <ctanpkg:chktex> est capable de détecter des erreurs 
typographiques dans du code LaTeX. Il permet de s'affranchir 
de certaines constructions LaTeX non intuitives. Des exécutables pour Unix, 
Amiga, MS-DOS et OS/2 sont disponibles. Le programme étant écrit en ANSI C, 
il devrait aussi fonctionner sur tous les Windows après recompilation.

Voici quelques exemples d'erreurs détectées :

- vérification de l'absence d'espace ou assimilé après/avant une parenthèse ;
- vérification de la cohérence du style ;
- mise en garde en cas d'utilisation de primitives TeX ;
- gestion des `\left` et `\right` erronés ;
- indication des espaces multiples qui ne sont pas équivalents à un seul ;
- gestion de la ponctuation en mode mathématique ;
- indication des espaces avant une note de bas de page ;
- gestion des fichiers inclus ;
- détection des blancs avant une référence au lieu de `~` ;
- vérification des couples de parenthèses ;
- gestion de l'espace après un passage en italique ;
- ...

Cet outil est configurable.


:::{sources}
- [Check syntax only, save time typesetting!](https://texblog.org/2011/02/02/check-syntax-only-save-time-typesetting/)
:::