/* SearchPage.c generated by valac 0.38.7, the Vala compiler
 * generated from SearchPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbTwitterItem.h"
#include "CbTweet.h"
#include "rest/rest-proxy-call.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_SEARCH_PAGE (search_page_get_type ())
#define SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PAGE, SearchPage))
#define SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PAGE, SearchPageClass))
#define IS_SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PAGE))
#define IS_SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PAGE))
#define SEARCH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PAGE, SearchPageClass))

typedef struct _SearchPage SearchPage;
typedef struct _SearchPageClass SearchPageClass;
typedef struct _SearchPagePrivate SearchPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_LOAD_MORE_ENTRY (load_more_entry_get_type ())
#define LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntry))
#define LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))
#define IS_LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOAD_MORE_ENTRY))
#define IS_LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOAD_MORE_ENTRY))
#define LOAD_MORE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))

typedef struct _LoadMoreEntry LoadMoreEntry;
typedef struct _LoadMoreEntryClass LoadMoreEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
enum  {
	SEARCH_PAGE_0_PROPERTY,
	SEARCH_PAGE_UNREAD_COUNT_PROPERTY,
	SEARCH_PAGE_ID_PROPERTY,
	SEARCH_PAGE_WINDOW_PROPERTY,
	SEARCH_PAGE_NUM_PROPERTIES
};
static GParamSpec* search_page_properties[SEARCH_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
typedef struct _LoadMoreEntryPrivate LoadMoreEntryPrivate;
enum  {
	LOAD_MORE_ENTRY_0_PROPERTY,
	LOAD_MORE_ENTRY_SEEN_PROPERTY,
	LOAD_MORE_ENTRY_NUM_PROPERTIES
};
static GParamSpec* load_more_entry_properties[LOAD_MORE_ENTRY_NUM_PROPERTIES];

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _SearchPage {
	GtkBox parent_instance;
	SearchPagePrivate * priv;
	Account* account;
};

struct _SearchPageClass {
	GtkBoxClass parent_class;
};

struct _SearchPagePrivate {
	gint _id;
	MainWindow* main_window;
	GtkSearchEntry* search_entry;
	GtkButton* search_button;
	TweetListBox* tweet_list;
	GtkLabel* users_header;
	GtkLabel* tweets_header;
	ScrollWidget* scroll_widget;
	GtkRadioButton* radio_button;
	GCancellable* cancellable;
	LoadMoreEntry* load_more_entry;
	gchar* search_query;
	gint user_page;
	gint64 lowest_tweet_id;
	GtkWidget* last_focus_widget;
	gint n_results;
	Collect* collect_obj;
	guint remove_content_timeout;
	gchar* last_search_query;
	gboolean loading_tweets;
	gboolean loading_users;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	SearchPage* self;
	GDateTime* now;
};

struct _LoadMoreEntry {
	GtkListBoxRow parent_instance;
	LoadMoreEntryPrivate * priv;
};

struct _LoadMoreEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _LoadMoreEntryPrivate {
	GTimeSpan last_timediff;
	GtkButton* load_more_button;
};


static gpointer search_page_parent_class = NULL;
static IPageIface * search_page_ipage_parent_iface = NULL;
static gpointer load_more_entry_parent_class = NULL;
static CbTwitterItemInterface * load_more_entry_cb_twitter_item_parent_iface = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType search_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType load_more_entry_get_type (void) G_GNUC_CONST;
GType collect_get_type (void) G_GNUC_CONST;
#define SEARCH_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_PAGE, SearchPagePrivate))
LoadMoreEntry* load_more_entry_new (void);
LoadMoreEntry* load_more_entry_construct (GType object_type);
#define SEARCH_PAGE_KEY_QUERY 0
#define SEARCH_PAGE_USER_COUNT 3
SearchPage* search_page_new (gint id, Account* account);
SearchPage* search_page_construct (GType object_type, gint id, Account* account);
void ipage_set_id (IPage* self, gint value);
static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before);
static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint twitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _twitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row);
static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void search_page_retry_button_clicked_cb (SearchPage* self);
static void _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self);
static void __lambda159_ (SearchPage* self);
void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text);
static void ___lambda159__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkButton* load_more_entry_get_button (LoadMoreEntry* self);
static void __lambda160_ (SearchPage* self);
static void search_page_load_users (SearchPage* self);
static void ___lambda160__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_page_load_tweets (SearchPage* self);
static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
static void search_page_search_entry_activate_cb (SearchPage* self);
static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void search_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
static void search_page_real_dispose (GObject* base);
static void search_page_real_on_leave (IPage* base);
static gboolean __lambda161_ (SearchPage* self);
void tweet_list_box_remove_all (TweetListBox* self);
static gboolean ___lambda161__gsource_func (gpointer self);
void tweet_list_box_set_unempty (TweetListBox* self);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void search_page_show_entries (SearchPage* self, GError* e);
static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self);
GType user_list_entry_get_type (void) G_GNUC_CONST;
#define PROFILE_PAGE_KEY_USER_ID 1
gint64 user_list_entry_get_user_id (UserListEntry* self);
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
gchar* user_list_entry_get_screen_name (UserListEntry* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_KEY_TWEET 1
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda157_ (SearchPage* self, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
gboolean collect_get_done (Collect* self);
void collect_emit (Collect* self, GError* _error_);
void tweet_list_box_set_empty (TweetListBox* self);
static void __lambda158_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* sn);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_avatar_url (UserListEntry* self, const gchar* value);
void user_list_entry_set_verified (UserListEntry* self, gboolean value);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void ___lambda158__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda157__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda155_ (SearchPage* self, GObject* _, GAsyncResult* res);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda156_ (Block7Data* _data7_, JsonArray* array, guint index, JsonNode* node);
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
static void ___lambda156__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda155__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda154_ (SearchPage* self, GtkWidget* w);
static void ___lambda154__gtk_callback (GtkWidget* widget, gpointer self);
static void search_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
GType badge_radio_button_get_type (void) G_GNUC_CONST;
static GtkRadioButton* search_page_real_get_radio_button (IPage* base);
static gchar* search_page_real_get_title (IPage* base);
static gboolean search_page_real_handles_double_open (IPage* base);
gint search_page_get_unread_count (SearchPage* self);
static void search_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define LOAD_MORE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryPrivate))
static gint load_more_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now);
static gint64 load_more_entry_real_get_sort_factor (CbTwitterItem* base);
static gint64 load_more_entry_real_get_timestamp (CbTwitterItem* base);
static GTimeSpan load_more_entry_real_get_last_set_timediff (CbTwitterItem* base);
static void load_more_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span);
gboolean load_more_entry_get_seen (LoadMoreEntry* self);
void load_more_entry_set_seen (LoadMoreEntry* self, gboolean value);
static void load_more_entry_finalize (GObject * obj);
static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	search_page_header_func ((SearchPage*) self, row, before);
}


static gint _twitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = twitter_item_sort_func (row1, row2);
	return result;
}


static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	search_page_row_activated_cb ((SearchPage*) self, row);
}


static void _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked (TweetListBox* _sender, gpointer self) {
	search_page_retry_button_clicked_cb ((SearchPage*) self);
}


static void __lambda159_ (SearchPage* self) {
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void ___lambda159__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda159_ ((SearchPage*) self);
}


static void __lambda160_ (SearchPage* self) {
	gint _tmp0_;
	_tmp0_ = self->priv->user_page;
	self->priv->user_page = _tmp0_ + 1;
	search_page_load_users (self);
}


static void ___lambda160__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda160_ ((SearchPage*) self);
}


static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	search_page_load_tweets ((SearchPage*) self);
}


SearchPage* search_page_construct (GType object_type, gint id, Account* account) {
	SearchPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	TweetListBox* _tmp3_;
	TweetListBox* _tmp4_;
	TweetListBox* _tmp5_;
	TweetListBox* _tmp6_;
	GtkButton* _tmp7_;
	LoadMoreEntry* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	ScrollWidget* _tmp11_;
	TweetListBox* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	TweetListBox* _tmp15_;
	ScrollWidget* _tmp16_;
	GtkAdjustment* _tmp17_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (SearchPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->tweet_list;
	gtk_list_box_bind_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_get_type (), GtkListBox), NULL, NULL, NULL, NULL);
	_tmp3_ = self->priv->tweet_list;
	gtk_list_box_set_header_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_get_type (), GtkListBox), _search_page_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp4_ = self->priv->tweet_list;
	gtk_list_box_set_sort_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_get_type (), GtkListBox), _twitter_item_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp5_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) _search_page_row_activated_cb_gtk_list_box_row_activated, self, 0);
	_tmp6_ = self->priv->tweet_list;
	g_signal_connect_object (_tmp6_, "retry-button-clicked", (GCallback) _search_page_retry_button_clicked_cb_tweet_list_box_retry_button_clicked, self, 0);
	_tmp7_ = self->priv->search_button;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda159__gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->load_more_entry;
	_tmp9_ = load_more_entry_get_button (_tmp8_);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "clicked", (GCallback) ___lambda160__gtk_button_clicked, self, 0);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp11_, "scrolled-to-end", (GCallback) _search_page_load_tweets_scroll_widget_scrolled_to_end, self, 0);
	_tmp12_ = self->priv->tweet_list;
	_tmp13_ = tweet_list_box_get_placeholder (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->tweet_list;
	_tmp16_ = self->priv->scroll_widget;
	_tmp17_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_list_box_get_type (), GtkListBox), _tmp17_);
	return self;
}


SearchPage* search_page_new (gint id, Account* account) {
	return search_page_construct (TYPE_SEARCH_PAGE, id, account);
}


static void search_page_search_entry_activate_cb (SearchPage* self) {
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_page_search_entry_activate_cb ((SearchPage*) self);
}


static void search_page_retry_button_clicked_cb (SearchPage* self) {
	const gchar* _tmp0_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->last_search_query;
	search_page_search_for (self, _tmp0_, FALSE);
}


/**
   * see IPage#onJoin
   */
static void search_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	SearchPage * self;
	const gchar* _tmp0_ = NULL;
	CbBundle* _tmp1_;
	gchar* term = NULL;
	gchar* _tmp4_;
	guint _tmp5_;
	const gchar* _tmp7_;
	const gchar* _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp1_ = args;
	if (_tmp1_ != NULL) {
		CbBundle* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = args;
		_tmp3_ = cb_bundle_get_string (_tmp2_, SEARCH_PAGE_KEY_QUERY);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = g_strdup (_tmp0_);
	term = _tmp4_;
	_tmp5_ = self->priv->remove_content_timeout;
	if (_tmp5_ != ((guint) 0)) {
		guint _tmp6_;
		_tmp6_ = self->priv->remove_content_timeout;
		g_source_remove (_tmp6_);
		self->priv->remove_content_timeout = (guint) 0;
	}
	_tmp7_ = term;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		GtkWidget* _tmp9_;
		_tmp9_ = self->priv->last_focus_widget;
		if (_tmp9_ != NULL) {
			GtkWidget* _tmp10_;
			GtkContainer* _tmp11_;
			GtkContainer* _tmp12_;
			_tmp10_ = self->priv->last_focus_widget;
			_tmp11_ = gtk_widget_get_parent (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkWidget* _tmp13_;
			_tmp13_ = self->priv->last_focus_widget;
			gtk_widget_grab_focus (_tmp13_);
		} else {
			GtkSearchEntry* _tmp14_;
			_tmp14_ = self->priv->search_entry;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		}
		_g_free0 (term);
		return;
	}
	_tmp15_ = term;
	search_page_search_for (self, _tmp15_, TRUE);
	_g_free0 (term);
}


static void search_page_real_dispose (GObject* base) {
	SearchPage * self;
	guint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->remove_content_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->remove_content_timeout;
		g_source_remove (_tmp1_);
		self->priv->remove_content_timeout = (guint) 0;
	}
	G_OBJECT_CLASS (search_page_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), G_TYPE_OBJECT, GObject));
}


static gboolean __lambda161_ (SearchPage* self) {
	gboolean result = FALSE;
	TweetListBox* _tmp0_;
	TweetListBox* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	_tmp0_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp0_);
	_tmp1_ = self->priv->tweet_list;
	_tmp2_ = tweet_list_box_get_placeholder (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (self->priv->last_focus_widget);
	self->priv->last_focus_widget = NULL;
	self->priv->remove_content_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda161__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda161_ ((SearchPage*) self);
	return result;
}


static void search_page_real_on_leave (IPage* base) {
	SearchPage * self;
	guint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((3 * 1000) * 60), ___lambda161__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->remove_content_timeout = _tmp0_;
}


static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	search_page_show_entries ((SearchPage*) self, _error_);
}


void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp7_;
	gchar* q = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	TweetListBox* _tmp10_;
	TweetListBox* _tmp11_;
	TweetListBox* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	Collect* _tmp22_;
	Collect* _tmp23_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (search_term != NULL);
	_tmp0_ = search_term;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = search_term;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->last_search_query);
	self->priv->last_search_query = _tmp4_;
	_tmp5_ = self->priv->cancellable;
	if (_tmp5_ != NULL) {
		GCancellable* _tmp6_;
		g_debug ("SearchPage.vala:144: Cancelling earlier search...");
		_tmp6_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp6_);
	}
	_tmp7_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp7_;
	self->priv->n_results = 0;
	_tmp8_ = self->priv->last_search_query;
	_tmp9_ = g_strdup (_tmp8_);
	q = _tmp9_;
	_tmp10_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp10_);
	_tmp11_ = self->priv->tweet_list;
	tweet_list_box_set_unempty (_tmp11_);
	_tmp12_ = self->priv->tweet_list;
	_tmp13_ = tweet_list_box_get_placeholder (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp14_);
	_tmp15_ = set_text;
	if (_tmp15_) {
		GtkSearchEntry* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = self->priv->search_entry;
		_tmp17_ = q;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_entry_get_type (), GtkEntry), _tmp17_);
	}
	_tmp18_ = q;
	_tmp19_ = g_strconcat (_tmp18_, " -rt", NULL);
	_g_free0 (q);
	q = _tmp19_;
	_tmp20_ = q;
	_tmp21_ = g_uri_escape_string (_tmp20_, NULL, TRUE);
	_g_free0 (self->priv->search_query);
	self->priv->search_query = _tmp21_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	_tmp22_ = collect_new (2);
	_g_object_unref0 (self->priv->collect_obj);
	self->priv->collect_obj = _tmp22_;
	_tmp23_ = self->priv->collect_obj;
	g_signal_connect_object (_tmp23_, "finished", (GCallback) _search_page_show_entries_collect_finished, self, 0);
	search_page_load_tweets (self);
	search_page_load_users (self);
	_g_free0 (q);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	GtkWidget* _tmp1_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->last_focus_widget);
	self->priv->last_focus_widget = _tmp1_;
	_tmp2_ = cb_bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_LIST_ENTRY)) {
		CbBundle* _tmp4_;
		GtkListBoxRow* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		CbBundle* _tmp8_;
		GtkListBoxRow* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		MainWindow* _tmp13_;
		MainWidget* _tmp14_;
		CbBundle* _tmp15_;
		_tmp4_ = bundle;
		_tmp5_ = row;
		_tmp6_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp7_ = _tmp6_;
		cb_bundle_put_int64 (_tmp4_, PROFILE_PAGE_KEY_USER_ID, _tmp7_);
		_tmp8_ = bundle;
		_tmp9_ = row;
		_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		cb_bundle_put_string (_tmp8_, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = self->priv->main_window;
		_tmp14_ = _tmp13_->main_widget;
		_tmp15_ = bundle;
		main_widget_switch_page (_tmp14_, (gint) PAGE_PROFILE, _tmp15_);
	} else {
		GtkListBoxRow* _tmp16_;
		_tmp16_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_TWEET_LIST_ENTRY)) {
			CbBundle* _tmp17_;
			CbBundle* _tmp18_;
			GtkListBoxRow* _tmp19_;
			CbTweet* _tmp20_;
			MainWindow* _tmp21_;
			MainWidget* _tmp22_;
			CbBundle* _tmp23_;
			_tmp17_ = bundle;
			cb_bundle_put_int (_tmp17_, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
			_tmp18_ = bundle;
			_tmp19_ = row;
			_tmp20_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
			cb_bundle_put_object (_tmp18_, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, G_TYPE_OBJECT, GObject));
			_tmp21_ = self->priv->main_window;
			_tmp22_ = _tmp21_->main_widget;
			_tmp23_ = bundle;
			main_widget_switch_page (_tmp22_, (gint) PAGE_TWEET_INFO, _tmp23_);
		}
	}
	_g_object_unref0 (bundle);
}


static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkListBoxRow* _tmp5_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((before == NULL) || GTK_IS_LIST_BOX_ROW (before));
	_tmp0_ = row;
	_tmp1_ = gtk_list_box_row_get_header (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	if (_tmp3_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp5_ = before;
	if (_tmp5_ == NULL) {
		GtkListBoxRow* _tmp6_;
		_tmp6_ = row;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_USER_LIST_ENTRY);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkListBoxRow* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp7_ = row;
		_tmp8_ = self->priv->users_header;
		gtk_list_box_row_set_header (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GtkListBoxRow* _tmp11_;
		_tmp11_ = before;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_USER_LIST_ENTRY)) {
			_tmp10_ = TRUE;
		} else {
			GtkListBoxRow* _tmp12_;
			_tmp12_ = before;
			_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_LOAD_MORE_ENTRY);
		}
		if (_tmp10_) {
			GtkListBoxRow* _tmp13_;
			_tmp13_ = row;
			_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_TWEET_LIST_ENTRY);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkListBoxRow* _tmp14_;
			GtkLabel* _tmp15_;
			_tmp14_ = row;
			_tmp15_ = self->priv->tweets_header;
			gtk_list_box_row_set_header (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		}
	}
	_g_object_unref0 (header);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda158_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node) {
	guint _tmp0_;
	JsonObject* user_obj = NULL;
	JsonNode* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp4_;
	gchar* avatar_url = NULL;
	JsonObject* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	UserListEntry* _tmp11_;
	JsonObject* _tmp12_;
	gint64 _tmp13_;
	UserListEntry* _tmp14_;
	JsonObject* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	UserListEntry* _tmp19_;
	JsonObject* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	UserListEntry* _tmp24_;
	const gchar* _tmp25_;
	UserListEntry* _tmp26_;
	JsonObject* _tmp27_;
	gboolean _tmp28_;
	UserListEntry* _tmp29_;
	Collect* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	TweetListBox* _tmp34_;
	UserListEntry* _tmp35_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = index;
	if (_tmp0_ > ((guint) (SEARCH_PAGE_USER_COUNT - 1))) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	user_obj = _tmp3_;
	_tmp4_ = user_list_entry_new ();
	g_object_ref_sink (_tmp4_);
	entry = _tmp4_;
	_tmp5_ = user_obj;
	_tmp6_ = json_object_get_string_member (_tmp5_, "profile_image_url");
	_tmp7_ = g_strdup (_tmp6_);
	avatar_url = _tmp7_;
	_tmp8_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp8_ == 2) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = avatar_url;
		_tmp10_ = string_replace (_tmp9_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp10_;
	}
	_tmp11_ = entry;
	_tmp12_ = user_obj;
	_tmp13_ = json_object_get_int_member (_tmp12_, "id");
	user_list_entry_set_user_id (_tmp11_, _tmp13_);
	_tmp14_ = entry;
	_tmp15_ = user_obj;
	_tmp16_ = json_object_get_string_member (_tmp15_, "screen_name");
	_tmp17_ = g_strconcat ("@", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	user_list_entry_set_screen_name (_tmp14_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = entry;
	_tmp20_ = user_obj;
	_tmp21_ = json_object_get_string_member (_tmp20_, "name");
	_tmp22_ = string_strip (_tmp21_);
	_tmp23_ = _tmp22_;
	user_list_entry_set_name (_tmp19_, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = entry;
	_tmp25_ = avatar_url;
	user_list_entry_set_avatar_url (_tmp24_, _tmp25_);
	_tmp26_ = entry;
	_tmp27_ = user_obj;
	_tmp28_ = json_object_get_boolean_member (_tmp27_, "verified");
	user_list_entry_set_verified (_tmp26_, _tmp28_);
	_tmp29_ = entry;
	user_list_entry_set_show_settings (_tmp29_, FALSE);
	_tmp30_ = self->priv->collect_obj;
	_tmp31_ = collect_get_done (_tmp30_);
	_tmp32_ = _tmp31_;
	if (!_tmp32_) {
		UserListEntry* _tmp33_;
		_tmp33_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp34_ = self->priv->tweet_list;
	_tmp35_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (avatar_url);
	_g_object_unref0 (entry);
	_json_object_unref0 (user_obj);
}


static void ___lambda158__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda158_ ((SearchPage*) self, array, index_, element_node);
}


static void __lambda157_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	JsonNode* root = NULL;
	JsonNode* _tmp13_;
	JsonArray* users = NULL;
	JsonNode* _tmp18_;
	JsonArray* _tmp19_;
	JsonArray* _tmp20_;
	gboolean _tmp21_ = FALSE;
	JsonArray* _tmp22_;
	guint _tmp23_;
	gint _tmp28_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	guint _tmp32_;
	Collect* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		TweetListBox* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		Collect* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("SearchPage.vala:218: %s", _tmp5_);
		_tmp6_ = self->priv->tweet_list;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tweet_list_box_set_error (_tmp6_, _tmp8_);
		_tmp9_ = self->priv->collect_obj;
		_tmp10_ = collect_get_done (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			Collect* _tmp12_;
			_tmp12_ = self->priv->collect_obj;
			collect_emit (_tmp12_, NULL);
		}
		self->priv->loading_users = FALSE;
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = root;
	if (_tmp13_ == NULL) {
		Collect* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		self->priv->loading_users = FALSE;
		g_debug ("SearchPage.vala:230: load_users: root is null");
		_tmp14_ = self->priv->collect_obj;
		_tmp15_ = collect_get_done (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			Collect* _tmp17_;
			_tmp17_ = self->priv->collect_obj;
			collect_emit (_tmp17_, NULL);
		}
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp18_ = root;
	_tmp19_ = json_node_get_array (_tmp18_);
	_tmp20_ = _json_array_ref0 (_tmp19_);
	users = _tmp20_;
	_tmp22_ = users;
	_tmp23_ = json_array_get_length (_tmp22_);
	if (_tmp23_ == ((guint) 0)) {
		gint _tmp24_;
		_tmp24_ = self->priv->n_results;
		_tmp21_ = _tmp24_ <= 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp25_;
		JsonArray* _tmp26_;
		guint _tmp27_;
		_tmp25_ = self->priv->n_results;
		_tmp26_ = users;
		_tmp27_ = json_array_get_length (_tmp26_);
		self->priv->n_results = _tmp25_ + ((gint) _tmp27_);
	}
	_tmp28_ = self->priv->n_results;
	if (_tmp28_ <= 0) {
		TweetListBox* _tmp29_;
		_tmp29_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp29_);
	}
	_tmp30_ = users;
	json_array_foreach_element (_tmp30_, ___lambda158__json_array_foreach, self);
	_tmp31_ = users;
	_tmp32_ = json_array_get_length (_tmp31_);
	if (_tmp32_ > ((guint) SEARCH_PAGE_USER_COUNT)) {
		LoadMoreEntry* _tmp33_;
		GtkContainer* _tmp34_;
		GtkContainer* _tmp35_;
		_tmp33_ = self->priv->load_more_entry;
		_tmp34_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			LoadMoreEntry* _tmp36_;
			TweetListBox* _tmp37_;
			LoadMoreEntry* _tmp38_;
			_tmp36_ = self->priv->load_more_entry;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp37_ = self->priv->tweet_list;
			_tmp38_ = self->priv->load_more_entry;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
		}
	} else {
		LoadMoreEntry* _tmp39_;
		_tmp39_ = self->priv->load_more_entry;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp40_ = self->priv->collect_obj;
	_tmp41_ = collect_get_done (_tmp40_);
	_tmp42_ = _tmp41_;
	if (!_tmp42_) {
		Collect* _tmp43_;
		_tmp43_ = self->priv->collect_obj;
		collect_emit (_tmp43_, NULL);
	}
	self->priv->loading_users = FALSE;
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda157__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda157_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_users (SearchPage* self) {
	gboolean _tmp0_;
	RestProxyCall* user_call = NULL;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* _tmp16_;
	GCancellable* _tmp17_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->loading_users;
	if (_tmp0_) {
		return;
	}
	self->priv->loading_users = TRUE;
	_tmp1_ = self->account;
	_tmp2_ = _tmp1_->proxy;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	user_call = _tmp3_;
	_tmp4_ = user_call;
	rest_proxy_call_set_method (_tmp4_, "GET");
	_tmp5_ = user_call;
	rest_proxy_call_set_function (_tmp5_, "1.1/users/search.json");
	_tmp6_ = user_call;
	_tmp7_ = self->priv->search_query;
	rest_proxy_call_add_param (_tmp6_, "q", _tmp7_);
	_tmp8_ = user_call;
	_tmp9_ = g_strdup_printf ("%i", SEARCH_PAGE_USER_COUNT + 1);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (_tmp8_, "count", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = user_call;
	rest_proxy_call_add_param (_tmp11_, "include_entities", "false");
	_tmp12_ = user_call;
	_tmp13_ = self->priv->user_page;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	rest_proxy_call_add_param (_tmp12_, "page", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = user_call;
	_tmp17_ = self->priv->cancellable;
	cb_utils_load_threaded_async (_tmp16_, _tmp17_, ___lambda157__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (user_call);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SearchPage* self;
		self = _data7_->self;
		_g_date_time_unref0 (_data7_->now);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda156_ (Block7Data* _data7_, JsonArray* array, guint index, JsonNode* node) {
	SearchPage* self;
	CbTweet* tweet = NULL;
	CbTweet* _tmp0_;
	CbTweet* _tmp1_;
	JsonNode* _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	GDateTime* _tmp5_;
	CbTweet* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	TweetListEntry* entry = NULL;
	CbTweet* _tmp11_;
	MainWindow* _tmp12_;
	Account* _tmp13_;
	TweetListEntry* _tmp14_;
	Collect* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	TweetListBox* _tmp20_;
	TweetListEntry* _tmp21_;
	self = _data7_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = cb_tweet_new ();
	tweet = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = node;
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = _data7_->now;
	cb_tweet_load_from_json (_tmp1_, _tmp2_, _tmp4_, _tmp5_);
	_tmp6_ = tweet;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = self->priv->lowest_tweet_id;
	if (_tmp7_ < _tmp8_) {
		CbTweet* _tmp9_;
		gint64 _tmp10_;
		_tmp9_ = tweet;
		_tmp10_ = _tmp9_->id;
		self->priv->lowest_tweet_id = _tmp10_;
	}
	_tmp11_ = tweet;
	_tmp12_ = self->priv->main_window;
	_tmp13_ = self->account;
	_tmp14_ = tweet_list_entry_new (_tmp11_, _tmp12_, _tmp13_, FALSE);
	g_object_ref_sink (_tmp14_);
	entry = _tmp14_;
	_tmp15_ = self->priv->collect_obj;
	_tmp16_ = collect_get_done (_tmp15_);
	_tmp17_ = _tmp16_;
	if (!_tmp17_) {
		TweetListEntry* _tmp18_;
		_tmp18_ = entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), FALSE);
	} else {
		TweetListEntry* _tmp19_;
		_tmp19_ = entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp20_ = self->priv->tweet_list;
	_tmp21_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_object_unref0 (tweet);
}


static void ___lambda156__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda156_ (self, array, index_, element_node);
}


static void __lambda155_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	Block7Data* _data7_;
	JsonNode* root = NULL;
	JsonNode* _tmp13_;
	GDateTime* _tmp18_;
	JsonArray* statuses = NULL;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonArray* _tmp21_;
	JsonArray* _tmp22_;
	gboolean _tmp23_ = FALSE;
	JsonArray* _tmp24_;
	guint _tmp25_;
	gint _tmp30_;
	JsonArray* _tmp32_;
	Collect* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		TweetListBox* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		Collect* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("SearchPage.vala:302: %s", _tmp5_);
		_tmp6_ = self->priv->tweet_list;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		tweet_list_box_set_error (_tmp6_, _tmp8_);
		_tmp9_ = self->priv->collect_obj;
		_tmp10_ = collect_get_done (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			Collect* _tmp12_;
			_tmp12_ = self->priv->collect_obj;
			collect_emit (_tmp12_, NULL);
		}
		self->priv->loading_tweets = FALSE;
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = root;
	if (_tmp13_ == NULL) {
		Collect* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		g_debug ("SearchPage.vala:312: load tweets: root is null");
		self->priv->loading_tweets = FALSE;
		_tmp14_ = self->priv->collect_obj;
		_tmp15_ = collect_get_done (_tmp14_);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			Collect* _tmp17_;
			_tmp17_ = self->priv->collect_obj;
			collect_emit (_tmp17_, NULL);
		}
		__vala_JsonNode_free0 (root);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp18_ = g_date_time_new_now_local ();
	_data7_->now = _tmp18_;
	_tmp19_ = root;
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = json_object_get_array_member (_tmp20_, "statuses");
	_tmp22_ = _json_array_ref0 (_tmp21_);
	statuses = _tmp22_;
	_tmp24_ = statuses;
	_tmp25_ = json_array_get_length (_tmp24_);
	if (_tmp25_ == ((guint) 0)) {
		gint _tmp26_;
		_tmp26_ = self->priv->n_results;
		_tmp23_ = _tmp26_ <= 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp27_;
		JsonArray* _tmp28_;
		guint _tmp29_;
		_tmp27_ = self->priv->n_results;
		_tmp28_ = statuses;
		_tmp29_ = json_array_get_length (_tmp28_);
		self->priv->n_results = _tmp27_ + ((gint) _tmp29_);
	}
	_tmp30_ = self->priv->n_results;
	if (_tmp30_ <= 0) {
		TweetListBox* _tmp31_;
		_tmp31_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp31_);
	}
	_tmp32_ = statuses;
	json_array_foreach_element (_tmp32_, ___lambda156__json_array_foreach, _data7_);
	_tmp33_ = self->priv->collect_obj;
	_tmp34_ = collect_get_done (_tmp33_);
	_tmp35_ = _tmp34_;
	if (!_tmp35_) {
		Collect* _tmp36_;
		_tmp36_ = self->priv->collect_obj;
		collect_emit (_tmp36_, NULL);
	}
	self->priv->loading_tweets = FALSE;
	_json_array_unref0 (statuses);
	__vala_JsonNode_free0 (root);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void ___lambda155__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda155_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_tweets (SearchPage* self) {
	gboolean _tmp0_;
	RestProxyCall* call = NULL;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	GCancellable* _tmp15_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->loading_tweets;
	if (_tmp0_) {
		return;
	}
	self->priv->loading_tweets = TRUE;
	_tmp1_ = self->account;
	_tmp2_ = _tmp1_->proxy;
	_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, rest_proxy_get_type (), RestProxy));
	call = _tmp3_;
	_tmp4_ = call;
	rest_proxy_call_set_function (_tmp4_, "1.1/search/tweets.json");
	_tmp5_ = call;
	rest_proxy_call_set_method (_tmp5_, "GET");
	_tmp6_ = call;
	_tmp7_ = self->priv->search_query;
	rest_proxy_call_add_param (_tmp6_, "q", _tmp7_);
	_tmp8_ = call;
	rest_proxy_call_add_param (_tmp8_, "tweet_mode", "extended");
	_tmp9_ = call;
	_tmp10_ = self->priv->lowest_tweet_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_ - 1);
	_tmp12_ = _tmp11_;
	rest_proxy_call_add_param (_tmp9_, "max_id", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = call;
	rest_proxy_call_add_param (_tmp13_, "count", "35");
	_tmp14_ = call;
	_tmp15_ = self->priv->cancellable;
	cb_utils_load_threaded_async (_tmp14_, _tmp15_, ___lambda155__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (call);
}


static void __lambda154_ (SearchPage* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_show (_tmp0_);
}


static void ___lambda154__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda154_ ((SearchPage*) self, widget);
}


static void search_page_show_entries (SearchPage* self, GError* e) {
	GError* _tmp0_;
	TweetListBox* _tmp5_;
	TweetListBox* _tmp6_;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = e;
	if (_tmp0_ != NULL) {
		TweetListBox* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		TweetListBox* _tmp4_;
		_tmp1_ = self->priv->tweet_list;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tweet_list_box_set_error (_tmp1_, _tmp3_);
		_tmp4_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp4_);
		self->priv->loading_tweets = FALSE;
		self->priv->loading_users = FALSE;
		return;
	}
	_tmp5_ = self->priv->tweet_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), ___lambda154__gtk_callback, self);
	self->priv->loading_tweets = FALSE;
	self->priv->loading_users = FALSE;
	_tmp6_ = self->priv->tweet_list;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
}


static void search_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	SearchPage * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-edit-find-symbolic", _ ("Search"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_radio_button_get_type (), GtkRadioButton);
}


static GtkRadioButton* search_page_real_get_radio_button (IPage* base) {
	SearchPage * self;
	GtkRadioButton* result = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* search_page_real_get_title (IPage* base) {
	SearchPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = g_strdup (_ ("Search"));
	result = _tmp0_;
	return result;
}


static gboolean search_page_real_handles_double_open (IPage* base) {
	SearchPage * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	result = TRUE;
	return result;
}


gint search_page_get_unread_count (SearchPage* self) {
	gint result;
	g_return_val_if_fail (IS_SEARCH_PAGE (self), 0);
	result = 0;
	return result;
}


static gint search_page_real_get_id (IPage* base) {
	gint result;
	SearchPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void search_page_real_set_id (IPage* base, gint value) {
	SearchPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	if (search_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, search_page_properties[SEARCH_PAGE_ID_PROPERTY]);
	}
}


static void search_page_real_set_window (IPage* base, MainWindow* value) {
	SearchPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, search_page_properties[SEARCH_PAGE_WINDOW_PROPERTY]);
}


static void search_page_class_init (SearchPageClass * klass) {
	gint SearchPage_private_offset;
	search_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchPagePrivate));
	((GObjectClass *) klass)->dispose = (void (*) (GObject *)) search_page_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_search_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_search_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = search_page_finalize;
	/** The unread count here is always zero */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_UNREAD_COUNT_PROPERTY, search_page_properties[SEARCH_PAGE_UNREAD_COUNT_PROPERTY] = g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_ID_PROPERTY, search_page_properties[SEARCH_PAGE_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_WINDOW_PROPERTY, search_page_properties[SEARCH_PAGE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	SearchPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/search-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_button", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "users_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, users_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweets_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "search_entry_activate_cb", G_CALLBACK(_search_page_search_entry_activate_cb_gtk_entry_activate));
}


static void search_page_ipage_interface_init (IPageIface * iface) {
	search_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) search_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) search_page_real_on_leave;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) search_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) search_page_real_get_radio_button;
	iface->get_title = (gchar* (*) (IPage *)) search_page_real_get_title;
	iface->handles_double_open = (gboolean (*) (IPage *)) search_page_real_handles_double_open;
	iface->get_id = search_page_real_get_id;
	iface->set_id = search_page_real_set_id;
	iface->set_window = search_page_real_set_window;
}


static void search_page_instance_init (SearchPage * self) {
	LoadMoreEntry* _tmp0_;
	self->priv = SEARCH_PAGE_GET_PRIVATE (self);
	self->priv->cancellable = NULL;
	_tmp0_ = load_more_entry_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->load_more_entry = _tmp0_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	self->priv->n_results = 0;
	self->priv->remove_content_timeout = (guint) 0;
	self->priv->loading_tweets = FALSE;
	self->priv->loading_users = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_SCROLL_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void search_page_finalize (GObject * obj) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_PAGE, SearchPage);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->users_header);
	_g_object_unref0 (self->priv->tweets_header);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->load_more_entry);
	_g_free0 (self->priv->search_query);
	_g_object_unref0 (self->priv->last_focus_widget);
	_g_object_unref0 (self->priv->collect_obj);
	_g_free0 (self->priv->last_search_query);
	G_OBJECT_CLASS (search_page_parent_class)->finalize (obj);
}


GType search_page_get_type (void) {
	static volatile gsize search_page_type_id__volatile = 0;
	if (g_once_init_enter (&search_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchPage), 0, (GInstanceInitFunc) search_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) search_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType search_page_type_id;
		search_page_type_id = g_type_register_static (gtk_box_get_type (), "SearchPage", &g_define_type_info, 0);
		g_type_add_interface_static (search_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&search_page_type_id__volatile, search_page_type_id);
	}
	return search_page_type_id__volatile;
}


static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_UNREAD_COUNT_PROPERTY:
		g_value_set_int (value, search_page_get_unread_count (self));
		break;
		case SEARCH_PAGE_ID_PROPERTY:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_ID_PROPERTY:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case SEARCH_PAGE_WINDOW_PROPERTY:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


LoadMoreEntry* load_more_entry_construct (GType object_type) {
	LoadMoreEntry * self = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	self = (LoadMoreEntry*) g_object_new (object_type, NULL);
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Load More"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->load_more_button);
	self->priv->load_more_button = _tmp1_;
	_tmp2_ = self->priv->load_more_button;
	_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp3_, "dim-label");
	_tmp4_ = self->priv->load_more_button;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp5_ = self->priv->load_more_button;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp6_ = self->priv->load_more_button;
	gtk_button_set_relief (_tmp6_, GTK_RELIEF_NONE);
	_tmp7_ = self->priv->load_more_button;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->load_more_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (box);
	return self;
}


LoadMoreEntry* load_more_entry_new (void) {
	return load_more_entry_construct (TYPE_LOAD_MORE_ENTRY);
}


GtkButton* load_more_entry_get_button (LoadMoreEntry* self) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_val_if_fail (IS_LOAD_MORE_ENTRY (self), NULL);
	_tmp0_ = self->priv->load_more_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint load_more_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now) {
	LoadMoreEntry * self;
	gint result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = 0;
	return result;
}


static gint64 load_more_entry_real_get_sort_factor (CbTwitterItem* base) {
	LoadMoreEntry * self;
	gint64 result = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = G_MAXINT64 - 2;
	return result;
}


static gint64 load_more_entry_real_get_timestamp (CbTwitterItem* base) {
	LoadMoreEntry * self;
	gint64 result = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = (gint64) 0;
	return result;
}


static GTimeSpan load_more_entry_real_get_last_set_timediff (CbTwitterItem* base) {
	LoadMoreEntry * self;
	GTimeSpan result = 0LL;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	_tmp0_ = self->priv->last_timediff;
	result = _tmp0_;
	return result;
}


static void load_more_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span) {
	LoadMoreEntry * self;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	_tmp0_ = span;
	self->priv->last_timediff = _tmp0_;
}


gboolean load_more_entry_get_seen (LoadMoreEntry* self) {
	gboolean result;
	g_return_val_if_fail (IS_LOAD_MORE_ENTRY (self), FALSE);
	result = TRUE;
	return result;
}


void load_more_entry_set_seen (LoadMoreEntry* self, gboolean value) {
	g_return_if_fail (IS_LOAD_MORE_ENTRY (self));
	g_object_notify_by_pspec ((GObject *) self, load_more_entry_properties[LOAD_MORE_ENTRY_SEEN_PROPERTY]);
}


static void load_more_entry_class_init (LoadMoreEntryClass * klass) {
	load_more_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoadMoreEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_load_more_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_load_more_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = load_more_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOAD_MORE_ENTRY_SEEN_PROPERTY, load_more_entry_properties[LOAD_MORE_ENTRY_SEEN_PROPERTY] = g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void load_more_entry_cb_twitter_item_interface_init (CbTwitterItemInterface * iface) {
	load_more_entry_cb_twitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*) (CbTwitterItem *, GDateTime*)) load_more_entry_real_update_time_delta;
	iface->get_sort_factor = (gint64 (*) (CbTwitterItem *)) load_more_entry_real_get_sort_factor;
	iface->get_timestamp = (gint64 (*) (CbTwitterItem *)) load_more_entry_real_get_timestamp;
	iface->get_last_set_timediff = (GTimeSpan (*) (CbTwitterItem *)) load_more_entry_real_get_last_set_timediff;
	iface->set_last_set_timediff = (void (*) (CbTwitterItem *, GTimeSpan)) load_more_entry_real_set_last_set_timediff;
}


static void load_more_entry_instance_init (LoadMoreEntry * self) {
	self->priv = LOAD_MORE_ENTRY_GET_PRIVATE (self);
}


static void load_more_entry_finalize (GObject * obj) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	_g_object_unref0 (self->priv->load_more_button);
	G_OBJECT_CLASS (load_more_entry_parent_class)->finalize (obj);
}


GType load_more_entry_get_type (void) {
	static volatile gsize load_more_entry_type_id__volatile = 0;
	if (g_once_init_enter (&load_more_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoadMoreEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) load_more_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LoadMoreEntry), 0, (GInstanceInitFunc) load_more_entry_instance_init, NULL };
		static const GInterfaceInfo cb_twitter_item_info = { (GInterfaceInitFunc) load_more_entry_cb_twitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType load_more_entry_type_id;
		load_more_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "LoadMoreEntry", &g_define_type_info, 0);
		g_type_add_interface_static (load_more_entry_type_id, CB_TYPE_TWITTER_ITEM, &cb_twitter_item_info);
		g_once_init_leave (&load_more_entry_type_id__volatile, load_more_entry_type_id);
	}
	return load_more_entry_type_id__volatile;
}


static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SEEN_PROPERTY:
		g_value_set_boolean (value, load_more_entry_get_seen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SEEN_PROPERTY:
		load_more_entry_set_seen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



