pragma Ada_95;
pragma Warnings (Off);
pragma Source_File_Name (ada_main, Spec_File_Name => "b_gnatl.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b_gnatl.adb");
pragma Suppress (Overflow_Check);

package body ada_main is

   E014 : Short_Integer; pragma Import (Ada, E014, "system__soft_links_E");
   E020 : Short_Integer; pragma Import (Ada, E020, "system__exception_table_E");
   E022 : Short_Integer; pragma Import (Ada, E022, "system__exceptions_E");
   E010 : Short_Integer; pragma Import (Ada, E010, "system__secondary_stack_E");
   E120 : Short_Integer; pragma Import (Ada, E120, "interfaces__c_E");
   E122 : Short_Integer; pragma Import (Ada, E122, "interfaces__c__strings_E");
   E070 : Short_Integer; pragma Import (Ada, E070, "system__os_lib_E");
   E058 : Short_Integer; pragma Import (Ada, E058, "system__assertions_E");
   E063 : Short_Integer; pragma Import (Ada, E063, "types_E");
   E083 : Short_Integer; pragma Import (Ada, E083, "gnatvsn_E");
   E059 : Short_Integer; pragma Import (Ada, E059, "hostparm_E");
   E056 : Short_Integer; pragma Import (Ada, E056, "output_E");
   E118 : Short_Integer; pragma Import (Ada, E118, "indepsw_E");
   E114 : Short_Integer; pragma Import (Ada, E114, "rident_E");
   E085 : Short_Integer; pragma Import (Ada, E085, "tree_io_E");
   E081 : Short_Integer; pragma Import (Ada, E081, "opt_E");
   E111 : Short_Integer; pragma Import (Ada, E111, "csets_E");
   E087 : Short_Integer; pragma Import (Ada, E087, "widechar_E");
   E077 : Short_Integer; pragma Import (Ada, E077, "namet_E");
   E054 : Short_Integer; pragma Import (Ada, E054, "butil_E");
   E116 : Short_Integer; pragma Import (Ada, E116, "casing_E");
   E098 : Short_Integer; pragma Import (Ada, E098, "fmap_E");
   E096 : Short_Integer; pragma Import (Ada, E096, "osint_E");
   E109 : Short_Integer; pragma Import (Ada, E109, "targparm_E");
   E107 : Short_Integer; pragma Import (Ada, E107, "sdefault_E");
   E094 : Short_Integer; pragma Import (Ada, E094, "fname_E");
   E052 : Short_Integer; pragma Import (Ada, E052, "ali_E");
   E126 : Short_Integer; pragma Import (Ada, E126, "snames_E");
   E128 : Short_Integer; pragma Import (Ada, E128, "switch_E");
   E002 : Short_Integer; pragma Import (Ada, E002, "gnatlink_E");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   Is_Elaborated : Boolean := False;

   procedure adafinal is
      procedure s_stalib_adafinal;
      pragma Import (C, s_stalib_adafinal, "system__standard_library__adafinal");

      procedure Runtime_Finalize;
      pragma Import (C, Runtime_Finalize, "__gnat_runtime_finalize");

   begin
      if not Is_Elaborated then
         return;
      end if;
      Is_Elaborated := False;
      Runtime_Finalize;
      s_stalib_adafinal;
   end adafinal;

   type No_Param_Proc is access procedure;

   procedure adainit is
      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Main_CPU : Integer;
      pragma Import (C, Main_CPU, "__gl_main_cpu");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");
      Bind_Env_Addr : System.Address;
      pragma Import (C, Bind_Env_Addr, "__gl_bind_env_addr");

      procedure Runtime_Initialize (Install_Handler : Integer);
      pragma Import (C, Runtime_Initialize, "__gnat_runtime_initialize");

      Finalize_Library_Objects : No_Param_Proc;
      pragma Import (C, Finalize_Library_Objects, "__gnat_finalize_library_objects");
   begin
      if Is_Elaborated then
         return;
      end if;
      Is_Elaborated := True;
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Main_CPU := -1;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      Runtime_Initialize (1);

      Finalize_Library_Objects := null;

      System.Soft_Links'Elab_Spec;
      System.Exception_Table'Elab_Body;
      E020 := E020 + 1;
      System.Exceptions'Elab_Spec;
      E022 := E022 + 1;
      System.Soft_Links'Elab_Body;
      E014 := E014 + 1;
      System.Secondary_Stack'Elab_Body;
      E010 := E010 + 1;
      Interfaces.C'Elab_Spec;
      E120 := E120 + 1;
      Interfaces.C.Strings'Elab_Spec;
      E122 := E122 + 1;
      System.Os_Lib'Elab_Body;
      E070 := E070 + 1;
      System.Assertions'Elab_Spec;
      E058 := E058 + 1;
      Types'Elab_Spec;
      E063 := E063 + 1;
      E083 := E083 + 1;
      Hostparm'Elab_Spec;
      E059 := E059 + 1;
      Output'Elab_Body;
      E056 := E056 + 1;
      E118 := E118 + 1;
      Rident'Elab_Spec;
      E114 := E114 + 1;
      Tree_Io'Elab_Spec;
      E085 := E085 + 1;
      Opt'Elab_Spec;
      E081 := E081 + 1;
      Csets'Elab_Body;
      E111 := E111 + 1;
      E087 := E087 + 1;
      Namet'Elab_Spec;
      Namet'Elab_Body;
      E077 := E077 + 1;
      E054 := E054 + 1;
      E116 := E116 + 1;
      Osint'Elab_Spec;
      Targparm'Elab_Spec;
      Fmap'Elab_Body;
      E098 := E098 + 1;
      Osint'Elab_Body;
      E096 := E096 + 1;
      Targparm'Elab_Body;
      E109 := E109 + 1;
      E107 := E107 + 1;
      Fname'Elab_Body;
      E094 := E094 + 1;
      ALI'ELAB_SPEC;
      ALI'ELAB_BODY;
      E052 := E052 + 1;
      Snames'Elab_Body;
      E126 := E126 + 1;
      E128 := E128 + 1;
      E002 := E002 + 1;
   end adainit;

   procedure Ada_Main_Program;
   pragma Import (Ada, Ada_Main_Program, "_ada_gnatlink");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure Initialize (Addr : System.Address);
      pragma Import (C, Initialize, "__gnat_initialize");

      procedure Finalize;
      pragma Import (C, Finalize, "__gnat_finalize");
      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Ada_Main_Program;
      adafinal;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ../rts/ada.o
   --   ../rts/gnat.o
   --   ../rts/interfac.o
   --   ../rts/system.o
   --   ../rts/s-addope.o
   --   ../rts/s-casuti.o
   --   ../rts/s-imenne.o
   --   ../rts/s-imgint.o
   --   ../rts/s-parame.o
   --   ../rts/s-crtl.o
   --   ../rts/i-cstrea.o
   --   ../rts/s-stoele.o
   --   ../rts/s-stache.o
   --   ../rts/s-strhas.o
   --   ../rts/s-htable.o
   --   ../rts/g-htable.o
   --   ../rts/s-string.o
   --   ../rts/s-traent.o
   --   ../rts/s-unstyp.o
   --   ../rts/s-wchcon.o
   --   ../rts/s-wchjis.o
   --   ../rts/s-wchcnv.o
   --   ../rts/s-carun8.o
   --   ../rts/s-conca2.o
   --   ../rts/s-traceb.o
   --   ../rts/s-excdeb.o
   --   ../rts/s-wchstw.o
   --   ../rts/s-exctab.o
   --   ../rts/s-except.o
   --   ../rts/s-memory.o
   --   ../rts/a-exctra.o
   --   ../rts/s-trasym.o
   --   ../rts/s-excmac.o
   --   ../rts/a-elchha.o
   --   ../rts/s-soflin.o
   --   ../rts/s-secsta.o
   --   ../rts/s-addima.o
   --   ../rts/s-stalib.o
   --   ../rts/a-except.o
   --   ../rts/a-comlin.o
   --   ../rts/i-c.o
   --   ../rts/i-cstrin.o
   --   ../rts/s-os_lib.o
   --   ../rts/s-assert.o
   --   ./debug.o
   --   ./types.o
   --   ./alloc.o
   --   ./gnatvsn.o
   --   ./hostparm.o
   --   ./output.o
   --   ./indepsw.o
   --   ./rident.o
   --   ./tree_io.o
   --   ./opt.o
   --   ./csets.o
   --   ./table.o
   --   ./widechar.o
   --   ./namet.o
   --   ./butil.o
   --   ./casing.o
   --   ./fmap.o
   --   ./osint.o
   --   ./targparm.o
   --   ./sdefault.o
   --   ./fname.o
   --   ./ali.o
   --   ./snames.o
   --   ./switch.o
   --   ./gnatlink.o
   --   -L../rts/
   --   -L./
   --   -L/cygdrive/i/szsz/tmpp/gcc/gcc-7.4.0-1.x86_64/src/gcc-7.4.0/gcc/ada/
   --   -L/usr/lib/gcc/x86_64-pc-cygwin/7.4.0/adalib/
   --   -static
   --   -lgnat
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
