; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -disable-output -passes="print<scalar-evolution>" \
; RUN:   -scalar-evolution-classify-expressions=0 2>&1 | FileCheck %s

define void @implied1(i32 %n) {
; Prove that (n s> 1) ===> (n - 1 s> 0).
; CHECK-LABEL: 'implied1'
; CHECK-NEXT:  Determining loop execution counts for: @implied1
; CHECK-NEXT:  Loop %header: backedge-taken count is (-2 + %n)
; CHECK-NEXT:  Loop %header: constant max backedge-taken count is i32 2147483645
; CHECK-NEXT:  Loop %header: symbolic max backedge-taken count is (-2 + %n)
; CHECK-NEXT:  Loop %header: Trip multiple is 1
;
entry:
  %cmp1 = icmp sgt i32 %n, 1
  %n.minus.1 = sub nsw i32 %n, 1
  call void @llvm.assume(i1 %cmp1)
  br label %header

header:
  %indvar = phi i32 [ %indvar.next, %header ], [ 0, %entry ]
  %indvar.next = add i32 %indvar, 1
  %exitcond = icmp sgt i32 %n.minus.1, %indvar.next
  br i1 %exitcond, label %header, label %exit

exit:
  ret void
}

define void @implied1_neg(i32 %n) {
; Prove that (n s> 0) =\=> (n - 1 s> 0).
; CHECK-LABEL: 'implied1_neg'
; CHECK-NEXT:  Determining loop execution counts for: @implied1_neg
; CHECK-NEXT:  Loop %header: backedge-taken count is (-1 + (1 smax (-1 + %n)<nsw>))<nsw>
; CHECK-NEXT:  Loop %header: constant max backedge-taken count is i32 2147483645
; CHECK-NEXT:  Loop %header: symbolic max backedge-taken count is (-1 + (1 smax (-1 + %n)<nsw>))<nsw>
; CHECK-NEXT:  Loop %header: Trip multiple is 1
;
entry:
  %cmp1 = icmp sgt i32 %n, 0
  %n.minus.1 = sub nsw i32 %n, 1
  call void @llvm.assume(i1 %cmp1)
  br label %header

header:
  %indvar = phi i32 [ %indvar.next, %header ], [ 0, %entry ]
  %indvar.next = add i32 %indvar, 1
  %exitcond = icmp sgt i32 %n.minus.1, %indvar.next
  br i1 %exitcond, label %header, label %exit

exit:
  ret void
}

define void @implied2(i32 %n) {
; Prove that (n u>= -1) ===> (n + 1 u>= 0).
; CHECK-LABEL: 'implied2'
; CHECK-NEXT:  Determining loop execution counts for: @implied2
; CHECK-NEXT:  Loop %header: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %header: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %header: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %header: Predicated backedge-taken count is (1 + (zext i32 %n to i64))<nuw><nsw>
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%header> Added Flags: <nusw>
; CHECK-NEXT:  Loop %header: Predicated constant max backedge-taken count is i64 4294967296
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%header> Added Flags: <nusw>
; CHECK-NEXT:  Loop %header: Predicated symbolic max backedge-taken count is (1 + (zext i32 %n to i64))<nuw><nsw>
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%header> Added Flags: <nusw>
;
entry:
  %cmp1 = icmp uge i32 %n, -1
  %n.1 = add nuw i32 %n, 1
  call void @llvm.assume(i1 %cmp1)
  br label %header

header:
  %indvar = phi i32 [ %indvar.next, %header ], [ 0, %entry ]
  %indvar.next = add i32 %indvar, 1
  %exitcond = icmp uge i32 %n.1, %indvar.next
  br i1 %exitcond, label %header, label %exit

exit:
  ret void
}

define void @implied2_neg(i32 %n) {
; Prove that (n u>= -1) =\=> (n - 1 s>= 0).
; CHECK-LABEL: 'implied2_neg'
; CHECK-NEXT:  Determining loop execution counts for: @implied2_neg
; CHECK-NEXT:  Loop %header: backedge-taken count is (-1 + (1 smax %n))<nsw>
; CHECK-NEXT:  Loop %header: constant max backedge-taken count is i32 2147483646
; CHECK-NEXT:  Loop %header: symbolic max backedge-taken count is (-1 + (1 smax %n))<nsw>
; CHECK-NEXT:  Loop %header: Trip multiple is 1
;
entry:
  %cmp1 = icmp uge i32 %n, -1
  %n.minus.1 = sub nuw nsw i32 %n, 1
  call void @llvm.assume(i1 %cmp1)
  br label %header

header:
  %indvar = phi i32 [ %indvar.next, %header ], [ 0, %entry ]
  %indvar.next = add i32 %indvar, 1
  %exitcond = icmp sge i32 %n.minus.1, %indvar.next
  br i1 %exitcond, label %header, label %exit

exit:
  ret void
}
