; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use(i32)

; PR1949

; negative test for zext/zext additions with i16
define i1 @cvt_icmp_0_zext_plus_zext_eq_i16(i16 %arg, i16 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_zext_eq_i16(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i16 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = icmp eq i16 [[TMP0]], 0
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i16 %arg to i32
  %i2 = zext i16 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, 0
  ret i1 %i4
}

; negative test for zext/zext addtions with i8
define i1 @cvt_icmp_0_zext_plus_zext_eq_i8(i8 %arg, i8 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_zext_eq_i8(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i8 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i8 %arg to i32
  %i2 = zext i8 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, 0
  ret i1 %i4
}

; start of positive tests
define i1 @cvt_icmp_neg_2_zext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_zext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, -2
  ret i1 %i4
}

define i1 @cvt_icmp_neg_1_zext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_zext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, -1
  ret i1 %i4
}

define i1 @cvt_icmp_0_zext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, 0
  ret i1 %i4
}

define i1 @cvt_icmp_0_zext_plus_zext_eq_i2(i1 %a, i1 %b) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_zext_eq_i2(
; CHECK-NEXT:    [[TMP1:%.*]] = or i1 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = xor i1 [[TMP1]], true
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a.ext = zext i1 %a to i2
  %b.ext = zext i1 %b to i2
  %add = add i2 %a.ext, %b.ext
  %cmp = icmp eq i2 %add, 0
  ret i1 %cmp
}

define i1 @cvt_icmp_1_zext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp eq i32 %i3, 1
  ret i1 %i4
}

define <2 x i1> @cvt_icmp_1_zext_plus_zext_eq_vec(<2 x i1> %arg, <2 x i1> %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_zext_eq_vec(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = xor <2 x i1> [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[I4]]
;
bb:
  %i = zext <2 x i1> %arg to <2 x i32>
  %i2 = zext <2 x i1> %arg1 to <2 x i32>
  %i3 = add <2 x i32> %i2, %i
  %i4 = icmp eq <2 x i32> %i3, <i32 1, i32 1>
  ret <2 x i1> %i4
}

define i1 @cvt_icmp_2_zext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_zext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_sext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_sext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -2
  ret i1 %t
}

define i1 @cvt_icmp_neg_1_sext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_sext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_sext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_sext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_sext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_sext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_sext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_sext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_sext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_sext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -2
  ret i1 %t
}

define i1 @cvt_icmp_neg_1_sext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_sext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_sext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_sext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_sext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_sext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_sext_plus_zext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_sext_plus_zext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_zext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_zext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ne i32 %i3, -2
  ret i1 %i4
}

define i1 @cvt_icmp_neg_1_zext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_zext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ne i32 %i3, -1
  ret i1 %i4
}

define i1 @cvt_icmp_0_zext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ne i32 %i3, 0
  ret i1 %i4
}

define i1 @cvt_icmp_1_zext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ne i32 %i3, 1
  ret i1 %i4
}

define i1 @cvt_icmp_1_zext_plus_zext_ne_extra_use_1(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_zext_ne_extra_use_1(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I:%.*]] = zext i1 [[ARG:%.*]] to i32
; CHECK-NEXT:    [[I2:%.*]] = zext i1 [[ARG1:%.*]] to i32
; CHECK-NEXT:    [[I3:%.*]] = add nuw nsw i32 [[I2]], [[I]]
; CHECK-NEXT:    call void @use(i32 [[I3]])
; CHECK-NEXT:    [[I4:%.*]] = icmp ne i32 [[I3]], 1
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  call void @use(i32 %i3)
  %i4 = icmp ne i32 %i3, 1
  ret i1 %i4
}

define i1 @cvt_icmp_1_zext_plus_zext_ne_extra_use_2(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_zext_ne_extra_use_2(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I:%.*]] = zext i1 [[ARG:%.*]] to i32
; CHECK-NEXT:    call void @use(i32 [[I]])
; CHECK-NEXT:    [[I2:%.*]] = zext i1 [[ARG1:%.*]] to i32
; CHECK-NEXT:    call void @use(i32 [[I2]])
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1]], [[ARG]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  call void @use(i32 %i)
  %i2 = zext i1 %arg1 to i32
  call void @use(i32 %i2)
  %i3 = add i32 %i2, %i
  %i4 = icmp ne i32 %i3, 1
  ret i1 %i4
}

define i1 @cvt_icmp_2_zext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_zext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_sext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_sext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -2
  ret i1 %t
}

define i1 @cvt_icmp_neg_1_sext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_sext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_sext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_sext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = or i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_sext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_sext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_sext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_sext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_sext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_sext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -2
  ret i1 %t
}

define i1 @cvt_icmp_neg_1_sext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_sext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = or i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_sext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_sext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_sext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_sext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = or i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_sext_plus_zext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_sext_plus_zext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 2
  ret i1 %t
}

define <2 x i1> @cvt_icmp_2_sext_plus_zext_ne_vec(<2 x i1> %arg, <2 x i1> %arg1) {
; CHECK-LABEL: @cvt_icmp_2_sext_plus_zext_ne_vec(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
bb:
  %i = sext <2 x i1> %arg to <2 x i32>
  %i2 = zext <2 x i1> %arg1 to <2 x i32>
  %i3 = add nsw <2 x i32> %i, %i2
  %i4 = icmp ne <2 x i32> %i3, <i32 2, i32 2>
  ret <2 x i1> %i4
}

; test if zext i1 X + sext i1 Y converted to sext i1 X + zext i1 Y
; and then processed

define i1 @cvt_icmp_neg_2_zext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_zext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -2
  ret i1 %t
}

define <2 x i1> @cvt_icmp_neg_2_zext_plus_sext_eq_vec(<2 x i1> %arg, <2 x i1> %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_zext_plus_sext_eq_vec(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
bb:
  %i = zext <2 x i1> %arg to <2 x i32>
  %i2 = sext <2 x i1> %arg1 to <2 x i32>
  %i3 = add nsw <2 x i32> %i2, %i
  %i4 = icmp eq <2 x i32> %i3, <i32 2, i32 2>
  ret <2 x i1> %i4
}

define i1 @cvt_icmp_neg_1_zext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_zext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_zext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_zext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = and i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_zext_plus_sext_eq(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_zext_plus_sext_eq(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp eq i32 %i3, 2
  ret i1 %t
}

define i1 @cvt_icmp_neg_2_zext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_2_zext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -2
  ret i1 %t
}

define i1 @cvt_icmp_neg_1_zext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_neg_1_zext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = or i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, -1
  ret i1 %t
}

define i1 @cvt_icmp_0_zext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_0_zext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[T:%.*]] = xor i1 [[ARG:%.*]], [[ARG1:%.*]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 0
  ret i1 %t
}

define i1 @cvt_icmp_1_zext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_1_zext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[T:%.*]] = or i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[T]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 1
  ret i1 %t
}

define i1 @cvt_icmp_2_zext_plus_sext_ne(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @cvt_icmp_2_zext_plus_sext_ne(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i, %i2
  %t = icmp ne i32 %i3, 2
  ret i1 %t
}

; test zext/zext additions with more than one use

define i1 @test_cvt_icmp1(i1 %arg, i1 %arg1, ptr %p) {
; CHECK-LABEL: @test_cvt_icmp1(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I2:%.*]] = zext i1 [[ARG:%.*]] to i32
; CHECK-NEXT:    store i32 [[I2]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg to i32
  store i32 %i2, ptr %p
  %i3 = load i32, ptr %p
  %i4 = add i32 %i3, %i
  %t = icmp eq i32 %i4, 1
  ret i1 %t
}

define i1 @test_cvt_icmp2(i1 %arg, i1 %arg1, ptr %p) {
; CHECK-LABEL: @test_cvt_icmp2(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I2:%.*]] = zext i1 [[ARG:%.*]] to i32
; CHECK-NEXT:    store i32 [[I2]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg to i32
  store i32 %i2, ptr %p
  %i3 = load i32, ptr %p
  %i4 = add i32 %i3, %i
  %t = icmp eq i32 %i4, 1
  ret i1 %t
}

; tests for ult
define i1 @test_zext_zext_cvt_neg_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_neg_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_0_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_0_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_neg_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_neg_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_neg_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_neg_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -1
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_0_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_0_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 0
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 1
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 2
  ret i1 %i4
}

define i1 @test_sext_zext_cvt_neg_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_zext_cvt_neg_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[ARG_NOT:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG_NOT]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -2
  ret i1 %i4
}

define i1 @test_sext_zext_cvt_neg_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_zext_cvt_neg_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -1
  ret i1 %i4
}

define i1 @test_sext_zext_cvt_0_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_zext_cvt_0_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 0
  ret i1 %i4
}

define i1 @test_sext_zext_cvt_2_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_zext_cvt_2_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[ARG_NOT:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG_NOT]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_0_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_0_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_1_ult_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_1_ult_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 1
  ret i1 %i4
}

; tests for ugt
define i1 @test_cvt_icmp4(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp4(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_neg_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_1_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_1_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_neg_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_neg_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_0_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_0_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_1_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_1_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_0_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_0_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_1_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_1_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[TMP1:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_2_ugt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_2_ugt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp5(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp5(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp uge i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp6(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp6(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ule i32 %i3, 1
  ret i1 %i4
}

; tests for sgt
define i1 @test_cvt_icmp7(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp7(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_neg_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_neg_1_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_1_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_neg_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_neg_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_0_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_0_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_1_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_1_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[ARG1_NOT:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG:%.*]], [[ARG1_NOT]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_0_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_0_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_1_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_1_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_2_sgt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_2_sgt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 2
  ret i1 %i4
}

; tests for slt
define i1 @test_zext_zext_cvt_neg_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_neg_1_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_neg_1_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_zext_cvt_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_zext_cvt_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_neg_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_neg_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_0_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_0_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[TMP0]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_sext_sext_cvt_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_sext_sext_cvt_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, -2
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_neg_1_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_neg_1_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, -1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_0_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_0_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[TMP1:%.*]] = and i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_1_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_1_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_zext_sext_cvt_2_slt_icmp(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_zext_sext_cvt_2_slt_icmp(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = zext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp8(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp8(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sge i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp9(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp9(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp10(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp10(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = and i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = zext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sle i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp11(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp11(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp12(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp12(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp uge i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp13(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp13(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp14(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp14(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = or i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ule i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp15(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp15(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp16(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp16(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sge i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp17(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp17(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp18(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp18(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = sext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sle i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp19(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp19(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = and i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ugt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp20(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp20(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I4:%.*]] = xor i1 [[ARG1:%.*]], [[ARG:%.*]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp uge i32 %i3, 1
  ret i1 %i4
}

define i1 @test_cvt_icmp21(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp21(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[ARG_NOT:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG_NOT]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ult i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp22(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp22(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp ule i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp23(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp23(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 false
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sgt i32 %i3, 2
  ret i1 %i4
}

define i1 @test_cvt_icmp24(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp24(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[ARG_NOT:%.*]] = xor i1 [[ARG:%.*]], true
; CHECK-NEXT:    [[I4:%.*]] = or i1 [[ARG1:%.*]], [[ARG_NOT]]
; CHECK-NEXT:    ret i1 [[I4]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sge i32 %i3, 0
  ret i1 %i4
}

define i1 @test_cvt_icmp25(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp25(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[ARG1:%.*]], true
; CHECK-NEXT:    [[TMP1:%.*]] = and i1 [[ARG:%.*]], [[TMP0]]
; CHECK-NEXT:    ret i1 [[TMP1]]
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp slt i32 %i3, 0
  ret i1 %i4
}

define i1 @test_cvt_icmp26(i1 %arg, i1 %arg1) {
; CHECK-LABEL: @test_cvt_icmp26(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    ret i1 true
;
bb:
  %i = sext i1 %arg to i32
  %i2 = zext i1 %arg1 to i32
  %i3 = add i32 %i2, %i
  %i4 = icmp sle i32 %i3, 1
  ret i1 %i4
}

define i1 @test1(i32 %a) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i32 [[A:%.*]], -5
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add i32 %a, 4
  %c = icmp ult i32 %b, 4
  ret i1 %c
}

define <2 x i1> @test1vec(<2 x i32> %a) {
; CHECK-LABEL: @test1vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt <2 x i32> [[A:%.*]], splat (i32 -5)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add <2 x i32> %a, <i32 4, i32 4>
  %c = icmp ult <2 x i32> %b, <i32 4, i32 4>
  ret <2 x i1> %c
}

define i1 @test2(i32 %a) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[A:%.*]], 4
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = sub i32 %a, 4
  %c = icmp ugt i32 %b, -5
  ret i1 %c
}

define <2 x i1> @test2vec(<2 x i32> %a) {
; CHECK-LABEL: @test2vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ult <2 x i32> [[A:%.*]], splat (i32 4)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = sub <2 x i32> %a, <i32 4, i32 4>
  %c = icmp ugt <2 x i32> %b, <i32 -5, i32 -5>
  ret <2 x i1> %c
}

define i1 @test3(i32 %a) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[A:%.*]], 2147483643
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add i32 %a, 4
  %c = icmp slt i32 %b, 2147483652
  ret i1 %c
}

define <2 x i1> @test3vec(<2 x i32> %a) {
; CHECK-LABEL: @test3vec(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt <2 x i32> [[A:%.*]], splat (i32 2147483643)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add <2 x i32> %a, <i32 4, i32 4>
  %c = icmp slt <2 x i32> %b, <i32 2147483652, i32 2147483652>
  ret <2 x i1> %c
}

define i1 @test4(i32 %a) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[A:%.*]], -4
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add i32 %a, 2147483652
  %c = icmp sge i32 %b, 4
  ret i1 %c
}

define { i32, i1 } @test4multiuse(i32 %a) {
; CHECK-LABEL: @test4multiuse(
; CHECK-NEXT:    [[B:%.*]] = add nsw i32 [[A:%.*]], -2147483644
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[A]], 2147483640
; CHECK-NEXT:    [[TMP:%.*]] = insertvalue { i32, i1 } undef, i32 [[B]], 0
; CHECK-NEXT:    [[RES:%.*]] = insertvalue { i32, i1 } [[TMP]], i1 [[C]], 1
; CHECK-NEXT:    ret { i32, i1 } [[RES]]
;

  %b = add nsw i32 %a, -2147483644
  %c = icmp slt i32 %b, -4

  %tmp = insertvalue { i32, i1 } undef, i32 %b, 0
  %res = insertvalue { i32, i1 } %tmp, i1 %c, 1

  ret { i32, i1 } %res
}

define <2 x i1> @test4vec(<2 x i32> %a) {
; CHECK-LABEL: @test4vec(
; CHECK-NEXT:    [[C:%.*]] = icmp slt <2 x i32> [[A:%.*]], splat (i32 -4)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add <2 x i32> %a, <i32 2147483652, i32 2147483652>
  %c = icmp sge <2 x i32> %b, <i32 4, i32 4>
  ret <2 x i1> %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; This becomes equality because it's at the limit.

define i1 @nsw_slt1(i8 %a) {
; CHECK-LABEL: @nsw_slt1(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[A:%.*]], -128
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, 100
  %c = icmp slt i8 %b, -27
  ret i1 %c
}

define <2 x i1> @nsw_slt1_splat_vec(<2 x i8> %a) {
; CHECK-LABEL: @nsw_slt1_splat_vec(
; CHECK-NEXT:    [[C:%.*]] = icmp eq <2 x i8> [[A:%.*]], splat (i8 -128)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add nsw <2 x i8> %a, <i8 100, i8 100>
  %c = icmp slt <2 x i8> %b, <i8 -27, i8 -27>
  ret <2 x i1> %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; This becomes equality because it's at the limit.

define i1 @nsw_slt2(i8 %a) {
; CHECK-LABEL: @nsw_slt2(
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[A:%.*]], 127
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, -100
  %c = icmp slt i8 %b, 27
  ret i1 %c
}

define <2 x i1> @nsw_slt2_splat_vec(<2 x i8> %a) {
; CHECK-LABEL: @nsw_slt2_splat_vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i8> [[A:%.*]], splat (i8 127)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add nsw <2 x i8> %a, <i8 -100, i8 -100>
  %c = icmp slt <2 x i8> %b, <i8 27, i8 27>
  ret <2 x i1> %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; Less than the limit, so the predicate doesn't change.

define i1 @nsw_slt3(i8 %a) {
; CHECK-LABEL: @nsw_slt3(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[A:%.*]], -126
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, 100
  %c = icmp slt i8 %b, -26
  ret i1 %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; Less than the limit, so the predicate doesn't change.

define i1 @nsw_slt4(i8 %a) {
; CHECK-LABEL: @nsw_slt4(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[A:%.*]], 126
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, -100
  %c = icmp slt i8 %b, 26
  ret i1 %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; Try sgt to make sure that works too.

define i1 @nsw_sgt1(i8 %a) {
; CHECK-LABEL: @nsw_sgt1(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[A:%.*]], 127
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, -100
  %c = icmp sgt i8 %b, 26
  ret i1 %c
}

define <2 x i1> @nsw_sgt1_splat_vec(<2 x i8> %a) {
; CHECK-LABEL: @nsw_sgt1_splat_vec(
; CHECK-NEXT:    [[C:%.*]] = icmp eq <2 x i8> [[A:%.*]], splat (i8 127)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add nsw <2 x i8> %a, <i8 -100, i8 -100>
  %c = icmp sgt <2 x i8> %b, <i8 26, i8 26>
  ret <2 x i1> %c
}

define i1 @nsw_sgt2(i8 %a) {
; CHECK-LABEL: @nsw_sgt2(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[A:%.*]], -126
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = add nsw i8 %a, 100
  %c = icmp sgt i8 %b, -26
  ret i1 %c
}

define <2 x i1> @nsw_sgt2_splat_vec(<2 x i8> %a) {
; CHECK-LABEL: @nsw_sgt2_splat_vec(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt <2 x i8> [[A:%.*]], splat (i8 -126)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = add nsw <2 x i8> %a, <i8 100, i8 100>
  %c = icmp sgt <2 x i8> %b, <i8 -26, i8 -26>
  ret <2 x i1> %c
}

; icmp Pred (add nsw X, C2), C --> icmp Pred X, (C - C2), when C - C2 does not overflow.
; Comparison with 0 doesn't need special-casing.

define i1 @slt_zero_add_nsw(i32 %a) {
; CHECK-LABEL: @slt_zero_add_nsw(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A:%.*]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %a, 1
  %cmp = icmp slt i32 %add, 0
  ret i1 %cmp
}

; The same fold should work with vectors.

define <2 x i1> @slt_zero_add_nsw_splat_vec(<2 x i8> %a) {
; CHECK-LABEL: @slt_zero_add_nsw_splat_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i8> [[A:%.*]], splat (i8 -1)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = add nsw <2 x i8> %a, <i8 1, i8 1>
  %cmp = icmp slt <2 x i8> %add, zeroinitializer
  ret <2 x i1> %cmp
}

; Test the edges - instcombine should not interfere with simplification to constants.
; Constant subtraction does not overflow, but this is false.

define i1 @nsw_slt3_ov_no(i8 %a) {
; CHECK-LABEL: @nsw_slt3_ov_no(
; CHECK-NEXT:    ret i1 false
;
  %b = add nsw i8 %a, 100
  %c = icmp slt i8 %b, -28
  ret i1 %c
}

; Test the edges - instcombine should not interfere with simplification to constants.
; Constant subtraction overflows. This is false.

define i1 @nsw_slt4_ov(i8 %a) {
; CHECK-LABEL: @nsw_slt4_ov(
; CHECK-NEXT:    ret i1 false
;
  %b = add nsw i8 %a, 100
  %c = icmp slt i8 %b, -29
  ret i1 %c
}

; Test the edges - instcombine should not interfere with simplification to constants.
; Constant subtraction overflows. This is true.

define i1 @nsw_slt5_ov(i8 %a) {
; CHECK-LABEL: @nsw_slt5_ov(
; CHECK-NEXT:    ret i1 true
;
  %b = add nsw i8 %a, -100
  %c = icmp slt i8 %b, 28
  ret i1 %c
}

; InstCombine should not thwart this opportunity to simplify completely.

define i1 @slt_zero_add_nsw_signbit(i8 %x) {
; CHECK-LABEL: @slt_zero_add_nsw_signbit(
; CHECK-NEXT:    ret i1 true
;
  %y = add nsw i8 %x, -128
  %z = icmp slt i8 %y, 0
  ret i1 %z
}

; InstCombine should not thwart this opportunity to simplify completely.

define i1 @slt_zero_add_nuw_signbit(i8 %x) {
; CHECK-LABEL: @slt_zero_add_nuw_signbit(
; CHECK-NEXT:    ret i1 true
;
  %y = add nuw i8 %x, 128
  %z = icmp slt i8 %y, 0
  ret i1 %z
}

define i1 @reduce_add_ult(i32 %in) {
; CHECK-LABEL: @reduce_add_ult(
; CHECK-NEXT:    [[A18:%.*]] = icmp ult i32 [[IN:%.*]], 9
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add nuw i32 %in, 3
  %a18 = icmp ult i32 %a6, 12
  ret i1 %a18
}

define i1 @reduce_add_ugt(i32 %in) {
; CHECK-LABEL: @reduce_add_ugt(
; CHECK-NEXT:    [[A18:%.*]] = icmp ugt i32 [[IN:%.*]], 9
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add nuw i32 %in, 3
  %a18 = icmp ugt i32 %a6, 12
  ret i1 %a18
}

define i1 @reduce_add_ule(i32 %in) {
; CHECK-LABEL: @reduce_add_ule(
; CHECK-NEXT:    [[A18:%.*]] = icmp ult i32 [[IN:%.*]], 10
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add nuw i32 %in, 3
  %a18 = icmp ule i32 %a6, 12
  ret i1 %a18
}

define i1 @reduce_add_uge(i32 %in) {
; CHECK-LABEL: @reduce_add_uge(
; CHECK-NEXT:    [[A18:%.*]] = icmp ugt i32 [[IN:%.*]], 8
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add nuw i32 %in, 3
  %a18 = icmp uge i32 %a6, 12
  ret i1 %a18
}

define i1 @ult_add_ssubov(i32 %in) {
; CHECK-LABEL: @ult_add_ssubov(
; CHECK-NEXT:    ret i1 false
;
  %a6 = add nuw i32 %in, 71
  %a18 = icmp ult i32 %a6, 3
  ret i1 %a18
}

define i1 @ult_add_nonuw(i8 %in) {
; CHECK-LABEL: @ult_add_nonuw(
; CHECK-NEXT:    [[A6:%.*]] = add i8 [[IN:%.*]], 71
; CHECK-NEXT:    [[A18:%.*]] = icmp ult i8 [[A6]], 12
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add i8 %in, 71
  %a18 = icmp ult i8 %a6, 12
  ret i1 %a18
}

define i1 @uge_add_nonuw(i32 %in) {
; CHECK-LABEL: @uge_add_nonuw(
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[IN:%.*]], -9
; CHECK-NEXT:    [[A18:%.*]] = icmp ult i32 [[TMP1]], -12
; CHECK-NEXT:    ret i1 [[A18]]
;
  %a6 = add i32 %in, 3
  %a18 = icmp uge i32 %a6, 12
  ret i1 %a18
}

; Test unsigned add overflow patterns. The div ops are only here to
; thwart complexity based canonicalization of the operand order.

define i1 @op_ugt_sum_commute1(i8 %p1, i8 %p2) {
; CHECK-LABEL: @op_ugt_sum_commute1(
; CHECK-NEXT:    [[X:%.*]] = sdiv i8 42, [[P1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = sdiv i8 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[Y]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %x = sdiv i8 42, %p1
  %y = sdiv i8 42, %p2
  %a = add i8 %x, %y
  %c = icmp ugt i8 %x, %a
  ret i1 %c
}

define <2 x i1> @op_ugt_sum_vec_commute2(<2 x i8> %p1, <2 x i8> %p2) {
; CHECK-LABEL: @op_ugt_sum_vec_commute2(
; CHECK-NEXT:    [[X:%.*]] = sdiv <2 x i8> <i8 42, i8 -42>, [[P1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = sdiv <2 x i8> <i8 42, i8 -42>, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i8> [[X]], splat (i8 -1)
; CHECK-NEXT:    [[C:%.*]] = icmp ugt <2 x i8> [[Y]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %x = sdiv <2 x i8> <i8 42, i8 -42>, %p1
  %y = sdiv <2 x i8> <i8 42, i8 -42>, %p2
  %a = add <2 x i8> %y, %x
  %c = icmp ugt <2 x i8> %x, %a
  ret <2 x i1> %c
}

define i1 @sum_ugt_op_uses(i8 %p1, i8 %p2, ptr %p3) {
; CHECK-LABEL: @sum_ugt_op_uses(
; CHECK-NEXT:    [[X:%.*]] = sdiv i8 42, [[P1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = sdiv i8 42, [[P2:%.*]]
; CHECK-NEXT:    [[A:%.*]] = add nsw i8 [[X]], [[Y]]
; CHECK-NEXT:    store i8 [[A]], ptr [[P3:%.*]], align 1
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[X]], [[A]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %x = sdiv i8 42, %p1
  %y = sdiv i8 42, %p2
  %a = add i8 %x, %y
  store i8 %a, ptr %p3
  %c = icmp ugt i8 %x, %a
  ret i1 %c
}

define <2 x i1> @sum_ult_op_vec_commute1(<2 x i8> %p1, <2 x i8> %p2) {
; CHECK-LABEL: @sum_ult_op_vec_commute1(
; CHECK-NEXT:    [[X:%.*]] = sdiv <2 x i8> <i8 42, i8 -42>, [[P1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = sdiv <2 x i8> <i8 -42, i8 42>, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i8> [[X]], splat (i8 -1)
; CHECK-NEXT:    [[C:%.*]] = icmp ugt <2 x i8> [[Y]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %x = sdiv <2 x i8> <i8 42, i8 -42>, %p1
  %y = sdiv <2 x i8> <i8 -42, i8 42>, %p2
  %a = add <2 x i8> %x, %y
  %c = icmp ult <2 x i8> %a, %x
  ret <2 x i1> %c
}

define i1 @sum_ult_op_commute2(i8 %p1, i8 %p2) {
; CHECK-LABEL: @sum_ult_op_commute2(
; CHECK-NEXT:    [[X:%.*]] = sdiv i8 42, [[P1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = sdiv i8 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[Y]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %x = sdiv i8 42, %p1
  %y = sdiv i8 42, %p2
  %a = add i8 %y, %x
  %c = icmp ult i8 %a, %x
  ret i1 %c
}

define i1 @sum_ult_op_uses(i8 %x, i8 %y, ptr %p) {
; CHECK-LABEL: @sum_ult_op_uses(
; CHECK-NEXT:    [[A:%.*]] = add i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    store i8 [[A]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[A]], [[X]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = add i8 %y, %x
  store i8 %a, ptr %p
  %c = icmp ult i8 %a, %x
  ret i1 %c
}

; X + Z >s Y + Z -> X > Y if there is no overflow.
define i1 @common_op_nsw(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nsw(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nsw i32 %x, %z
  %rhs = add nsw i32 %y, %z
  %c = icmp sgt i32 %lhs, %rhs
  ret i1 %c
}

define i1 @common_op_nsw_extra_uses(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nsw_extra_uses(
; CHECK-NEXT:    [[LHS:%.*]] = add nsw i32 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use(i32 [[LHS]])
; CHECK-NEXT:    [[RHS:%.*]] = add nsw i32 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    call void @use(i32 [[RHS]])
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nsw i32 %x, %z
  call void @use(i32 %lhs)
  %rhs = add nsw i32 %y, %z
  call void @use(i32 %rhs)
  %c = icmp sgt i32 %lhs, %rhs
  ret i1 %c
}

; X + Z >u Z + Y -> X > Y if there is no overflow.
define i1 @common_op_nuw(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nuw(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nuw i32 %x, %z
  %rhs = add nuw i32 %z, %y
  %c = icmp ugt i32 %lhs, %rhs
  ret i1 %c
}

define i1 @common_op_nuw_extra_uses(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nuw_extra_uses(
; CHECK-NEXT:    [[LHS:%.*]] = add nuw i32 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use(i32 [[LHS]])
; CHECK-NEXT:    [[RHS:%.*]] = add nuw i32 [[Z]], [[Y:%.*]]
; CHECK-NEXT:    call void @use(i32 [[RHS]])
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nuw i32 %x, %z
  call void @use(i32 %lhs)
  %rhs = add nuw i32 %z, %y
  call void @use(i32 %rhs)
  %c = icmp ugt i32 %lhs, %rhs
  ret i1 %c
}

define i1 @common_op_nsw_commute(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nsw_commute(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nsw i32 %z, %x
  %rhs = add nsw i32 %y, %z
  %c = icmp slt i32 %lhs, %rhs
  ret i1 %c
}

define i1 @common_op_nuw_commute(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @common_op_nuw_commute(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nuw i32 %z, %x
  %rhs = add nuw i32 %z, %y
  %c = icmp ult i32 %lhs, %rhs
  ret i1 %c
}

; X + Y > X -> Y > 0 if there is no overflow.
define i1 @common_op_test29(i32 %x, i32 %y) {
; CHECK-LABEL: @common_op_test29(
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nsw i32 %x, %y
  %c = icmp sgt i32 %lhs, %x
  ret i1 %c
}

; X + Y > X -> Y > 0 if there is no overflow.
define i1 @sum_nuw(i32 %x, i32 %y) {
; CHECK-LABEL: @sum_nuw(
; CHECK-NEXT:    [[C:%.*]] = icmp ne i32 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %lhs = add nuw i32 %x, %y
  %c = icmp ugt i32 %lhs, %x
  ret i1 %c
}

; X > X + Y -> 0 > Y if there is no overflow.
define i1 @sum_nsw_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @sum_nsw_commute(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[Y:%.*]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %rhs = add nsw i32 %x, %y
  %c = icmp sgt i32 %x, %rhs
  ret i1 %c
}

; X > X + Y -> 0 > Y if there is no overflow.
define i1 @sum_nuw_commute(i32 %x, i32 %y) {
; CHECK-LABEL: @sum_nuw_commute(
; CHECK-NEXT:    ret i1 false
;
  %rhs = add nuw i32 %x, %y
  %c = icmp ugt i32 %x, %rhs
  ret i1 %c
}

; PR2698 - https://bugs.llvm.org/show_bug.cgi?id=2698

declare void @use1(i1)
declare void @use8(i8)

define void @bzip1(i8 %a, i8 %b, i8 %x) {
; CHECK-LABEL: @bzip1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    call void @use1(i1 [[CMP]])
; CHECK-NEXT:    ret void
;
  %add1 = add i8 %a, %x
  %add2 = add i8 %b, %x
  %cmp = icmp eq i8 %add1, %add2
  call void @use1(i1 %cmp)
  ret void
}

define void @bzip2(i8 %a, i8 %b, i8 %x) {
; CHECK-LABEL: @bzip2(
; CHECK-NEXT:    [[ADD1:%.*]] = add i8 [[A:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[A]], [[B:%.*]]
; CHECK-NEXT:    call void @use1(i1 [[CMP]])
; CHECK-NEXT:    call void @use8(i8 [[ADD1]])
; CHECK-NEXT:    ret void
;
  %add1 = add i8 %a, %x
  %add2 = add i8 %b, %x
  %cmp = icmp eq i8 %add1, %add2
  call void @use1(i1 %cmp)
  call void @use8(i8 %add1)
  ret void
}

define <2 x i1> @icmp_eq_add_undef(<2 x i32> %a) {
; CHECK-LABEL: @icmp_eq_add_undef(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[A:%.*]], <i32 5, i32 undef>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = add <2 x i32> %a, <i32 5, i32 undef>
  %cmp = icmp eq <2 x i32> %add, <i32 10, i32 10>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_add_non_splat(<2 x i32> %a) {
; CHECK-LABEL: @icmp_eq_add_non_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[A:%.*]], <i32 5, i32 4>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = add <2 x i32> %a, <i32 5, i32 6>
  %cmp = icmp eq <2 x i32> %add, <i32 10, i32 10>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_add_undef2(<2 x i32> %a) {
; CHECK-LABEL: @icmp_eq_add_undef2(
; CHECK-NEXT:    [[ADD:%.*]] = add <2 x i32> [[A:%.*]], splat (i32 5)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[ADD]], <i32 10, i32 undef>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = add <2 x i32> %a, <i32 5, i32 5>
  %cmp = icmp eq <2 x i32> %add, <i32 10, i32 undef>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_add_non_splat2(<2 x i32> %a) {
; CHECK-LABEL: @icmp_eq_add_non_splat2(
; CHECK-NEXT:    [[ADD:%.*]] = add <2 x i32> [[A:%.*]], splat (i32 5)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i32> [[ADD]], <i32 10, i32 11>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = add <2 x i32> %a, <i32 5, i32 5>
  %cmp = icmp eq <2 x i32> %add, <i32 10, i32 11>
  ret <2 x i1> %cmp
}

define i1 @without_nsw_nuw(i8 %x, i8 %y) {
; CHECK-LABEL: @without_nsw_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[X:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add i8 %x, 37
  %t2 = add i8 %y, 35
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nsw_nuw(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nsw_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw nsw i8 [[X:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nsw nuw i8 %x, 37
  %t2 = add i8 %y, 35
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nsw_large(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nsw_large(
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i8 [[X:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nsw i8 %x, 37
  %t2 = add i8 %y, 35
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nsw_small(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nsw_small(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nsw i8 %x, 35
  %t2 = add i8 %y, 37
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nuw_large(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nuw_large(
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw i8 [[X:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nuw i8 %x, 37
  %t2 = add i8 %y, 35
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nuw_small(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nuw_small(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y:%.*]], 2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nuw i8 %x, 35
  %t2 = add i8 %y, 37
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @with_nuw_large_negative(i8 %x, i8 %y) {
; CHECK-LABEL: @with_nuw_large_negative(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[X:%.*]], -2
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TOBOOL]]
;
  %t1 = add nuw i8 %x, -37
  %t2 = add i8 %y, -35
  %tobool = icmp eq i8 %t2, %t1
  ret i1 %tobool
}

define i1 @ugt_offset(i8 %a) {
; CHECK-LABEL: @ugt_offset(
; CHECK-NEXT:    [[OV:%.*]] = icmp slt i8 [[A:%.*]], -124
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, 124
  %ov = icmp ugt i8 %t, 251
  ret i1 %ov
}

define i1 @ugt_offset_use(i32 %a) {
; CHECK-LABEL: @ugt_offset_use(
; CHECK-NEXT:    [[T:%.*]] = add i32 [[A:%.*]], 42
; CHECK-NEXT:    call void @use(i32 [[T]])
; CHECK-NEXT:    [[OV:%.*]] = icmp slt i32 [[A]], -42
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i32 %a, 42
  call void @use(i32 %t)
  %ov = icmp ugt i32 %t, 2147483689
  ret i1 %ov
}

define <2 x i1> @ugt_offset_splat(<2 x i5> %a) {
; CHECK-LABEL: @ugt_offset_splat(
; CHECK-NEXT:    [[OV:%.*]] = icmp slt <2 x i5> [[A:%.*]], splat (i5 -9)
; CHECK-NEXT:    ret <2 x i1> [[OV]]
;
  %t = add <2 x i5> %a, <i5 9, i5 9>
  %ov = icmp ugt <2 x i5> %t, <i5 24, i5 24>
  ret <2 x i1> %ov
}

; negative test - constants must differ by SMAX

define i1 @ugt_wrong_offset(i8 %a) {
; CHECK-LABEL: @ugt_wrong_offset(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[A:%.*]], 127
; CHECK-NEXT:    [[OV:%.*]] = icmp ult i8 [[TMP1]], 4
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, 123
  %ov = icmp ugt i8 %t, 251
  ret i1 %ov
}

define i1 @ugt_offset_nuw(i8 %a) {
; CHECK-LABEL: @ugt_offset_nuw(
; CHECK-NEXT:    [[OV:%.*]] = icmp slt i8 [[A:%.*]], 0
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add nuw i8 %a, 124
  %ov = icmp ugt i8 %t, 251
  ret i1 %ov
}

define i1 @ult_offset(i8 %a) {
; CHECK-LABEL: @ult_offset(
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt i8 [[A:%.*]], 5
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, 250
  %ov = icmp ult i8 %t, 122
  ret i1 %ov
}

define i1 @ult_offset_use(i32 %a) {
; CHECK-LABEL: @ult_offset_use(
; CHECK-NEXT:    [[T:%.*]] = add i32 [[A:%.*]], 42
; CHECK-NEXT:    call void @use(i32 [[T]])
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt i32 [[A]], -43
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i32 %a, 42
  call void @use(i32 %t)
  %ov = icmp ult i32 %t, 2147483690
  ret i1 %ov
}

define <2 x i1> @ult_offset_splat(<2 x i5> %a) {
; CHECK-LABEL: @ult_offset_splat(
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt <2 x i5> [[A:%.*]], splat (i5 -10)
; CHECK-NEXT:    ret <2 x i1> [[OV]]
;
  %t = add <2 x i5> %a, <i5 9, i5 9>
  %ov = icmp ult <2 x i5> %t, <i5 25, i5 25>
  ret <2 x i1> %ov
}

; negative test - constants must differ by SMIN

define i1 @ult_wrong_offset(i8 %a) {
; CHECK-LABEL: @ult_wrong_offset(
; CHECK-NEXT:    [[T:%.*]] = add i8 [[A:%.*]], -6
; CHECK-NEXT:    [[OV:%.*]] = icmp ult i8 [[T]], 123
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, 250
  %ov = icmp ult i8 %t, 123
  ret i1 %ov
}

define i1 @ult_offset_nuw(i8 %a) {
; CHECK-LABEL: @ult_offset_nuw(
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add nuw i8 %a, 42
  %ov = icmp ult i8 %t, 170
  ret i1 %ov
}

define i1 @sgt_offset(i8 %a) {
; CHECK-LABEL: @sgt_offset(
; CHECK-NEXT:    [[OV:%.*]] = icmp ult i8 [[A:%.*]], -122
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, -6
  %ov = icmp sgt i8 %t, -7
  ret i1 %ov
}

define i1 @sgt_offset_use(i32 %a) {
; CHECK-LABEL: @sgt_offset_use(
; CHECK-NEXT:    [[T:%.*]] = add i32 [[A:%.*]], 42
; CHECK-NEXT:    call void @use(i32 [[T]])
; CHECK-NEXT:    [[OV:%.*]] = icmp ult i32 [[A]], 2147483606
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i32 %a, 42
  call void @use(i32 %t)
  %ov = icmp sgt i32 %t, 41
  ret i1 %ov
}

define <2 x i1> @sgt_offset_splat(<2 x i5> %a) {
; CHECK-LABEL: @sgt_offset_splat(
; CHECK-NEXT:    [[OV:%.*]] = icmp ult <2 x i5> [[A:%.*]], splat (i5 7)
; CHECK-NEXT:    ret <2 x i1> [[OV]]
;
  %t = add <2 x i5> %a, <i5 9, i5 9>
  %ov = icmp sgt <2 x i5> %t, <i5 8, i5 8>
  ret <2 x i1> %ov
}

; negative test - constants must differ by 1

define i1 @sgt_wrong_offset(i8 %a) {
; CHECK-LABEL: @sgt_wrong_offset(
; CHECK-NEXT:    [[T:%.*]] = add i8 [[A:%.*]], -7
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt i8 [[T]], -7
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, -7
  %ov = icmp sgt i8 %t, -7
  ret i1 %ov
}

define i1 @sgt_offset_nsw(i8 %a, i8 %c) {
; CHECK-LABEL: @sgt_offset_nsw(
; CHECK-NEXT:    [[OV:%.*]] = icmp sgt i8 [[A:%.*]], -1
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add nsw i8 %a, 42
  %ov = icmp sgt i8 %t, 41
  ret i1 %ov
}

define i1 @slt_offset(i8 %a) {
; CHECK-LABEL: @slt_offset(
; CHECK-NEXT:    [[OV:%.*]] = icmp ugt i8 [[A:%.*]], -123
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, -6
  %ov = icmp slt i8 %t, -6
  ret i1 %ov
}

define i1 @slt_offset_use(i32 %a) {
; CHECK-LABEL: @slt_offset_use(
; CHECK-NEXT:    [[T:%.*]] = add i32 [[A:%.*]], 42
; CHECK-NEXT:    call void @use(i32 [[T]])
; CHECK-NEXT:    [[OV:%.*]] = icmp ugt i32 [[A]], 2147483605
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i32 %a, 42
  call void @use(i32 %t)
  %ov = icmp slt i32 %t, 42
  ret i1 %ov
}

define <2 x i1> @slt_offset_splat(<2 x i5> %a) {
; CHECK-LABEL: @slt_offset_splat(
; CHECK-NEXT:    [[OV:%.*]] = icmp ugt <2 x i5> [[A:%.*]], splat (i5 6)
; CHECK-NEXT:    ret <2 x i1> [[OV]]
;
  %t = add <2 x i5> %a, <i5 9, i5 9>
  %ov = icmp slt <2 x i5> %t, <i5 9, i5 9>
  ret <2 x i1> %ov
}

; negative test - constants must be equal

define i1 @slt_wrong_offset(i8 %a) {
; CHECK-LABEL: @slt_wrong_offset(
; CHECK-NEXT:    [[T:%.*]] = add i8 [[A:%.*]], -6
; CHECK-NEXT:    [[OV:%.*]] = icmp slt i8 [[T]], -7
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add i8 %a, -6
  %ov = icmp slt i8 %t, -7
  ret i1 %ov
}

define i1 @slt_offset_nsw(i8 %a, i8 %c) {
; CHECK-LABEL: @slt_offset_nsw(
; CHECK-NEXT:    [[OV:%.*]] = icmp slt i8 [[A:%.*]], 0
; CHECK-NEXT:    ret i1 [[OV]]
;
  %t = add nsw i8 %a, 42
  %ov = icmp slt i8 %t, 42
  ret i1 %ov
}

; In the following 4 tests, we could push the inc/dec
; through the min/max, but we should not break up the
; min/max idiom by using different icmp and select
; operands.

define i32 @increment_max(i32 %x) {
; CHECK-LABEL: @increment_max(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.smax.i32(i32 [[X:%.*]], i32 -1)
; CHECK-NEXT:    [[S:%.*]] = add nsw i32 [[TMP1]], 1
; CHECK-NEXT:    ret i32 [[S]]
;
  %a = add nsw i32 %x, 1
  %c = icmp sgt i32 %a, 0
  %s = select i1 %c, i32 %a, i32 0
  ret i32 %s
}

define i32 @decrement_max(i32 %x) {
; CHECK-LABEL: @decrement_max(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.smax.i32(i32 [[X:%.*]], i32 1)
; CHECK-NEXT:    [[S:%.*]] = add nsw i32 [[TMP1]], -1
; CHECK-NEXT:    ret i32 [[S]]
;
  %a = add nsw i32 %x, -1
  %c = icmp sgt i32 %a, 0
  %s = select i1 %c, i32 %a, i32 0
  ret i32 %s
}

define i32 @increment_min(i32 %x) {
; CHECK-LABEL: @increment_min(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.smin.i32(i32 [[X:%.*]], i32 -1)
; CHECK-NEXT:    [[S:%.*]] = add nsw i32 [[TMP1]], 1
; CHECK-NEXT:    ret i32 [[S]]
;
  %a = add nsw i32 %x, 1
  %c = icmp slt i32 %a, 0
  %s = select i1 %c, i32 %a, i32 0
  ret i32 %s
}

define i32 @decrement_min(i32 %x) {
; CHECK-LABEL: @decrement_min(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.smin.i32(i32 [[X:%.*]], i32 1)
; CHECK-NEXT:    [[S:%.*]] = add nsw i32 [[TMP1]], -1
; CHECK-NEXT:    ret i32 [[S]]
;
  %a = add nsw i32 %x, -1
  %c = icmp slt i32 %a, 0
  %s = select i1 %c, i32 %a, i32 0
  ret i32 %s
}

define i1 @icmp_add_add_C(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[A:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ult i32 %add2, %a
  ret i1 %cmp
}

define i1 @icmp_add_add_C_pred(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_pred(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[A:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp uge i32 %add2, %a
  ret i1 %cmp
}

define i1 @icmp_add_add_C_wrong_pred(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_wrong_pred(
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], -1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[ADD2]], [[A]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ule i32 %add2, %a
  ret i1 %cmp
}

define i1 @icmp_add_add_C_wrong_operand(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: @icmp_add_add_C_wrong_operand(
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], -1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD2]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ult i32 %add2, %c
  ret i1 %cmp
}

define i1 @icmp_add_add_C_different_const(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_different_const(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 -43, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP1]], [[A:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, 42
  %cmp = icmp ult i32 %add2, %a
  ret i1 %cmp
}

define <2 x i1> @icmp_add_add_C_vector(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: @icmp_add_add_C_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = sub <2 x i8> <i8 -11, i8 -21>, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i8> [[TMP1]], [[A:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add1 = add <2 x i8> %a, %b
  %add2 = add <2 x i8> %add1, <i8 10, i8 20>
  %cmp = icmp ult <2 x i8> %add2, %a
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_add_add_C_vector_undef(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: @icmp_add_add_C_vector_undef(
; CHECK-NEXT:    [[TMP1:%.*]] = sub <2 x i8> <i8 -11, i8 undef>, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i8> [[TMP1]], [[A:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add1 = add <2 x i8> %a, %b
  %add2 = add <2 x i8> %add1, <i8 10, i8 undef>
  %cmp = icmp ult <2 x i8> %add2, %a
  ret <2 x i1> %cmp
}

define i1 @icmp_add_add_C_comm1(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_comm1(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[A:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %b, %a
  %add2 = add i32 %add1, -1
  %cmp = icmp ult i32 %add2, %a
  ret i1 %cmp
}

define i1 @icmp_add_add_C_comm2(i32 %X, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_comm2(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = udiv i32 42, %X ; thwart complexity-based canonicalization
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ugt i32 %a, %add2
  ret i1 %cmp
}

define i1 @icmp_add_add_C_comm2_pred(i32 %X, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_comm2_pred(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = udiv i32 42, %X ; thwart complexity-based canonicalization
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ule i32 %a, %add2
  ret i1 %cmp
}

define i1 @icmp_add_add_C_comm2_wrong_pred(i32 %X, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_comm2_wrong_pred(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[X:%.*]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A]], [[B:%.*]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], -1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[A]], [[ADD2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = udiv i32 42, %X ; thwart complexity-based canonicalization
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  %cmp = icmp ult i32 %a, %add2
  ret i1 %cmp
}

define i1 @icmp_add_add_C_comm3(i32 %X, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_comm3(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = udiv i32 42, %X ; thwart complexity-based canonicalization
  %add1 = add i32 %b, %a
  %add2 = add i32 %add1, -1
  %cmp = icmp ugt i32 %a, %add2
  ret i1 %cmp
}

define i1 @icmp_add_add_C_extra_use1(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_extra_use1(
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], -1
; CHECK-NEXT:    call void @use(i32 [[ADD2]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD2]], [[A]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  %add2 = add i32 %add1, -1
  call void @use(i32 %add2)
  %cmp = icmp ult i32 %add2, %a
  ret i1 %cmp
}

define i1 @icmp_add_add_C_extra_use2(i32 %a, i32 %b) {
; CHECK-LABEL: @icmp_add_add_C_extra_use2(
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    call void @use(i32 [[ADD1]])
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 0, [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add1 = add i32 %a, %b
  call void @use(i32 %add1)
  %add2 = add i32 %add1, -1
  %cmp = icmp ult i32 %add2, %a
  ret i1 %cmp
}

; PR57635 - fold ULT->ULE pre-decrement of a non-zero inputs

define i1 @icmp_dec_assume_nonzero(i8 %x) {
; CHECK-LABEL: @icmp_dec_assume_nonzero(
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[Z]])
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[X]], 8
; CHECK-NEXT:    ret i1 [[C]]
;
  %z = icmp ne i8 %x, 0
  call void @llvm.assume(i1 %z)
  %i = add i8 %x, -1
  %c = icmp ult i8 %i, 7
  ret i1 %c
}

define i1 @icmp_dec_sub_assume_nonzero(i8 %x) {
; CHECK-LABEL: @icmp_dec_sub_assume_nonzero(
; CHECK-NEXT:    [[Z:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[Z]])
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[X]], 12
; CHECK-NEXT:    ret i1 [[C]]
;
  %z = icmp ne i8 %x, 0
  call void @llvm.assume(i1 %z)
  %i = sub i8 %x, 1
  %c = icmp ult i8 %i, 11
  ret i1 %c
}

define i1 @icmp_dec_nonzero(i16 %x) {
; CHECK-LABEL: @icmp_dec_nonzero(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 [[X:%.*]], 8
; CHECK-NEXT:    ret i1 [[C]]
;
  %o = or i16 %x, 4
  %i = add i16 %o, -1
  %c = icmp ult i16 %i, 7
  ret i1 %c
}

define <2 x i1> @icmp_dec_nonzero_vec(<2 x i32> %x) {
; CHECK-LABEL: @icmp_dec_nonzero_vec(
; CHECK-NEXT:    [[O:%.*]] = or <2 x i32> [[X:%.*]], splat (i32 8)
; CHECK-NEXT:    [[I:%.*]] = add nsw <2 x i32> [[O]], splat (i32 -1)
; CHECK-NEXT:    [[C:%.*]] = icmp ult <2 x i32> [[I]], <i32 15, i32 17>
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %o = or <2 x i32> %x, <i32 8, i32 8>
  %i = add <2 x i32> %o, <i32 -1, i32 -1>
  %c = icmp ult <2 x i32> %i, <i32 15, i32 17>
  ret <2 x i1> %c
}

; Negative test
define i1 @icmp_dec_notnonzero(i8 %x) {
; CHECK-LABEL: @icmp_dec_notnonzero(
; CHECK-NEXT:    [[I:%.*]] = add i8 [[X:%.*]], -1
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[I]], 11
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add i8 %x, -1
  %c = icmp ult i8 %i, 11
  ret i1 %c
}

define i1 @icmp_addnuw_nonzero(i8 %x, i8 %y) {
; CHECK-LABEL: @icmp_addnuw_nonzero(
; CHECK-NEXT:    [[TMP1:%.*]] = or i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add nuw i8 %x, %y
  %c = icmp eq i8 %i, 0
  ret i1 %c
}

define i1 @icmp_addnuw_nonzero_fail_multiuse(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_addnuw_nonzero_fail_multiuse(
; CHECK-NEXT:    [[I:%.*]] = add nuw i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[I]], 0
; CHECK-NEXT:    call void @use(i32 [[I]])
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add nuw i32 %x, %y
  %c = icmp eq i32 %i, 0
  call void @use(i32 %i)
  ret i1 %c
}

define i1 @ult_add_C2_pow2_C_neg(i8 %x) {
; CHECK-LABEL: @ult_add_C2_pow2_C_neg(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], -32
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[TMP1]], -64
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add i8 %x, 32
  %c = icmp ult i8 %i, -32
  ret i1 %c
}

define i1 @ult_add_nsw_C2_pow2_C_neg(i8 %x) {
; CHECK-LABEL: @ult_add_nsw_C2_pow2_C_neg(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], -32
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[TMP1]], -64
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add nsw i8 %x, 32
  %c = icmp ult i8 %i, -32
  ret i1 %c
}

define i1 @ult_add_nuw_nsw_C2_pow2_C_neg(i8 %x) {
; CHECK-LABEL: @ult_add_nuw_nsw_C2_pow2_C_neg(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[X:%.*]], -64
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add nuw nsw i8 %x, 32
  %c = icmp ult i8 %i, -32
  ret i1 %c
}

define i1 @ult_add_C2_neg_C_pow2(i8 %x) {
; CHECK-LABEL: @ult_add_C2_neg_C_pow2(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], -32
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[TMP1]], 32
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add i8 %x, -32
  %c = icmp ult i8 %i, 32
  ret i1 %c
}

define <2 x i1> @ult_add_C2_pow2_C_neg_vec(<2 x i8> %x) {
; CHECK-LABEL: @ult_add_C2_pow2_C_neg_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i8> [[X:%.*]], splat (i8 -32)
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i8> [[TMP1]], splat (i8 -64)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %i = add <2 x i8> %x, <i8 32, i8 32>
  %c = icmp ult <2 x i8> %i, <i8 -32, i8 -32>
  ret <2 x i1> %c
}

define i1 @ult_add_C2_pow2_C_neg_multiuse(i8 %x) {
; CHECK-LABEL: @ult_add_C2_pow2_C_neg_multiuse(
; CHECK-NEXT:    [[I:%.*]] = add i8 [[X:%.*]], 32
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[I]], -32
; CHECK-NEXT:    call void @use(i8 [[I]])
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add i8 %x, 32
  %c = icmp ult i8 %i, -32
  call void @use(i8 %i)
  ret i1 %c
}

define i1 @uge_add_C2_pow2_C_neg(i8 %x) {
; CHECK-LABEL: @uge_add_C2_pow2_C_neg(
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X:%.*]], -32
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[TMP1]], -64
; CHECK-NEXT:    ret i1 [[C]]
;
  %i = add i8 %x, 32
  %c = icmp uge i8 %i, -32
  ret i1 %c
}

declare void @llvm.assume(i1)

; Change an unsigned predicate to signed in icmp (add x, C1), C2
define i1 @icmp_add_constant_with_constant_ult_to_slt(i32 range(i32 -4, 10) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ult_to_slt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X:%.*]], 8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %x, 5
  %cmp = icmp ult i32 %add, 13
  ret i1 %cmp
}

define i1 @icmp_add_constant_with_constant_ugt_to_sgt(i32 range(i32 -4, 10) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ugt_to_sgt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], 2
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %x, 10
  %cmp = icmp ugt i32 %add, 12
  ret i1 %cmp
}

; Negative test: x + C1 may be negative
define i1 @icmp_add_constant_with_constant_ult_to_slt_neg1(i32 range(i32 -5, 10) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ult_to_slt_neg1(
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[X:%.*]], 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], 20
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %x, 4
  %cmp = icmp ult i32 %add, 20
  ret i1 %cmp
}

; Negative test: missing nsw flag
define i1 @icmp_add_constant_with_constant_ult_to_slt_neg2(i8 range(i8 -4, 120) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ult_to_slt_neg2(
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[X:%.*]], 15
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[ADD]], 20
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add i8 %x, 15
  %cmp = icmp ult i8 %add, 20
  ret i1 %cmp
}

; Negative test: C2 is negative
define i1 @icmp_add_constant_with_constant_ult_to_slt_neg3(i32 range(i32 -4, 10) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ult_to_slt_neg3(
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[X:%.*]], 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], -6
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %x, 4
  %cmp = icmp ult i32 %add, -6
  ret i1 %cmp
}

; Negative test: C2 - C1 is negative
define i1 @icmp_add_constant_with_constant_ult_to_slt_neg4(i32 range(i32 -4, 10) %x) {
; CHECK-LABEL: @icmp_add_constant_with_constant_ult_to_slt_neg4(
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[X:%.*]], 5
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], 2
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = add nsw i32 %x, 5
  %cmp = icmp ult i32 %add, 2
  ret i1 %cmp
}

; Same as before, but infer the range of ucmp
define i1 @icmp_of_ucmp_plus_const_with_const(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_of_ucmp_plus_const_with_const(
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  %cmp1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  %add = add i8 %cmp1, 1
  %cmp2 = icmp ult i8 %add, 2
  ret i1 %cmp2
}

define i1 @zext_range_check_ult(i8 %x) {
; CHECK-LABEL: @zext_range_check_ult(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i8 [[X:%.*]], -4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[TMP0]], 3
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = zext i8 %x to i32
  %add = add i32 %conv, -4
  %cmp = icmp ult i32 %add, 3
  ret i1 %cmp
}

; TODO: should be canonicalized to (x - 4) u> 2
define i1 @zext_range_check_ugt(i8 %x) {
; CHECK-LABEL: @zext_range_check_ugt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i32 [[CONV]], -7
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[TMP0]], -3
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = zext i8 %x to i32
  %add = add i32 %conv, -4
  %cmp = icmp ugt i32 %add, 2
  ret i1 %cmp
}

; TODO: should be canonicalized to (x - 4) u> 2
define i1 @zext_range_check_ult_alter(i8 %x) {
; CHECK-LABEL: @zext_range_check_ult_alter(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], -7
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], -3
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = zext i8 %x to i32
  %add = add i32 %conv, -7
  %cmp = icmp ult i32 %add, -3
  ret i1 %cmp
}

define i1 @zext_range_check_mergable(i8 %x) {
; CHECK-LABEL: @zext_range_check_mergable(
; CHECK-NEXT:    [[COND:%.*]] = icmp slt i8 [[X:%.*]], 7
; CHECK-NEXT:    ret i1 [[COND]]
;
  %conv = zext i8 %x to i32
  %add = add nsw i32 %conv, -4
  %cmp1 = icmp ult i32 %add, 3
  %cmp2 = icmp slt i8 %x, 4
  %cond = select i1 %cmp2, i1 true, i1 %cmp1
  ret i1 %cond
}

; Negative tests

define i1 @sext_range_check_ult(i8 %x) {
; CHECK-LABEL: @sext_range_check_ult(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], -4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], 3
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = sext i8 %x to i32
  %add = add i32 %conv, -4
  %cmp = icmp ult i32 %add, 3
  ret i1 %cmp
}

define i1 @zext_range_check_ult_illegal_type(i7 %x) {
; CHECK-LABEL: @zext_range_check_ult_illegal_type(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i7 [[X:%.*]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], -4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], 3
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = zext i7 %x to i32
  %add = add i32 %conv, -4
  %cmp = icmp ult i32 %add, 3
  ret i1 %cmp
}

define i1 @zext_range_check_ult_range_check_failure(i8 %x) {
; CHECK-LABEL: @zext_range_check_ult_range_check_failure(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], -4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD]], 253
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %conv = zext i8 %x to i32
  %add = add i32 %conv, -4
  %cmp = icmp ult i32 %add, 253
  ret i1 %cmp
}
