/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStopElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGStopElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGStopElementTableValues[] =
{
    { "offset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStopElementOffset), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStopElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStopElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStopElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStopElementTable = { 8, 7, JSSVGStopElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGStopElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStopElementConstructorTable = { 1, 0, JSSVGStopElementConstructorTableValues, 0 };
const ClassInfo JSSVGStopElementConstructor::s_info = { "SVGStopElementConstructor", &Base::s_info, &JSSVGStopElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGStopElementConstructor) };

JSSVGStopElementConstructor::JSSVGStopElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGStopElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGStopElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGStopElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStopElementConstructor, JSDOMWrapper>(exec, &JSSVGStopElementConstructorTable, jsCast<JSSVGStopElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGStopElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStopElementConstructor, JSDOMWrapper>(exec, &JSSVGStopElementConstructorTable, jsCast<JSSVGStopElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGStopElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStopElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStopElementPrototypeTable = { 2, 1, JSSVGStopElementPrototypeTableValues, 0 };
const ClassInfo JSSVGStopElementPrototype::s_info = { "SVGStopElementPrototype", &Base::s_info, &JSSVGStopElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGStopElementPrototype) };

JSObject* JSSVGStopElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStopElement>(exec, globalObject);
}

bool JSSVGStopElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStopElementPrototype* thisObject = jsCast<JSSVGStopElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGStopElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGStopElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStopElementPrototype* thisObject = jsCast<JSSVGStopElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGStopElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGStopElement::s_info = { "SVGStopElement", &Base::s_info, &JSSVGStopElementTable, 0 , CREATE_METHOD_TABLE(JSSVGStopElement) };

JSSVGStopElement::JSSVGStopElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStopElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGStopElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGStopElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGStopElementPrototype::create(exec->globalData(), globalObject, JSSVGStopElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGStopElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStopElement* thisObject = jsCast<JSSVGStopElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGStopElement, Base>(exec, &JSSVGStopElementTable, thisObject, propertyName, slot);
}

bool JSSVGStopElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStopElement* thisObject = jsCast<JSSVGStopElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGStopElement, Base>(exec, &JSSVGStopElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGStopElementOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStopElement* castedThis = jsCast<JSSVGStopElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStopElement* impl = static_cast<SVGStopElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->offsetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGStopElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStopElement* castedThis = jsCast<JSSVGStopElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStopElement* impl = static_cast<SVGStopElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGStopElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStopElement* castedThis = jsCast<JSSVGStopElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStopElement* impl = static_cast<SVGStopElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGStopElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStopElement* domObject = jsCast<JSSVGStopElement*>(asObject(slotBase));
    return JSSVGStopElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGStopElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGStopElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGStopElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStopElement::s_info))
        return throwVMTypeError(exec);
    JSSVGStopElement* castedThis = jsCast<JSSVGStopElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStopElement::s_info);
    SVGStopElement* impl = static_cast<SVGStopElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
