#define IN_TP_QT_HEADER
#include "TelepathyQt/channel-dispatcher.h"

namespace Tp
{
namespace Client
{

ChannelDispatcherInterface::ChannelDispatcherInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ChannelDispatcherInterface::ChannelDispatcherInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ChannelDispatcherInterface::ChannelDispatcherInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void ChannelDispatcherInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ChannelDispatcherInterfaceMessages1Interface::ChannelDispatcherInterfaceMessages1Interface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ChannelDispatcherInterfaceMessages1Interface::ChannelDispatcherInterfaceMessages1Interface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ChannelDispatcherInterfaceMessages1Interface::ChannelDispatcherInterfaceMessages1Interface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ChannelDispatcherInterfaceMessages1Interface::ChannelDispatcherInterfaceMessages1Interface(const Tp::Client::ChannelDispatcherInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ChannelDispatcherInterfaceMessages1Interface::ChannelDispatcherInterfaceMessages1Interface(const Tp::Client::ChannelDispatcherInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ChannelDispatcherInterfaceMessages1Interface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
