/* arm.v4a-linux.elf-entry.h
   created from arm.v4a-linux.elf-entry.bin, 12988 (0x32bc) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_ENTRY_SIZE    12988
#define STUB_ARM_V4A_LINUX_ELF_ENTRY_ADLER32 0x4f1b5d8d
#define STUB_ARM_V4A_LINUX_ELF_ENTRY_CRC32   0x7329d396

unsigned char stub_arm_v4a_linux_elf_entry[12988] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  44, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  17,  0, 14,  0,254,255,255,234,254,255,255,234, 63, 32,  0,226,
/* 0x0040 */  31, 48,  0,226, 26,  0, 83,227,  5,  0,  0,154, 32,  0, 16,227,
/* 0x0050 */  70, 32, 66, 18, 43, 32, 66,  2, 64,  0,130,226, 30,255, 47,225,
/* 0x0060 */   2,192,160,225, 17,  0,  0,234,  0, 32,208,229, 32, 32,130,227,
/* 0x0070 */   0, 48,209,229, 32, 48,131,227,  3, 32, 82,224, 21,  0,  0, 26,
/* 0x0080 */   1,  0,128,226,  1, 16,129,226,  1,192, 76,226,  1,  0,124,227,
/* 0x0090 */   9,  0,  0, 26,  0, 32,160,227,  2,  0,160,225, 30,255, 47,225,
/* 0x00a0 */ 112, 64, 45,233, 64,208, 77,226,  0, 80,160,225,  1, 96,160,225,
/* 0x00b0 */  13,  0,160,225,255, 16,160,227, 64, 32,160,227,254,255,255,235,
/* 0x00c0 */   5,  0,160,225, 13, 16,160,225,254,255,255,235,  0, 64, 80,226,
/* 0x00d0 */  41,  0,  0,186,184, 48,221,225, 15, 58,  3,226,  1,  9, 83,227,
/* 0x00e0 */   0, 64,160,  3, 53,  0,  0,234,  2,  0,116,227, 47,  0,  0, 26,
/* 0x00f0 */   5,  0,160,225,  7, 29,160,227,254,255,255,235,  0, 64,160,225,
/* 0x0100 */   0, 48, 86,226,  1, 48,160, 19,164, 63, 19,224,  5,  0,160, 17,
/* 0x0110 */   4, 16,160, 17,254,255,255, 27,  4,  0,160,225, 64,208,141,226,
/* 0x0120 */ 112,128,189,232,240, 65, 45,233,  0,112,160,225,  1, 96,160,225,
/* 0x0130 */  63,  0,  0,235, 47,100, 97,116, 97, 47,100, 97,116, 97, 47,  0,
/* 0x0140 */  14, 16,160,225, 11, 32,160,227,254,255,255,235,  0, 64,160,227,
/* 0x0150 */   0, 64,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x0160 */  77,  0,  0,235, 47,112,114,111, 99, 47,115,101,108,102, 47, 99,
/* 0x0170 */ 109,100,108,105,110,101,  0,  0, 14,128,160,225,  8,  0,160,225,
/* 0x0180 */   4, 16,160,225,  4, 32,160,225,254,255,255,235,  0, 64,160,225,
/* 0x0190 */   6, 16,160,225,255, 46,160,227, 15, 32,130,226,254,255,255,235,
/* 0x01a0 */   0, 80,160,225,  4,  0,160,225,254,255,255,235,  0,  0, 85,227,
/* 0x01b0 */   8,  0,160,177,254,255,255,187,  0, 48,160,227,  5, 48,198,231,
/* 0x01c0 */   0, 48,214,229,  0,  0, 83,227,  6, 16,160,  1,139,  0,  0, 10,
/* 0x01d0 */   6, 16,160,225,  1, 48,241,229,  0,  0, 83,227,100,  0,  0, 26,
/* 0x01e0 */ 139,  0,  0,234,  1, 48,116,229, 47,  0, 83,227,104,  0,  0, 26,
/* 0x01f0 */   1,128,100,224, 10,  0,135,226,  4, 16,160,225,  8, 32,160,225,
/* 0x0200 */ 254,255,255,235,  0, 80,160,225,  0, 96,160,227,  0, 96,192,229,
/* 0x0210 */   7,  0,160,225,  6, 16,160,225, 23,  0,  0,235, 13,  0,112,227,
/* 0x0220 */ 141,  0,  0, 26,126,  0,  0,235, 99,111,109, 46,116,101,114,109,
/* 0x0230 */ 117,120, 47,102,105,108,101,115,  0,  0,  0,  0, 14, 16,160,225,
/* 0x0240 */  11,  0,135,226, 16, 32,160,227,254,255,255,235,  4, 16,160,225,
/* 0x0250 */   8, 32,160,225,254,255,255,235,  0, 80,160,225,  0, 96,192,229,
/* 0x0260 */   7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,141,  0,  0,234,
/* 0x0270 */   1, 64,160,225,104,  0,  0,234,144,  0,  0,235, 47, 99, 97, 99,
/* 0x0280 */ 104,101,  0,  0, 14, 16,160,225,  5,  0,160,225,  6, 32,160,227,
/* 0x0290 */ 254,255,255,235,  0, 64,160,225,  0, 96,160,227,  0, 96,192,229,
/* 0x02a0 */   7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,157,  0,  0,235,
/* 0x02b0 */  47,117,112,120,  0,  0,  0,  0, 14, 16,160,225,  4,  0,160,225,
/* 0x02c0 */   4, 32,160,227,254,255,255,235,  0, 64,160,225,254,255,255,235,
/* 0x02d0 */   0, 80,160,225,254,255,255,235,  0,  0,196,229, 37,  3,160,225,
/* 0x02e0 */ 254,255,255,235,  1,  0,196,229, 37,  6,160,225,254,255,255,235,
/* 0x02f0 */   2,  0,196,229,  3, 96,196,229,  6,  0,160,225,240,129,189,232,
/* 0x0300 */ 240, 65, 45,233,  1,218, 77,226, 12,208, 77,226,  0,112,160,225,
/* 0x0310 */   1,128,160,225,  2, 96,160,225,183,  0,  0,235,117,112,120,  0,
/* 0x0320 */  14, 64,160,225,  4,  0,160,225, 16, 16,160,227,254,255,255,235,
/* 0x0330 */   0, 80,160,225, 22,  0,112,227,194,  0,  0, 26,  4,  0,160,225,
/* 0x0340 */   0, 16,160,227,254,255,255,235,  0, 80,160,225,  0,  0, 85,227,
/* 0x0350 */ 214,  0,  0,170,200,  0,  0,235, 47,100,101,118, 47,115,104,109,
/* 0x0360 */   0,  0,  0,  0, 14,  0,160,225, 65, 24,160,227,  2, 16,129,226,
/* 0x0370 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226,214,  0,  0,170,
/* 0x0380 */ 212,  0,  0,235,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x0390 */   0,  0,  0,  0, 14,  0,160,225,254,255,255,235, 12, 64,141,226,
/* 0x03a0 */   4,  0,160,225,254,255,255,235,219,  0,  0,235, 97,110,100,  0,
/* 0x03b0 */  14,  0,160,225,  4, 16,160,225,  3, 32,160,227,  7,  0,  0,235,
/* 0x03c0 */   0,  0, 80,227,237,  0,  0, 10,227,  0,  0,235, 76,105,110,  0,
/* 0x03d0 */  14,  0,160,225,  4, 16,160,225,  3, 32,160,227,  7,  0,  0,235,
/* 0x03e0 */   0,  0, 80,227,237,  0,  0, 26,130, 48,212,229, 52,  0, 83,227,
/* 0x03f0 */   1, 64,160,131, 15,  1,  0,138,  0,  0, 86,227,246,  0,  0, 26,
/* 0x0400 */ 254,255,255,235,  0, 96, 80,226,  2, 49,160,  3,  1, 42,141,  2,
/* 0x0410 */  12, 32,130,  2,195,105,194,  7, 12, 96,141,  2, 38,  0,117,227,
/* 0x0420 */  14,  1,  0, 26,  0,  0, 86,227, 14,  1,  0, 10,  0, 48,214,229,
/* 0x0430 */   0,  0, 83,227,  3,  1,  0, 26,  6,  0,160,225,  2, 27,141,226,
/* 0x0440 */  12, 16,129,226, 56,  0,  0,235,  0,  0, 80,227, 75,  1,  0,186,
/* 0x0450 */   6,  0,160,225,194, 16,160,227,  7, 45,160,227,254,255,255,235,
/* 0x0460 */   0, 80, 80,226,  5,  0,160,177, 75,  1,  0,186,  6,  0,160,225,
/* 0x0470 */ 254,255,255,235,  0, 64,160,227, 15,  1,  0,234,  0, 64,160,227,
/* 0x0480 */   0,  0, 87,227, 22,  1,  0, 10,254,255,255,235,  0,  0,224,225,
/* 0x0490 */   7,  0,  0,224,  7,112, 96,224,  0,128,136,224,  0,  0, 88,227,
/* 0x04a0 */  49,  1,  0, 10,  0,  0, 84,227, 32,  1,  0, 10,  5,  0,160,225,
/* 0x04b0 */   8, 16,160,225,254,255,255,235,  0,  0, 80,227, 49,  1,  0,170,
/* 0x04c0 */  75,  1,  0,234,  5,  0,160,225,  1, 16, 72,226,  0, 32,160,227,
/* 0x04d0 */ 254,255,255,235,  1, 26,224,227,  0, 64,160,227,  1, 58,141,226,
/* 0x04e0 */  12, 48,131,226,  1, 64,195,231,  5,  0,160,225,  1, 16,131,224,
/* 0x04f0 */   1, 32,160,227,254,255,255,235,  5,  0,160,225,  4, 16,160,225,
/* 0x0500 */   4, 32,160,225,254,255,255,235,  0,  0, 87,227,  1,192,160,  3,
/* 0x0510 */  61,  1,  0, 10,254,255,255,235,  0, 32,160,225,  0, 48,215,225,
/* 0x0520 */  73,  1,  0, 10,  5,  0,160,225,  7, 16,160,225,  0, 32, 98,226,
/* 0x0530 */ 254,255,255,235, 73,  1,  0,234,  0, 80,141,229,  0, 48,160,227,
/* 0x0540 */   4, 48,141,229,  7,  0,160,225,  8, 16,160,225,  3, 32,160,227,
/* 0x0550 */  12, 48,160,225,254,255,255,235,  1, 10,112,227,  1, 48,133,146,
/* 0x0560 */   3,  0,128,145, 75,  1,  0,234, 17,192,160,227, 61,  1,  0,234,
/* 0x0570 */  12,208,141,226,  1,218,141,226,240,129,189,232,240, 64, 45,233,
/* 0x0580 */   8,208, 77,226,  0,112,160,225,  1, 96,160,225,  4,  0,  0,235,
/* 0x0590 */ 117,112,120,  0, 14, 64,160,225,  4,  0,160,225, 16, 16,160,227,
/* 0x05a0 */ 254,255,255,235,  0, 80,160,225, 22,  0,112,227, 15,  0,  0, 26,
/* 0x05b0 */   4,  0,160,225,  0, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x05c0 */   0,  0, 85,227, 29,  0,  0,170, 21,  0,  0,235, 47,100,101,118,
/* 0x05d0 */  47,115,104,109,  0,  0,  0,  0, 14,  0,160,225, 65, 24,160,227,
/* 0x05e0 */   2, 16,129,226,  7, 45,160,227,254,255,255,235,  0, 80, 80,226,
/* 0x05f0 */   5, 64,160,177, 50,  0,  0,186,  5,  0,160,225,  6, 16,160,225,
/* 0x0600 */ 254,255,255,235,  0,  0, 80,227,  0, 64,160,177, 50,  0,  0,186,
/* 0x0610 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x0620 */   6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,  1, 48,160,  3,
/* 0x0630 */  17, 48,160, 19,254,255,255,235,  0, 64,160,225,254,255,255,235,
/* 0x0640 */   4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,  4,  0,160,225,
/* 0x0650 */   8,208,141,226,240,128,189,232,  0,  0,  0,  0,  3, 64, 45,233,
/* 0x0660 */  20,208, 77,226, 36,  0,141,226, 88,  0,  0,235, 88,  0,  0,235,
/* 0x0670 */   6,  0,176,232,  6,  0, 81,227, 10,  0,  0, 10,  0,  0, 81,227,
/* 0x0680 */   4,  0,  0, 26,  1, 42,160,227,  2, 32,224,225,  1, 32,130,226,
/* 0x0690 */   2,128,160,225, 72, 16, 31,229, 76,  0, 79,226,  1,  0, 64,224,
/* 0x06a0 */   8,  0,141,229,  1,144,160,225, 88,  0, 31,229, 28,  0,141,229,
/* 0x06b0 */ 128,  0,  0,235,  4,160,142,226,  0,112,154,229,  1, 12,160,227,
/* 0x06c0 */  45,  0,128,226,  0, 96,135,224, 16, 96,141,229, 13,176,160,225,
/* 0x06d0 */   0,208, 77,224,  7,208,205,227,  0,  0,160,227, 13, 16,160,225,
/* 0x06e0 */   1,  0,161,232, 11,  0, 81,225, 32,  0,  0, 58, 13, 32,160,225,
/* 0x06f0 */   6, 16,160,225,  0,  0,160,227,254,255,255,235,  2, 11, 16,227,
/* 0x0700 */  42,  0,  0, 90,240,  1,240,231, 32, 22,160,225,  1, 22,160,225,
/* 0x0710 */   1,  0, 64,224,  1,  0, 64,226,  7, 32,129,224, 20, 32,130,226,
/* 0x0720 */   7, 32,194,227,  8,  0,189,232,  8,  0,162,232, 11,  0, 93,225,
/* 0x0730 */  49,  0,  0, 58, 12, 16,141,229,  0,176,160,225, 20, 64,135,226,
/* 0x0740 */   7, 64,196,227, 28, 48,157,229,  8, 32,160,225, 28,  0,129,232,
/* 0x0750 */ 128,  0, 45,233, 13, 48,160,225, 12, 32,129,226,  8,  0,218,229,
/* 0x0760 */   1,  0, 45,233,  4, 16,154,229, 12,  0,138,226, 92,  0,  0,235,
/* 0x0770 */   8,208,141,226,  0, 80,160,227, 11, 64,160,225, 18, 48,160,227,
/* 0x0780 */   5, 32,160,227, 16, 16,157,229, 12,  0,157,229,192,112,160,227,
/* 0x0790 */   0,  0,  0,239, 11,  0,160,225,  6,112,160,227,  0,  0,  0,239,
/* 0x07a0 */   8,  0,157,229,  4, 16, 26,229,  1, 64,128,224,  2, 16,193,227,
/* 0x07b0 */   1, 80, 73,224, 48,  0,141,232, 12,192,157,229, 12,240,140,226,
/* 0x07c0 */   4, 16,144,228,  0,  0, 81,227, 88,  0,  0, 26, 14,240,160,225,
/* 0x07d0 */   0, 16,129,224, 62, 64, 45,233,  0, 80,224,227,  2, 65,160,227,
/* 0x07e0 */ 117,  0,  0,234, 26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,
/* 0x07f0 */   0, 32,132,229, 48,128,189,232,  4, 64,148,224, 14,240,160, 17,
/* 0x0800 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x0810 */   1, 16,160,227, 14,192,160,225,102,  0,  0,235,  1, 16,177,224,
/* 0x0820 */ 102,  0,  0,235,110,  0,  0, 58, 12,240,160,225,  1, 48,208,228,
/* 0x0830 */   1, 48,194,228,102,  0,  0,235,115,  0,  0, 42,108,  0,  0,235,
/* 0x0840 */   3, 48, 81,226,  0, 16,160,227,127,  0,  0, 58,  1, 80,208,228,
/* 0x0850 */   3, 84,133,225,  5, 80,240,225, 97,  0,  0, 10,102,  0,  0,235,
/* 0x0860 */   1, 16,177,224,102,  0,  0,235,  1, 16,177,224,134,  0,  0, 26,
/* 0x0870 */ 108,  0,  0,235,  2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,
/* 0x0880 */   5, 48,210,231,  1, 16, 81,226,  1, 48,194,228,136,  0,  0, 42,
/* 0x0890 */ 117,  0,  0,234,  0,  0,224,227,  0,  6,160,225, 14,240,160,225,
/* 0x08a0 */ 240,  1,240,231, 14,240,160,225,  0,  0, 82,227,  7,  0,  0, 10,
/* 0x08b0 */   0, 64,160,225,  1, 48,209,228,  1, 32, 66,226,  1, 48,192,228,
/* 0x08c0 */   3,  0,  0, 26,  4,  0,160,225, 14,240,160,225,  0,  0, 82,227,
/* 0x08d0 */  15,  0,  0, 10,  0, 48,160,225,  1, 16,192,228,  1, 32, 82,226,
/* 0x08e0 */  12,  0,  0, 26,  3,  0,160,225, 14,240,160,225,  0,  0, 82,227,
/* 0x08f0 */  23,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,  1, 48,192,228,
/* 0x0900 */  19,  0,  0, 26, 14,240,160,225,  7,192,160,225,  7,192,160,225,
/* 0x0910 */ 129,112,160,227,  1,124,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0920 */  12,112,160,225, 14,240,160,225,  7,192,160,225,  6,112,160,227,
/* 0x0930 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0940 */   1,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0950 */   7,192,160,225,148,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0960 */  14,240,160,225,  7,192,160,225,118,112,160,227,  0,  0,  0,239,
/* 0x0970 */  12,112,160,225, 14,240,160,225,  7,192,160,225, 93,112,160,227,
/* 0x0980 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0990 */  20,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x09a0 */   7,192,160,225, 19,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x09b0 */  14,240,160,225,  7,192,160,225, 39,112,160,227,  0,  0,  0,239,
/* 0x09c0 */  12,112,160,225, 14,240,160,225,  7,192,160,225,  5,112,160,227,
/* 0x09d0 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x09e0 */   3,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x09f0 */   7,192,160,225,106,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0a00 */  14,240,160,225,  7,192,160,225,122,112,160,227,  0,  0,  0,239,
/* 0x0a10 */  12,112,160,225, 14,240,160,225,  7,192,160,225, 10,112,160,227,
/* 0x0a20 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0a30 */   4,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0a40 */   0,112,160,227,  7,118,160,225,  0,112,199,225,  7,  0, 64,224,
/* 0x0a50 */   7, 16,129,224,  7,192,160,225,144,112,160,227,  0,  0,  0,239,
/* 0x0a60 */  12,112,160,225, 14,240,160,225,240,  1,240,231, 14,240,160,225,
/* 0x0a70 */  48, 64, 45,233, 16, 80,157,229, 12, 64,157,229, 37, 86,160,225,
/* 0x0a80 */   0,192,224,227, 12,198,160,225, 12,192,192,225, 12,  0, 64,224,
/* 0x0a90 */  12, 16,129,224,  7,192,160,225,192,112,160,227,  0,  0,  0,239,
/* 0x0aa0 */  12,112,160,225, 48,128,189,232, 14,192,160,225, 15,224,160,225,
/* 0x0ab0 */  12,240,160,225,  0,  0,  0,  0,  0, 46,115,121,109,116, 97, 98,
/* 0x0ac0 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x0ad0 */  97, 98,  0, 69, 76, 70, 77, 65, 73, 78, 89,  0, 46,114,101,108,
/* 0x0ae0 */  72, 85, 77, 70, 95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95,
/* 0x0af0 */  76,  0, 46,114,101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x0b00 */  68,  0, 46,114,101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0,
/* 0x0b10 */  46,114,101,108, 69, 76, 70, 77, 65, 73, 78, 88,  0, 46,114,101,
/* 0x0b20 */ 108, 69, 76, 70, 77, 65, 73, 78, 90,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   0,  0,  0,  0, 27,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0b60 */   0,  0,  0,  0, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b70 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,
/* 0x0b80 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,
/* 0x0b90 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0ba0 */   0,  0,  0,  0, 36,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,128, 17,  0,  0,  8,  0,  0,  0, 15,  0,  0,  0,
/* 0x0bc0 */   2,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 51,  0,  0,  0,
/* 0x0bd0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0,
/* 0x0be0 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0bf0 */   0,  0,  0,  0, 47,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,136, 17,  0,  0,  8,  0,  0,  0, 15,  0,  0,  0,
/* 0x0c10 */   4,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 62,  0,  0,  0,
/* 0x0c20 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,
/* 0x0c30 */  64,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c40 */   0,  0,  0,  0, 58,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c50 */   0,  0,  0,  0,144, 17,  0,  0,192,  2,  0,  0, 15,  0,  0,  0,
/* 0x0c60 */   6,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 78,  0,  0,  0,
/* 0x0c70 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,124,  5,  0,  0,
/* 0x0c80 */ 220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c90 */   0,  0,  0,  0, 74,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ca0 */   0,  0,  0,  0, 80, 20,  0,  0, 96,  0,  0,  0, 15,  0,  0,  0,
/* 0x0cb0 */   8,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 92,  0,  0,  0,
/* 0x0cc0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 88,  6,  0,  0,
/* 0x0cd0 */  72,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x0ce0 */   0,  0,  0,  0, 88,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  0,176, 20,  0,  0,216,  0,  0,  0, 15,  0,  0,  0,
/* 0x0d00 */  10,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,105,  0,  0,  0,
/* 0x0d10 */   1,  0,  0,  0,  6,  0,  0,  0, 72,  2,  0,  0,160,  8,  0,  0,
/* 0x0d20 */  24,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0d30 */   0,  0,  0,  0,101,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d40 */   0,  0,  0,  0,136, 21,  0,  0, 56,  0,  0,  0, 15,  0,  0,  0,
/* 0x0d50 */  12,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 17,  0,  0,  0,
/* 0x0d60 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,184, 10,  0,  0,
/* 0x0d70 */ 114,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0d80 */   0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,212, 13,  0,  0,128,  2,  0,  0, 16,  0,  0,  0,
/* 0x0da0 */   8,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,
/* 0x0db0 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84, 16,  0,  0,
/* 0x0dc0 */  43,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0df0 */   3,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e00 */   3,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e10 */   3,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e20 */   3,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e30 */   3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e40 */   3,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e50 */   3,  0,  4,  0,  1,  0,  0,  0, 60,  2,  0,  0,  0,  0,  0,  0,
/* 0x0e60 */  16,  0, 10,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e70 */  16,  0,  0,  0, 20,  0,  0,  0,236,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e80 */  16,  0, 12,  0, 27,  0,  0,  0, 72,  2,  0,  0,  0,  0,  0,  0,
/* 0x0e90 */  16,  0, 10,  0, 43,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ea0 */  16,  0, 12,  0, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0eb0 */  16,  0,  0,  0, 58,  0,  0,  0,160,  1,  0,  0,  0,  0,  0,  0,
/* 0x0ec0 */  16,  0, 12,  0, 64,  0,  0,  0, 76,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ed0 */  16,  0, 12,  0, 72,  0,  0,  0,216,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ee0 */  16,  0, 12,  0, 82,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
/* 0x0ef0 */  16,  0, 12,  0, 88,  0,  0,  0,196,  2,  0,  0,124,  2,  0,  0,
/* 0x0f00 */  18,  0,  6,  0,112,  0,  0,  0,208,  1,  0,  0,  0,  0,  0,  0,
/* 0x0f10 */  16,  0, 12,  0,117,  0,  0,  0,  0,  0,  0,  0,220,  0,  0,  0,
/* 0x0f20 */  18,  0,  8,  0,139,  0,  0,  0,100,  1,  0,  0,  0,  0,  0,  0,
/* 0x0f30 */  16,  0, 12,  0,145,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f40 */  16,  0,  1,  0,160,  0,  0,  0,140,  1,  0,  0,  0,  0,  0,  0,
/* 0x0f50 */  16,  0, 12,  0,166,  0,  0,  0,176,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f60 */  16,  0, 12,  0,176,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f70 */  16,  0, 12,  0,191,  0,  0,  0,104,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f80 */  16,  0, 12,  0,204,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f90 */  16,  0, 10,  0,211,  0,  0,  0, 60,  1,  0,  0,  0,  0,  0,  0,
/* 0x0fa0 */  16,  0, 12,  0,216,  0,  0,  0,120,  1,  0,  0,  0,  0,  0,  0,
/* 0x0fb0 */  16,  0, 12,  0,223,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fc0 */  16,  0, 12,  0,230,  0,  0,  0,120,  1,  0,  0,196,  0,  0,  0,
/* 0x0fd0 */  18,  0, 10,  0,253,  0,  0,  0,200,  1,  0,  0,  0,  0,  0,  0,
/* 0x0fe0 */  16,  0, 12,  0,  5,  1,  0,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ff0 */  16,  0, 12,  0, 11,  1,  0,  0, 80,  1,  0,  0,  0,  0,  0,  0,
/* 0x1000 */  16,  0, 12,  0, 16,  1,  0,  0, 24,  2,  0,  0,  0,  0,  0,  0,
/* 0x1010 */  16,  0, 12,  0, 21,  1,  0,  0,156,  0,  0,  0,  0,  0,  0,  0,
/* 0x1020 */  16,  0, 12,  0, 26,  1,  0,  0, 40,  1,  0,  0,  0,  0,  0,  0,
/* 0x1030 */  16,  0, 12,  0, 31,  1,  0,  0, 20,  1,  0,  0,  0,  0,  0,  0,
/* 0x1040 */  16,  0, 12,  0, 37,  1,  0,  0,136,  0,  0,  0,  0,  0,  0,  0,
/* 0x1050 */  16,  0, 12,  0,  0,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x1060 */ 115,107,  0, 77, 70, 76, 71,  0,103,101,116,112,105,100,  0,117,
/* 0x1070 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,  0,109,
/* 0x1080 */ 101,109, 99,112,121,  0, 79, 95, 66, 73, 78, 70, 79,  0, 80,115,
/* 0x1090 */ 121,110, 99,  0,109,101,109,112, 99,112,121,  0,102,116,114,117,
/* 0x10a0 */ 110, 99, 97,116,101,  0,108,115,101,101,107,  0,117,112,120, 95,
/* 0x10b0 */ 109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,
/* 0x10c0 */ 111,105,100,  0,109,109, 97,112,  0,117,112,120, 95,109,109, 97,
/* 0x10d0 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,  0,117,
/* 0x10e0 */ 110, 97,109,101,  0,101,110,100, 95,100,101, 99,111,109,112,114,
/* 0x10f0 */ 101,115,115,  0,119,114,105,116,101,  0,102,100, 97,116, 97,115,
/* 0x1100 */ 121,110, 99,  0,103,101,116, 95,117,112,120,102,110, 95,112, 97,
/* 0x1110 */ 116,104,  0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,
/* 0x1120 */  95,115,116, 97,114,116,  0,114,101, 97,100,  0,117,110,108,105,
/* 0x1130 */ 110,107,  0,109,101,109,115,101,116,  0,117, 99,108, 95,110,114,
/* 0x1140 */ 118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x1150 */   0,109,121, 95, 98,107,112,116,  0,102,115,121,110, 99,  0,115,
/* 0x1160 */ 116, 97,116,  0, 99,112,114, 48,  0,101,120,105,116,  0,111,112,
/* 0x1170 */ 101,110,  0,109,107,100,105,114,  0, 99,108,111,115,101,  0,  0,
/* 0x1180 */   0,  0,  0,  0,  1, 18,  0,  0,  0,  0,  0,  0,  1, 20,  0,  0,
/* 0x1190 */  12,  0,  0,  0,  1,  1,  0,  0, 40,  0,  0,  0,  1,  1,  0,  0,
/* 0x11a0 */  64,  0,  0,  0,  1,  1,  0,  0, 84,  0,  0,  0,  1,  1,  0,  0,
/* 0x11b0 */ 128,  0,  0,  0,  1, 30,  0,  0,140,  0,  0,  0,  1, 34,  0,  0,
/* 0x11c0 */ 148,  0,  0,  0,  1,  1,  0,  0,168,  0,  0,  0,  1,  1,  0,  0,
/* 0x11d0 */ 176,  0,  0,  0,  1,  1,  0,  0,188,  0,  0,  0,  1, 38,  0,  0,
/* 0x11e0 */ 216,  0,  0,  0,  1, 32,  0,  0,244,  0,  0,  0,  1,  1,  0,  0,
/* 0x11f0 */  12,  1,  0,  0,  1, 15,  0,  0, 32,  1,  0,  0,  1,  1,  0,  0,
/* 0x1200 */  36,  1,  0,  0,  1,  1,  0,  0, 76,  1,  0,  0,  1, 37,  0,  0,
/* 0x1210 */  96,  1,  0,  0,  1, 28,  0,  0,108,  1,  0,  0,  1, 39,  0,  0,
/* 0x1220 */ 120,  1,  0,  0,  1, 32,  0,  0,144,  1,  0,  0,  1,  1,  0,  0,
/* 0x1230 */ 160,  1,  0,  0,  1,  1,  0,  0,164,  1,  0,  0,  1,  1,  0,  0,
/* 0x1240 */ 176,  1,  0,  0,  1,  1,  0,  0,196,  1,  0,  0,  1, 15,  0,  0,
/* 0x1250 */ 220,  1,  0,  0,  1,  1,  0,  0,228,  1,  0,  0,  1,  1,  0,  0,
/* 0x1260 */ 232,  1,  0,  0,  1,  1,  0,  0, 12,  2,  0,  0,  1, 15,  0,  0,
/* 0x1270 */  24,  2,  0,  0,  1, 15,  0,  0, 44,  2,  0,  0,  1,  1,  0,  0,
/* 0x1280 */  48,  2,  0,  0,  1,  1,  0,  0, 56,  2,  0,  0,  1,  1,  0,  0,
/* 0x1290 */  60,  2,  0,  0,  1,  1,  0,  0, 84,  2,  0,  0,  1, 15,  0,  0,
/* 0x12a0 */ 108,  2,  0,  0,  1,  1,  0,  0,112,  2,  0,  0,  1,  1,  0,  0,
/* 0x12b0 */ 136,  2,  0,  0,  1, 15,  0,  0,144,  2,  0,  0,  1, 10,  0,  0,
/* 0x12c0 */ 152,  2,  0,  0,  1,  1,  0,  0,164,  2,  0,  0,  1,  1,  0,  0,
/* 0x12d0 */ 176,  2,  0,  0,  1,  1,  0,  0,220,  2,  0,  0,  1,  1,  0,  0,
/* 0x12e0 */ 240,  2,  0,  0,  1, 26,  0,  0,252,  2,  0,  0,  1,  1,  0,  0,
/* 0x12f0 */   8,  3,  0,  0,  1, 26,  0,  0, 20,  3,  0,  0,  1,  1,  0,  0,
/* 0x1300 */  24,  3,  0,  0,  1,  1,  0,  0, 56,  3,  0,  0,  1, 37,  0,  0,
/* 0x1310 */  64,  3,  0,  0,  1,  1,  0,  0, 68,  3,  0,  0,  1,  1,  0,  0,
/* 0x1320 */  92,  3,  0,  0,  1, 32,  0,  0,104,  3,  0,  0,  1, 21,  0,  0,
/* 0x1330 */ 108,  3,  0,  0,  1,  1,  0,  0,128,  3,  0,  0,  1,  1,  0,  0,
/* 0x1340 */ 136,  3,  0,  0,  1,  1,  0,  0,140,  3,  0,  0,  1,  1,  0,  0,
/* 0x1350 */ 160,  3,  0,  0,  1,  1,  0,  0,168,  3,  0,  0,  1,  1,  0,  0,
/* 0x1360 */ 184,  3,  0,  0,  1,  1,  0,  0,192,  3,  0,  0,  1,  1,  0,  0,
/* 0x1370 */ 196,  3,  0,  0,  1, 25,  0,  0,228,  3,  0,  0,  1,  1,  0,  0,
/* 0x1380 */ 236,  3,  0,  0,  1,  1,  0,  0,248,  3,  0,  0,  1,  1,  0,  0,
/* 0x1390 */   8,  4,  0,  0,  1,  1,  0,  0, 16,  4,  0,  0,  1,  1,  0,  0,
/* 0x13a0 */  32,  4,  0,  0,  1, 37,  0,  0, 44,  4,  0,  0,  1,  1,  0,  0,
/* 0x13b0 */  52,  4,  0,  0,  1, 29,  0,  0, 60,  4,  0,  0,  1,  1,  0,  0,
/* 0x13c0 */  72,  4,  0,  0,  1,  1,  0,  0, 76,  4,  0,  0,  1,  8,  0,  0,
/* 0x13d0 */ 100,  4,  0,  0,  1,  1,  0,  0,108,  4,  0,  0,  1,  1,  0,  0,
/* 0x13e0 */ 120,  4,  0,  0,  1, 16,  0,  0,128,  4,  0,  0,  1,  1,  0,  0,
/* 0x13f0 */ 132,  4,  0,  0,  1,  1,  0,  0,148,  4,  0,  0,  1, 17,  0,  0,
/* 0x1400 */ 184,  4,  0,  0,  1, 23,  0,  0,200,  4,  0,  0,  1, 17,  0,  0,
/* 0x1410 */ 212,  4,  0,  0,  1,  1,  0,  0,216,  4,  0,  0,  1,  8,  0,  0,
/* 0x1420 */ 228,  4,  0,  0,  1,  1,  0,  0,244,  4,  0,  0,  1, 23,  0,  0,
/* 0x1430 */ 248,  4,  0,  0,  1,  1,  0,  0, 24,  5,  0,  0,  1, 19,  0,  0,
/* 0x1440 */  40,  5,  0,  0,  1,  1,  0,  0, 48,  5,  0,  0,  1,  1,  0,  0,
/* 0x1450 */  16,  0,  0,  0,  1,  2,  0,  0, 36,  0,  0,  0,  1, 26,  0,  0,
/* 0x1460 */  48,  0,  0,  0,  1,  2,  0,  0, 60,  0,  0,  0,  1, 26,  0,  0,
/* 0x1470 */  72,  0,  0,  0,  1,  2,  0,  0, 76,  0,  0,  0,  1,  2,  0,  0,
/* 0x1480 */ 108,  0,  0,  0,  1, 37,  0,  0,120,  0,  0,  0,  1,  2,  0,  0,
/* 0x1490 */ 132,  0,  0,  0,  1, 16,  0,  0,144,  0,  0,  0,  1,  2,  0,  0,
/* 0x14a0 */ 184,  0,  0,  0,  1, 19,  0,  0,192,  0,  0,  0,  1,  8,  0,  0,
/* 0x14b0 */   0,  0,  0,  0,  2,  9,  0,  0, 16,  0,  0,  0,  1,  3,  0,  0,
/* 0x14c0 */  20,  0,  0,  0,  1,  3,  0,  0, 32,  0,  0,  0,  1,  3,  0,  0,
/* 0x14d0 */  40,  0,  0,  0,  1,  3,  0,  0, 88,  0,  0,  0,  1,  4,  0,  0,
/* 0x14e0 */ 144,  0,  0,  0,  1,  3,  0,  0,160,  0,  0,  0,  1, 11,  0,  0,
/* 0x14f0 */ 168,  0,  0,  0,  1,  3,  0,  0,216,  0,  0,  0,  1,  3,  0,  0,
/* 0x1500 */  20,  1,  0,  0,  1,  3,  0,  0,112,  1,  0,  0,  1,  3,  0,  0,
/* 0x1510 */ 136,  1,  0,  0,  1,  3,  0,  0,192,  1,  0,  0,  1,  3,  0,  0,
/* 0x1520 */ 200,  1,  0,  0,  1,  3,  0,  0,204,  1,  0,  0,  1,  3,  0,  0,
/* 0x1530 */ 220,  1,  0,  0,  1,  3,  0,  0,224,  1,  0,  0,  1,  3,  0,  0,
/* 0x1540 */ 228,  1,  0,  0,  1,  3,  0,  0,240,  1,  0,  0,  1,  3,  0,  0,
/* 0x1550 */   0,  2,  0,  0,  1,  3,  0,  0,  4,  2,  0,  0,  1,  3,  0,  0,
/* 0x1560 */  12,  2,  0,  0,  1,  3,  0,  0, 20,  2,  0,  0,  1,  3,  0,  0,
/* 0x1570 */  24,  2,  0,  0,  1,  3,  0,  0, 52,  2,  0,  0,  1,  3,  0,  0,
/* 0x1580 */  56,  2,  0,  0,  1,  3,  0,  0, 12,  0,  0,  0,  1,  4,  0,  0,
/* 0x1590 */  32,  0,  0,  0,  1,  4,  0,  0, 48,  0,  0,  0,  1,  4,  0,  0,
/* 0x15a0 */  64,  0,  0,  0,  1,  4,  0,  0, 80,  0,  0,  0,  1,  4,  0,  0,
/* 0x15b0 */  96,  0,  0,  0,  1,  4,  0,  0, 20,  2,  0,  0,  2, 13,  0,  0,
/* 0x15c0 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x15d0 */  50, 45,108,105,116,116,108,101, 97,114,109, 10, 10, 83,101, 99,
/* 0x15e0 */ 116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,
/* 0x15f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,
/* 0x1600 */  32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x1610 */  32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,
/* 0x1620 */  32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,
/* 0x1630 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48,
/* 0x1640 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1650 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x1660 */  72, 85, 77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x1670 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1680 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32,
/* 0x1690 */  72, 85, 77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x16a0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 56, 32, 32, 50, 42, 42,
/* 0x16b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32,
/* 0x16c0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 53,
/* 0x16d0 */  52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 99, 32, 32, 50,
/* 0x16e0 */  42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x16f0 */  52, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32,
/* 0x1700 */  48,100, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 55, 99, 32,
/* 0x1710 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1720 */  32, 32, 53, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32,
/* 0x1730 */  32, 32, 48, 50, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54,
/* 0x1740 */  53, 56, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1750 */  84, 83, 10, 32, 32, 54, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1760 */  32, 32, 32, 32, 32, 48, 50, 49, 56, 32, 32, 48, 50, 52, 56, 32,
/* 0x1770 */  32, 48, 50, 52, 56, 32, 32, 48, 56, 97, 48, 32, 32, 50, 42, 42,
/* 0x1780 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66,
/* 0x1790 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x17a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65,
/* 0x17b0 */  78, 68, 82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x17c0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x17d0 */  32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32,
/* 0x17e0 */  48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48,
/* 0x17f0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70,
/* 0x1800 */  77, 65, 73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1810 */  10, 48, 48, 48, 48, 48, 50, 52, 56, 32,108, 32, 32, 32, 32,100,
/* 0x1820 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70,
/* 0x1830 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1840 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32,
/* 0x1850 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48,
/* 0x1860 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70,
/* 0x1870 */  95, 65, 32, 48, 32, 72, 85, 77, 70, 95, 65, 10, 48, 48, 48, 48,
/* 0x1880 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77,
/* 0x1890 */  70, 95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48, 48,
/* 0x18a0 */  48, 48, 50, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x18b0 */  70, 77, 65, 73, 78, 88, 32, 48, 32,103,101,116, 95,112, 97,103,
/* 0x18c0 */ 101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x18d0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x18e0 */  77, 70, 76, 71, 10, 48, 48, 48, 48, 48, 51, 51, 52, 32,103, 32,
/* 0x18f0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x1900 */  32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48, 50, 52, 56,
/* 0x1910 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1920 */  88, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x1930 */  95,102,100, 10, 48, 48, 48, 48, 48, 50, 53, 48, 32,103, 32, 32,
/* 0x1940 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1950 */ 109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1960 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x1970 */  79, 95, 66, 73, 78, 70, 79, 10, 48, 48, 48, 48, 48, 51,101, 56,
/* 0x1980 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1990 */  90, 32, 48, 32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 50,
/* 0x19a0 */  57, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x19b0 */  73, 78, 90, 32, 48, 32,109,101,109,112, 99,112,121, 10, 48, 48,
/* 0x19c0 */  48, 48, 48, 51, 50, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x19d0 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,116,114,117,110, 99,
/* 0x19e0 */  97,116,101, 10, 48, 48, 48, 48, 48, 51, 52, 56, 32,103, 32, 32,
/* 0x19f0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1a00 */ 108,115,101,101,107, 10, 48, 48, 48, 48, 48, 50, 99, 52, 32,103,
/* 0x1a10 */  32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1a20 */  73, 68, 32, 48, 50, 55, 99, 32,117,112,120, 95,109,109, 97,112,
/* 0x1a30 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100, 10,
/* 0x1a40 */  48, 48, 48, 48, 48, 52, 49, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1a50 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,109, 97,112,
/* 0x1a60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1a70 */  70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,100, 99, 32,
/* 0x1a80 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x1a90 */ 108,105,110,117,120, 10, 48, 48, 48, 48, 48, 51, 97, 99, 32,103,
/* 0x1aa0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1ab0 */  48, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ac0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1ad0 */  89, 32, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,
/* 0x1ae0 */ 115,115, 10, 48, 48, 48, 48, 48, 51,100, 52, 32,103, 32, 32, 32,
/* 0x1af0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,119,
/* 0x1b00 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 50,102, 56, 32,103, 32,
/* 0x1b10 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x1b20 */  32,102,100, 97,116, 97,115,121,110, 99, 10, 48, 48, 48, 48, 48,
/* 0x1b30 */  50, 52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1b40 */  65, 73, 78, 90, 32, 48, 32,103,101,116, 95,117,112,120,102,110,
/* 0x1b50 */  95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 50, 98, 48, 32,103,
/* 0x1b60 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1b70 */  48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x1b80 */  48, 48, 48, 48, 48, 48, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b90 */  69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,114,
/* 0x1ba0 */ 116, 10, 48, 48, 48, 48, 48, 51, 56, 52, 32,103, 32, 32, 32, 32,
/* 0x1bb0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,114,101,
/* 0x1bc0 */  97,100, 10, 48, 48, 48, 48, 48, 51, 99, 48, 32,103, 32, 32, 32,
/* 0x1bd0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,
/* 0x1be0 */ 110,108,105,110,107, 10, 48, 48, 48, 48, 48, 50, 55, 52, 32,103,
/* 0x1bf0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1c00 */  48, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 49, 55,
/* 0x1c10 */  56, 32,103, 32, 32, 32, 32, 32, 70, 32, 69, 76, 70, 77, 65, 73,
/* 0x1c20 */  78, 88, 32, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50, 98,
/* 0x1c30 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x1c40 */  48, 48, 48, 52, 49, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1c50 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,121, 95, 98,107,112,
/* 0x1c60 */ 116, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32,103, 32, 32, 32, 32,
/* 0x1c70 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,115,
/* 0x1c80 */ 121,110, 99, 10, 48, 48, 48, 48, 48, 51, 57, 56, 32,103, 32, 32,
/* 0x1c90 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1ca0 */ 115,116, 97,116, 10, 48, 48, 48, 48, 48, 52, 54, 48, 32,103, 32,
/* 0x1cb0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x1cc0 */  32, 99,112,114, 48, 10, 48, 48, 48, 48, 48, 50,101, 52, 32,103,
/* 0x1cd0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1ce0 */  48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 51, 55, 48, 32,
/* 0x1cf0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1d00 */  32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 51, 53, 99,
/* 0x1d10 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1d20 */  90, 32, 48, 32,109,107,100,105,114, 10, 48, 48, 48, 48, 48, 50,
/* 0x1d30 */ 100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1d40 */  73, 78, 90, 32, 48, 32, 99,108,111,115,101, 10, 10, 82, 69, 76,
/* 0x1d50 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x1d60 */  70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58, 10, 79, 70,
/* 0x1d70 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1d90 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1da0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x1db0 */  97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,
/* 0x1dc0 */ 100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1dd0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95,
/* 0x1de0 */  76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x1df0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1e00 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,
/* 0x1e10 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e20 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x1e30 */ 108,105,110,117,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1e40 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,
/* 0x1e50 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 93, 58, 10, 79, 70, 70,
/* 0x1e60 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1e70 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1e80 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1e90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x1ea0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95,
/* 0x1eb0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ec0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1ee0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1ef0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82, 95, 65, 82,
/* 0x1f00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x1f10 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f20 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1f30 */  32, 32, 32, 32, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48,
/* 0x1f40 */  48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f50 */  32, 32, 32, 32, 32, 32, 32,115,116, 97,116, 10, 48, 48, 48, 48,
/* 0x1f60 */  48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f70 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1f80 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82,
/* 0x1f90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x1fa0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1fb0 */  98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1fc0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x1fd0 */  10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1fe0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,107,100,105,
/* 0x1ff0 */ 114, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77,
/* 0x2000 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95,
/* 0x2010 */  98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95,
/* 0x2020 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2030 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2040 */  48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2050 */  32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48,
/* 0x2060 */  48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2070 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2080 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32, 82,
/* 0x2090 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x20a0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x20b0 */  48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x20c0 */  32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48,
/* 0x20d0 */  48, 48, 49, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x20e0 */  32, 32, 32, 32, 32, 32, 32, 32,114,101, 97,100, 10, 48, 48, 48,
/* 0x20f0 */  48, 48, 49, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2100 */  32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48,
/* 0x2110 */  48, 48, 48, 49, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2120 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116,
/* 0x2130 */  10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2140 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2150 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 48,
/* 0x2160 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2170 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2180 */  48, 48, 48, 48, 49, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2190 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x21a0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 98, 48, 32, 82,
/* 0x21b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x21c0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x21d0 */  48, 48, 49, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x21e0 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10,
/* 0x21f0 */  48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2200 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2210 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 52, 32,
/* 0x2220 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2230 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2240 */  48, 48, 48, 49,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2250 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2260 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 48, 99, 32, 82, 95,
/* 0x2270 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2280 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 49, 56,
/* 0x2290 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x22a0 */  32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48,
/* 0x22b0 */  50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x22c0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x22d0 */  68, 10, 48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x22e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x22f0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 51,
/* 0x2300 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2310 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2320 */  48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2330 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2340 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 53, 52, 32,
/* 0x2350 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2360 */  32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50,
/* 0x2370 */  54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2380 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2390 */  10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x23a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x23b0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 56, 56,
/* 0x23c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x23d0 */  32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48,
/* 0x23e0 */  50, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x23f0 */  32, 32, 32, 32, 32, 32,103,101,116,112,105,100, 10, 48, 48, 48,
/* 0x2400 */  48, 48, 50, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2420 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65,
/* 0x2430 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2440 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2450 */  50, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2460 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2470 */  68, 10, 48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77,
/* 0x2480 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2490 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,102,
/* 0x24a0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x24b0 */  32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x24c0 */  10, 48, 48, 48, 48, 48, 50,102, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x24d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x24e0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 48, 56,
/* 0x24f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2500 */  32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10,
/* 0x2510 */  48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2520 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2530 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 49, 56, 32,
/* 0x2540 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2550 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2560 */  48, 48, 48, 51, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2570 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x2580 */  48, 48, 48, 51, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2590 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x25a0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 52, 52, 32, 82, 95,
/* 0x25b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x25c0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x25d0 */  48, 51, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x25e0 */  32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48,
/* 0x25f0 */  48, 48, 48, 48, 51, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2600 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,110, 97,109,101, 10,
/* 0x2610 */  48, 48, 48, 48, 48, 51, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2620 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2630 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 48, 32,
/* 0x2640 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2650 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2660 */  48, 48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2670 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2680 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 99, 32, 82, 95,
/* 0x2690 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x26a0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x26b0 */  48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x26c0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x26d0 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82,
/* 0x26e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x26f0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x2700 */  98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2710 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2720 */  10, 48, 48, 48, 48, 48, 51, 99, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2730 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2740 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 99, 52,
/* 0x2750 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2760 */  32, 32, 32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,
/* 0x2770 */ 104, 10, 48, 48, 48, 48, 48, 51,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x2780 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2790 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,101,
/* 0x27a0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x27b0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x27c0 */  48, 48, 48, 48, 48, 51,102, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x27d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x27e0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 48, 56, 32,
/* 0x27f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2800 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2810 */  48, 48, 48, 52, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2820 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2830 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 50, 48, 32, 82, 95,
/* 0x2840 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2850 */ 111,112,101,110, 10, 48, 48, 48, 48, 48, 52, 50, 99, 32, 82, 95,
/* 0x2860 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2870 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2880 */  48, 52, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2890 */  32, 32, 32, 32, 32, 32, 32,117,110,108,105,110,107, 10, 48, 48,
/* 0x28a0 */  48, 48, 48, 52, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x28b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x28c0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 52, 56, 32, 82, 95,
/* 0x28d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28e0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x28f0 */  48, 52, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2900 */  32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x2910 */ 109, 97,115,107, 10, 48, 48, 48, 48, 48, 52, 54, 52, 32, 82, 95,
/* 0x2920 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2930 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2940 */  48, 52, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2950 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2960 */  73, 68, 10, 48, 48, 48, 48, 48, 52, 55, 56, 32, 82, 95, 65, 82,
/* 0x2970 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,
/* 0x2980 */ 114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 52, 56, 48,
/* 0x2990 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x29a0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x29b0 */  48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x29c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x29d0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 57, 52, 32, 82,
/* 0x29e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x29f0 */  32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52, 98, 56, 32,
/* 0x2a00 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2a10 */  32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52, 99, 56,
/* 0x2a20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2a30 */  32, 32, 32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52,100,
/* 0x2a40 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2a60 */  48, 48, 48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2a70 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112,
/* 0x2a80 */  97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 52,101,
/* 0x2a90 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2aa0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2ab0 */  48, 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ac0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101,
/* 0x2ad0 */  10, 48, 48, 48, 48, 48, 52,102, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2ae0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2af0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 49, 56,
/* 0x2b00 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b10 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 50, 56,
/* 0x2b20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b30 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2b40 */  48, 48, 48, 48, 53, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b50 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2b60 */  68, 82, 79, 73, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2b70 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,
/* 0x2b80 */  77, 70, 95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x2b90 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ba0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x2bb0 */  48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2bc0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x2bd0 */  10, 48, 48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2be0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,
/* 0x2bf0 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 51,
/* 0x2c00 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x2c20 */  48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c30 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,
/* 0x2c40 */ 114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82,
/* 0x2c50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c60 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x2c70 */  48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2c80 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10,
/* 0x2c90 */  48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ca0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10,
/* 0x2cb0 */  48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2cc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76,
/* 0x2cd0 */  73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95,
/* 0x2ce0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cf0 */ 102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d00 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2d10 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48,
/* 0x2d20 */  48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d30 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48,
/* 0x2d40 */  48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d50 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,
/* 0x2d60 */ 103,101, 95,109, 97,115,107, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x2d70 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x2d80 */  91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x2d90 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2da0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2db0 */  48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,
/* 0x2dc0 */  50, 32, 32, 32, 32, 32, 32, 32, 77, 70, 76, 71, 10, 48, 48, 48,
/* 0x2dd0 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2de0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x2df0 */  10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e00 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2e10 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82, 95,
/* 0x2e20 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e30 */  69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 50,
/* 0x2e40 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2e50 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48,
/* 0x2e60 */  48, 48, 48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2e70 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x2e80 */  10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e90 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2ea0 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95,
/* 0x2eb0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ec0 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10,
/* 0x2ed0 */  48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2ee0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2ef0 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65,
/* 0x2f00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x2f10 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 49, 52,
/* 0x2f20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2f30 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x2f40 */  48, 49, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f50 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x2f60 */  48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f70 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2f80 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95, 65,
/* 0x2f90 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x2fa0 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 99, 56,
/* 0x2fb0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fc0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x2fd0 */  48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2fe0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x2ff0 */  48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3000 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3010 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49,101, 48, 32, 82, 95, 65,
/* 0x3020 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3030 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49,101, 52,
/* 0x3040 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3050 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x3060 */  48, 49,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3070 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x3080 */  48, 48, 48, 48, 48, 50, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3090 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x30a0 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65,
/* 0x30b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x30c0 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 48, 99,
/* 0x30d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x30e0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x30f0 */  48, 50, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3100 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x3110 */  48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3120 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3130 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65,
/* 0x3140 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3150 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 51, 56,
/* 0x3160 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3170 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 10, 82, 69, 76,
/* 0x3180 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3190 */  70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58, 10,
/* 0x31a0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x31b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x31c0 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x31d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x31e0 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82, 95,
/* 0x31f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3200 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 51,
/* 0x3210 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3220 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48,
/* 0x3230 */  48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3240 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x3250 */  10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3260 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x3270 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95,
/* 0x3280 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3290 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 49,
/* 0x32a0 */  52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x32b0 */  32, 32, 32, 32, 79, 95, 66, 73, 78, 70, 79, 10
};
