/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMGamepad.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMGamepadPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_GAMEPAD_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_GAMEPAD, WebKitDOMGamepadPrivate)

typedef struct _WebKitDOMGamepadPrivate {
#if ENABLE(GAMEPAD)
    RefPtr<WebCore::Gamepad> coreObject;
#endif // ENABLE(GAMEPAD)
} WebKitDOMGamepadPrivate;

#if ENABLE(GAMEPAD)

namespace WebKit {

WebKitDOMGamepad* kit(WebCore::Gamepad* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_GAMEPAD(ret);

    return wrapGamepad(obj);
}

WebCore::Gamepad* core(WebKitDOMGamepad* request)
{
    return request ? static_cast<WebCore::Gamepad*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMGamepad* wrapGamepad(WebCore::Gamepad* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_GAMEPAD(g_object_new(WEBKIT_TYPE_DOM_GAMEPAD, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(GAMEPAD)

G_DEFINE_TYPE(WebKitDOMGamepad, webkit_dom_gamepad, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ID,
    PROP_INDEX,
    PROP_TIMESTAMP,
};

static void webkit_dom_gamepad_finalize(GObject* object)
{
    WebKitDOMGamepadPrivate* priv = WEBKIT_DOM_GAMEPAD_GET_PRIVATE(object);
#if ENABLE(GAMEPAD)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(GAMEPAD)
    priv->~WebKitDOMGamepadPrivate();
    G_OBJECT_CLASS(webkit_dom_gamepad_parent_class)->finalize(object);
}

static void webkit_dom_gamepad_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(GAMEPAD)
    WebKitDOMGamepad* self = WEBKIT_DOM_GAMEPAD(object);
    WebCore::Gamepad* coreSelf = WebKit::core(self);
#endif // ENABLE(GAMEPAD)
    switch (propertyId) {
    case PROP_ID: {
#if ENABLE(GAMEPAD)
        g_value_take_string(value, convertToUTF8String(coreSelf->id()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
#endif /* ENABLE(GAMEPAD) */
        break;
    }
    case PROP_INDEX: {
#if ENABLE(GAMEPAD)
        g_value_set_ulong(value, coreSelf->index());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
#endif /* ENABLE(GAMEPAD) */
        break;
    }
    case PROP_TIMESTAMP: {
#if ENABLE(GAMEPAD)
        g_value_set_uint64(value, coreSelf->timestamp());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
#endif /* ENABLE(GAMEPAD) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_gamepad_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_gamepad_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(GAMEPAD)
    WebKitDOMGamepadPrivate* priv = WEBKIT_DOM_GAMEPAD_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Gamepad*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(GAMEPAD)
    return object;
}

static void webkit_dom_gamepad_class_init(WebKitDOMGamepadClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMGamepadPrivate));
    gobjectClass->constructor = webkit_dom_gamepad_constructor;
    gobjectClass->finalize = webkit_dom_gamepad_finalize;
    gobjectClass->get_property = webkit_dom_gamepad_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ID,
                                    g_param_spec_string("id", /* name */
                                                           "gamepad_id", /* short description */
                                                           "read-only  gchar* Gamepad.id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INDEX,
                                    g_param_spec_ulong("index", /* name */
                                                           "gamepad_index", /* short description */
                                                           "read-only  gulong Gamepad.index", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TIMESTAMP,
                                    g_param_spec_uint64("timestamp", /* name */
                                                           "gamepad_timestamp", /* short description */
                                                           "read-only  guint64 Gamepad.timestamp", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_gamepad_init(WebKitDOMGamepad* request)
{
    WebKitDOMGamepadPrivate* priv = WEBKIT_DOM_GAMEPAD_GET_PRIVATE(request);
    new (priv) WebKitDOMGamepadPrivate();
}

gchar*
webkit_dom_gamepad_get_id(WebKitDOMGamepad* self)
{
#if ENABLE(GAMEPAD)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_GAMEPAD(self), 0);
    WebCore::Gamepad* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->id());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
    return 0;
#endif /* ENABLE(GAMEPAD) */
}

gulong
webkit_dom_gamepad_get_index(WebKitDOMGamepad* self)
{
#if ENABLE(GAMEPAD)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_GAMEPAD(self), 0);
    WebCore::Gamepad* item = WebKit::core(self);
    gulong result = item->index();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
    return static_cast<gulong>(0);
#endif /* ENABLE(GAMEPAD) */
}

guint64
webkit_dom_gamepad_get_timestamp(WebKitDOMGamepad* self)
{
#if ENABLE(GAMEPAD)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_GAMEPAD(self), 0);
    WebCore::Gamepad* item = WebKit::core(self);
    guint64 result = item->timestamp();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
    return static_cast<guint64>(0);
#endif /* ENABLE(GAMEPAD) */
}

