/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLButtonElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLButtonElementPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLButtonElement* kit(WebCore::HTMLButtonElement* obj)
{
    return WEBKIT_DOM_HTML_BUTTON_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLButtonElement* core(WebKitDOMHTMLButtonElement* request)
{
    return request ? static_cast<WebCore::HTMLButtonElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLButtonElement* wrapHTMLButtonElement(WebCore::HTMLButtonElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_BUTTON_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_BUTTON_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLButtonElement, webkit_dom_html_button_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_AUTOFOCUS,
    PROP_DISABLED,
    PROP_FORM,
    PROP_FORM_ACTION,
    PROP_FORM_ENCTYPE,
    PROP_FORM_METHOD,
    PROP_FORM_NO_VALIDATE,
    PROP_FORM_TARGET,
    PROP_NAME,
    PROP_TYPE,
    PROP_VALUE,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_LABELS,
};

static void webkit_dom_html_button_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLButtonElement* self = WEBKIT_DOM_HTML_BUTTON_ELEMENT(object);
    WebCore::HTMLButtonElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_FORM_ACTION: {
        coreSelf->setAttribute(WebCore::HTMLNames::formactionAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_ENCTYPE: {
        coreSelf->setFormEnctype(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_METHOD: {
        coreSelf->setFormMethod(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_NO_VALIDATE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_FORM_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::formtargetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setType(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setAttribute(WebCore::HTMLNames::valueAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_button_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLButtonElement* self = WEBKIT_DOM_HTML_BUTTON_ELEMENT(object);
    WebCore::HTMLButtonElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FORM_ACTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::formactionAttr)));
        break;
    }
    case PROP_FORM_ENCTYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->formEnctype()));
        break;
    }
    case PROP_FORM_METHOD: {
        g_value_take_string(value, convertToUTF8String(coreSelf->formMethod()));
        break;
    }
    case PROP_FORM_NO_VALIDATE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::formnovalidateAttr));
        break;
    }
    case PROP_FORM_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::formtargetAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valueAttr)));
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_LABELS: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->labels();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_button_element_class_init(WebKitDOMHTMLButtonElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_button_element_set_property;
    gobjectClass->get_property = webkit_dom_html_button_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOFOCUS,
                                    g_param_spec_boolean("autofocus", /* name */
                                                           "html_button_element_autofocus", /* short description */
                                                           "read-write  gboolean HTMLButtonElement.autofocus", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_button_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLButtonElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_button_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLButtonElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_ACTION,
                                    g_param_spec_string("form-action", /* name */
                                                           "html_button_element_form-action", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.form-action", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_ENCTYPE,
                                    g_param_spec_string("form-enctype", /* name */
                                                           "html_button_element_form-enctype", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.form-enctype", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_METHOD,
                                    g_param_spec_string("form-method", /* name */
                                                           "html_button_element_form-method", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.form-method", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_NO_VALIDATE,
                                    g_param_spec_boolean("form-no-validate", /* name */
                                                           "html_button_element_form-no-validate", /* short description */
                                                           "read-write  gboolean HTMLButtonElement.form-no-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_TARGET,
                                    g_param_spec_string("form-target", /* name */
                                                           "html_button_element_form-target", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.form-target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_button_element_name", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_button_element_type", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_button_element_value", /* short description */
                                                           "read-write  gchar* HTMLButtonElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_button_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLButtonElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_button_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLButtonElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_button_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLButtonElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABELS,
                                    g_param_spec_object("labels", /* name */
                                                           "html_button_element_labels", /* short description */
                                                           "read-only  WebKitDOMNodeList* HTMLButtonElement.labels", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_button_element_init(WebKitDOMHTMLButtonElement* request)
{
}

gboolean
webkit_dom_html_button_element_check_validity(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), FALSE);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_button_element_set_custom_validity(WebKitDOMHTMLButtonElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

gboolean
webkit_dom_html_button_element_get_autofocus(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), FALSE);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autofocusAttr);
    return result;
}

void
webkit_dom_html_button_element_set_autofocus(WebKitDOMHTMLButtonElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value);
}

gboolean
webkit_dom_html_button_element_get_disabled(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), FALSE);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_button_element_set_disabled(WebKitDOMHTMLButtonElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_button_element_get_form(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_button_element_get_form_action(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::formactionAttr));
    return result;
}

void
webkit_dom_html_button_element_set_form_action(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::formactionAttr, convertedValue);
}

gchar*
webkit_dom_html_button_element_get_form_enctype(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->formEnctype());
    return result;
}

void
webkit_dom_html_button_element_set_form_enctype(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setFormEnctype(convertedValue);
}

gchar*
webkit_dom_html_button_element_get_form_method(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->formMethod());
    return result;
}

void
webkit_dom_html_button_element_set_form_method(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setFormMethod(convertedValue);
}

gboolean
webkit_dom_html_button_element_get_form_no_validate(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), FALSE);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::formnovalidateAttr);
    return result;
}

void
webkit_dom_html_button_element_set_form_no_validate(WebKitDOMHTMLButtonElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, value);
}

gchar*
webkit_dom_html_button_element_get_form_target(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::formtargetAttr));
    return result;
}

void
webkit_dom_html_button_element_set_form_target(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::formtargetAttr, convertedValue);
}

gchar*
webkit_dom_html_button_element_get_name(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_button_element_set_name(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_button_element_get_value(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valueAttr));
    return result;
}

void
webkit_dom_html_button_element_set_value(WebKitDOMHTMLButtonElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valueAttr, convertedValue);
}

gboolean
webkit_dom_html_button_element_get_will_validate(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), FALSE);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_button_element_get_validity(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_button_element_get_validation_message(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMNodeList*
webkit_dom_html_button_element_get_labels(WebKitDOMHTMLButtonElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_BUTTON_ELEMENT(self), 0);
    WebCore::HTMLButtonElement* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->labels());
    return WebKit::kit(gobjectResult.get());
}

