/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMouseEvent.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTargetPrivate.h"
#include "WebKitDOMMouseEventPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMMouseEvent* kit(WebCore::MouseEvent* obj)
{
    return WEBKIT_DOM_MOUSE_EVENT(kit(static_cast<WebCore::Event*>(obj)));
}

WebCore::MouseEvent* core(WebKitDOMMouseEvent* request)
{
    return request ? static_cast<WebCore::MouseEvent*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMouseEvent* wrapMouseEvent(WebCore::MouseEvent* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MOUSE_EVENT(g_object_new(WEBKIT_TYPE_DOM_MOUSE_EVENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMMouseEvent, webkit_dom_mouse_event, WEBKIT_TYPE_DOM_UI_EVENT)

enum {
    PROP_0,
    PROP_SCREEN_X,
    PROP_SCREEN_Y,
    PROP_CLIENT_X,
    PROP_CLIENT_Y,
    PROP_CTRL_KEY,
    PROP_SHIFT_KEY,
    PROP_ALT_KEY,
    PROP_META_KEY,
    PROP_BUTTON,
    PROP_RELATED_TARGET,
    PROP_WEBKIT_MOVEMENT_X,
    PROP_WEBKIT_MOVEMENT_Y,
    PROP_OFFSET_X,
    PROP_OFFSET_Y,
    PROP_X,
    PROP_Y,
    PROP_FROM_ELEMENT,
    PROP_TO_ELEMENT,
};

static void webkit_dom_mouse_event_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMMouseEvent* self = WEBKIT_DOM_MOUSE_EVENT(object);
    WebCore::MouseEvent* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_SCREEN_X: {
        g_value_set_long(value, coreSelf->screenX());
        break;
    }
    case PROP_SCREEN_Y: {
        g_value_set_long(value, coreSelf->screenY());
        break;
    }
    case PROP_CLIENT_X: {
        g_value_set_long(value, coreSelf->clientX());
        break;
    }
    case PROP_CLIENT_Y: {
        g_value_set_long(value, coreSelf->clientY());
        break;
    }
    case PROP_CTRL_KEY: {
        g_value_set_boolean(value, coreSelf->ctrlKey());
        break;
    }
    case PROP_SHIFT_KEY: {
        g_value_set_boolean(value, coreSelf->shiftKey());
        break;
    }
    case PROP_ALT_KEY: {
        g_value_set_boolean(value, coreSelf->altKey());
        break;
    }
    case PROP_META_KEY: {
        g_value_set_boolean(value, coreSelf->metaKey());
        break;
    }
    case PROP_BUTTON: {
        g_value_set_uint(value, coreSelf->button());
        break;
    }
    case PROP_RELATED_TARGET: {
        RefPtr<WebCore::EventTarget> ptr = coreSelf->relatedTarget();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WEBKIT_MOVEMENT_X: {
#if ENABLE(POINTER_LOCK)
        g_value_set_long(value, coreSelf->webkitMovementX());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
#endif /* ENABLE(POINTER_LOCK) */
        break;
    }
    case PROP_WEBKIT_MOVEMENT_Y: {
#if ENABLE(POINTER_LOCK)
        g_value_set_long(value, coreSelf->webkitMovementY());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
#endif /* ENABLE(POINTER_LOCK) */
        break;
    }
    case PROP_OFFSET_X: {
        g_value_set_long(value, coreSelf->offsetX());
        break;
    }
    case PROP_OFFSET_Y: {
        g_value_set_long(value, coreSelf->offsetY());
        break;
    }
    case PROP_X: {
        g_value_set_long(value, coreSelf->x());
        break;
    }
    case PROP_Y: {
        g_value_set_long(value, coreSelf->y());
        break;
    }
    case PROP_FROM_ELEMENT: {
        RefPtr<WebCore::Node> ptr = coreSelf->fromElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_TO_ELEMENT: {
        RefPtr<WebCore::Node> ptr = coreSelf->toElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_mouse_event_class_init(WebKitDOMMouseEventClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_mouse_event_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_X,
                                    g_param_spec_long("screen-x", /* name */
                                                           "mouse_event_screen-x", /* short description */
                                                           "read-only  glong MouseEvent.screen-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_Y,
                                    g_param_spec_long("screen-y", /* name */
                                                           "mouse_event_screen-y", /* short description */
                                                           "read-only  glong MouseEvent.screen-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_X,
                                    g_param_spec_long("client-x", /* name */
                                                           "mouse_event_client-x", /* short description */
                                                           "read-only  glong MouseEvent.client-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_Y,
                                    g_param_spec_long("client-y", /* name */
                                                           "mouse_event_client-y", /* short description */
                                                           "read-only  glong MouseEvent.client-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CTRL_KEY,
                                    g_param_spec_boolean("ctrl-key", /* name */
                                                           "mouse_event_ctrl-key", /* short description */
                                                           "read-only  gboolean MouseEvent.ctrl-key", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHIFT_KEY,
                                    g_param_spec_boolean("shift-key", /* name */
                                                           "mouse_event_shift-key", /* short description */
                                                           "read-only  gboolean MouseEvent.shift-key", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALT_KEY,
                                    g_param_spec_boolean("alt-key", /* name */
                                                           "mouse_event_alt-key", /* short description */
                                                           "read-only  gboolean MouseEvent.alt-key", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_META_KEY,
                                    g_param_spec_boolean("meta-key", /* name */
                                                           "mouse_event_meta-key", /* short description */
                                                           "read-only  gboolean MouseEvent.meta-key", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BUTTON,
                                    g_param_spec_uint("button", /* name */
                                                           "mouse_event_button", /* short description */
                                                           "read-only  gushort MouseEvent.button", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RELATED_TARGET,
                                    g_param_spec_object("related-target", /* name */
                                                           "mouse_event_related-target", /* short description */
                                                           "read-only  WebKitDOMEventTarget* MouseEvent.related-target", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_EVENT_TARGET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_MOVEMENT_X,
                                    g_param_spec_long("webkit-movement-x", /* name */
                                                           "mouse_event_webkit-movement-x", /* short description */
                                                           "read-only  glong MouseEvent.webkit-movement-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_MOVEMENT_Y,
                                    g_param_spec_long("webkit-movement-y", /* name */
                                                           "mouse_event_webkit-movement-y", /* short description */
                                                           "read-only  glong MouseEvent.webkit-movement-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_X,
                                    g_param_spec_long("offset-x", /* name */
                                                           "mouse_event_offset-x", /* short description */
                                                           "read-only  glong MouseEvent.offset-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_Y,
                                    g_param_spec_long("offset-y", /* name */
                                                           "mouse_event_offset-y", /* short description */
                                                           "read-only  glong MouseEvent.offset-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_X,
                                    g_param_spec_long("x", /* name */
                                                           "mouse_event_x", /* short description */
                                                           "read-only  glong MouseEvent.x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_Y,
                                    g_param_spec_long("y", /* name */
                                                           "mouse_event_y", /* short description */
                                                           "read-only  glong MouseEvent.y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FROM_ELEMENT,
                                    g_param_spec_object("from-element", /* name */
                                                           "mouse_event_from-element", /* short description */
                                                           "read-only  WebKitDOMNode* MouseEvent.from-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TO_ELEMENT,
                                    g_param_spec_object("to-element", /* name */
                                                           "mouse_event_to-element", /* short description */
                                                           "read-only  WebKitDOMNode* MouseEvent.to-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_mouse_event_init(WebKitDOMMouseEvent* request)
{
}

void
webkit_dom_mouse_event_init_mouse_event(WebKitDOMMouseEvent* self, const gchar* type, gboolean canBubble, gboolean cancelable, WebKitDOMDOMWindow* view, glong detail, glong screenX, glong screenY, glong clientX, glong clientY, gboolean ctrlKey, gboolean altKey, gboolean shiftKey, gboolean metaKey, gushort button, WebKitDOMEventTarget* relatedTarget)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self));
    g_return_if_fail(type);
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(view));
    g_return_if_fail(WEBKIT_DOM_IS_EVENT_TARGET(relatedTarget));
    WebCore::MouseEvent* item = WebKit::core(self);
    WTF::String convertedType = WTF::String::fromUTF8(type);
    WebCore::DOMWindow* convertedView = WebKit::core(view);
    WebCore::EventTarget* convertedRelatedTarget = WebKit::core(relatedTarget);
    item->initMouseEvent(convertedType, canBubble, cancelable, convertedView, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, convertedRelatedTarget);
}

glong
webkit_dom_mouse_event_get_screen_x(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->screenX();
    return result;
}

glong
webkit_dom_mouse_event_get_screen_y(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->screenY();
    return result;
}

glong
webkit_dom_mouse_event_get_client_x(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->clientX();
    return result;
}

glong
webkit_dom_mouse_event_get_client_y(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->clientY();
    return result;
}

gboolean
webkit_dom_mouse_event_get_ctrl_key(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), FALSE);
    WebCore::MouseEvent* item = WebKit::core(self);
    gboolean result = item->ctrlKey();
    return result;
}

gboolean
webkit_dom_mouse_event_get_shift_key(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), FALSE);
    WebCore::MouseEvent* item = WebKit::core(self);
    gboolean result = item->shiftKey();
    return result;
}

gboolean
webkit_dom_mouse_event_get_alt_key(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), FALSE);
    WebCore::MouseEvent* item = WebKit::core(self);
    gboolean result = item->altKey();
    return result;
}

gboolean
webkit_dom_mouse_event_get_meta_key(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), FALSE);
    WebCore::MouseEvent* item = WebKit::core(self);
    gboolean result = item->metaKey();
    return result;
}

gushort
webkit_dom_mouse_event_get_button(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    gushort result = item->button();
    return result;
}

WebKitDOMEventTarget*
webkit_dom_mouse_event_get_related_target(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    RefPtr<WebCore::EventTarget> gobjectResult = WTF::getPtr(item->relatedTarget());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_mouse_event_get_webkit_movement_x(WebKitDOMMouseEvent* self)
{
#if ENABLE(POINTER_LOCK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->webkitMovementX();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
    return static_cast<glong>(0);
#endif /* ENABLE(POINTER_LOCK) */
}

glong
webkit_dom_mouse_event_get_webkit_movement_y(WebKitDOMMouseEvent* self)
{
#if ENABLE(POINTER_LOCK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->webkitMovementY();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
    return static_cast<glong>(0);
#endif /* ENABLE(POINTER_LOCK) */
}

glong
webkit_dom_mouse_event_get_offset_x(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->offsetX();
    return result;
}

glong
webkit_dom_mouse_event_get_offset_y(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->offsetY();
    return result;
}

glong
webkit_dom_mouse_event_get_x(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->x();
    return result;
}

glong
webkit_dom_mouse_event_get_y(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    glong result = item->y();
    return result;
}

WebKitDOMNode*
webkit_dom_mouse_event_get_from_element(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->fromElement());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_mouse_event_get_to_element(WebKitDOMMouseEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MOUSE_EVENT(self), 0);
    WebCore::MouseEvent* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->toElement());
    return WebKit::kit(gobjectResult.get());
}

