/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Area;
import java.awt.BDToolkit;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.videolan.Libbluray;
import org.videolan.Logger;

public class BDRootWindow
extends Frame {
    private int[] backBuffer = null;
    private Area dirty = new Area();
    private int changeCount = 0;
    private Timer timer = new Timer();
    private TimerTask timerTask = null;
    private boolean overlay_open = false;
    private static final Logger logger = Logger.getLogger(BDRootWindow.class.getName());
    private static final long serialVersionUID = -8325961861529007953L;

    public BDRootWindow() {
        this.setUndecorated(true);
        this.setBackground(new Color(0, 0, 0, 0));
        BDToolkit.setFocusedWindow(this);
    }

    public Area getDirtyArea() {
        return this.dirty;
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.isVisible()) {
            if (width > 0 && height > 0 && (this.backBuffer == null || this.getWidth() * this.getHeight() < width * height)) {
                this.backBuffer = new int[width * height];
                Arrays.fill(this.backBuffer, 0);
            }
            super.setBounds(x, y, width, height);
        }
    }

    public int[] getBdBackBuffer() {
        return this.backBuffer;
    }

    public Image getBackBuffer() {
        logger.unimplemented("getBackBuffer");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged() {
        if (!this.isVisible()) {
            logger.error("sync(): not visible");
            return;
        }
        BDRootWindow bDRootWindow = this;
        synchronized (bDRootWindow) {
            if (this.timer == null) {
                logger.error("notifyChanged(): window already disposed");
                return;
            }
            ++this.changeCount;
            if (this.timerTask == null) {
                this.timerTask = new RefreshTimerTask(this);
                this.timer.schedule(this.timerTask, 40L, 40L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        BDRootWindow bDRootWindow = this;
        synchronized (bDRootWindow) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            this.changeCount = 0;
            Area a = this.dirty.getBounds();
            this.dirty.clear();
            if (!a.isEmpty()) {
                if (!this.overlay_open) {
                    Libbluray.updateGraphic(this.getWidth(), this.getHeight(), null);
                    this.overlay_open = true;
                    a = new Area(this.getWidth(), this.getHeight());
                }
                Libbluray.updateGraphic(this.getWidth(), this.getHeight(), this.backBuffer, a.x0, a.y0, a.x1, a.y1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        BDRootWindow bDRootWindow = this;
        synchronized (bDRootWindow) {
            if (this.overlay_open) {
                Libbluray.updateGraphic(0, 0, null);
                this.overlay_open = false;
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.close();
        }
    }

    public void clearOverlay() {
        if (this.overlay_open) {
            logger.error("clearOverlay() ignored (overlay is visible)");
        } else {
            Arrays.fill(this.backBuffer, 0);
            this.dirty.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        BDRootWindow bDRootWindow = this;
        synchronized (bDRootWindow) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (this.isVisible()) {
            this.hide();
        }
        BDToolkit.setFocusedWindow(null);
        super.dispose();
        this.backBuffer = null;
    }

    private class RefreshTimerTask
    extends TimerTask {
        private BDRootWindow window;
        private int changeCount;

        public RefreshTimerTask(BDRootWindow window) {
            this.window = window;
            this.changeCount = window.changeCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BDRootWindow bDRootWindow = this.window;
            synchronized (bDRootWindow) {
                if (this.changeCount == this.window.changeCount) {
                    this.window.sync();
                } else {
                    this.changeCount = this.window.changeCount;
                }
            }
        }
    }
}

