/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.videolan.BDJAction;
import org.videolan.BDJActionManager;
import org.videolan.BDJLoader;
import org.videolan.BDJUtil;
import org.videolan.CacheDir;
import org.videolan.Logger;
import org.videolan.MountException;

public class MountManager {
    private static final String relJarDir = new String(File.separator + "BDMV" + File.separator + "JAR" + File.separator);
    private static Map mountPoints = new HashMap();
    private static final Logger logger = Logger.getLogger(MountManager.class.getName());

    public static String mount(int jarId) throws MountException {
        return new MountAction(jarId).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String mount(int jarId, boolean classFiles) throws MountException {
        String jarStr = MountManager.jarIdToString(jarId);
        logger.info("Mounting JAR: " + jarStr);
        if (jarStr == null) {
            throw new IllegalArgumentException();
        }
        Map map = mountPoints;
        synchronized (map) {
            MountPoint mountPoint = (MountPoint)mountPoints.get(new Integer(jarId));
            if (mountPoint != null) {
                logger.info("JAR " + jarId + " already mounted");
                mountPoint.incRefCount();
                if (classFiles && !mountPoint.classFiles()) {
                    logger.info("JAR " + jarId + " not complete, remounting");
                } else {
                    return mountPoint.getMountPoint();
                }
            }
            String path = BDJLoader.getCachedFile(System.getProperty("bluray.vfs.root") + relJarDir + jarStr + ".jar");
            JarFile jar = null;
            try {
                jar = new JarFile(path, false);
                if (mountPoint == null) {
                    mountPoint = new MountPoint(jarStr, classFiles);
                }
            }
            catch (IOException e) {
                logger.error("Error opening " + path + ": " + e);
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new MountException();
            }
            InputStream inStream = null;
            OutputStream outStream = null;
            try {
                byte[] buffer = new byte[32768];
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    int length;
                    JarEntry entry = entries.nextElement();
                    File out = new File(mountPoint.getMountPoint() + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        out.mkdirs();
                        continue;
                    }
                    if (!classFiles && entry.getName().endsWith(".class")) continue;
                    out.getParentFile().mkdirs();
                    logger.info("   mount: " + entry.getName());
                    try {
                        inStream = jar.getInputStream(entry);
                    }
                    catch (SecurityException se) {
                        logger.error("Error uncompressing " + entry.getName() + " from " + path + ": " + se + "\n" + Logger.dumpStack(se));
                        continue;
                    }
                    outStream = new FileOutputStream(out);
                    while ((length = inStream.read(buffer)) > 0) {
                        outStream.write(buffer, 0, length);
                    }
                    inStream.close();
                    outStream.close();
                }
            }
            catch (IOException e) {
                logger.error("Error uncompressing " + path + ": " + e);
                mountPoint.remove();
                throw new MountException();
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {}
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {}
                }
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
            if (mountPoint.classFiles() != classFiles) {
                if (mountPoint.classFiles()) {
                    logger.error("assertion failed");
                } else {
                    logger.info("Remounting FULL JAR " + jarId + " complete.");
                    mountPoint.setClassFiles();
                }
            } else {
                logger.info("Mounting " + (classFiles ? "FULL" : "PARTIAL") + " JAR " + jarId + " complete.");
                mountPoints.put(new Integer(jarId), mountPoint);
            }
            return mountPoint.getMountPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unmount(int jarId) {
        logger.info("Unmounting JAR: " + jarId);
        final Integer id = new Integer(jarId);
        Map map = mountPoints;
        synchronized (map) {
            final MountPoint mountPoint = (MountPoint)mountPoints.get(id);
            if (mountPoint == null) {
                logger.info("JAR " + jarId + " not mounted");
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (mountPoint.decRefCount() < 1) {
                        mountPoints.remove(id);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unmountAll() {
        Object[] dirs;
        logger.info("Unmounting all JARs");
        Map map = mountPoints;
        synchronized (map) {
            dirs = mountPoints.values().toArray();
            mountPoints.clear();
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                ((MountPoint)dirs[i]).remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMount(int jarId) {
        MountPoint mountPoint;
        Integer id = new Integer(jarId);
        Map map = mountPoints;
        synchronized (map) {
            mountPoint = (MountPoint)mountPoints.get(id);
        }
        if (mountPoint != null) {
            return mountPoint.getMountPoint();
        }
        logger.info("JAR " + jarId + " not mounted");
        return null;
    }

    private static String jarIdToString(int jarId) {
        if (jarId < 0 || jarId > 99999) {
            return null;
        }
        return BDJUtil.makeFiveDigitStr(jarId);
    }

    private static class MountAction
    extends BDJAction {
        private final int jarId;
        private String mountPoint = null;
        private MountException exception = null;

        public MountAction(int jarId) {
            this.jarId = jarId;
        }

        protected void doAction() {
            try {
                this.mountPoint = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MountException {
                        return MountManager.mount(MountAction.this.jarId, true);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.exception = (MountException)e.getException();
            }
        }

        public String execute() throws MountException {
            BDJActionManager.getInstance().putCommand(this);
            this.waitEnd();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.mountPoint;
        }
    }

    private static class MountPoint {
        private File dir;
        private int refCount;
        private boolean classFiles;

        public MountPoint(String id, boolean classFiles) throws IOException {
            this.dir = CacheDir.create("mount", id);
            this.refCount = 1;
            this.classFiles = classFiles;
        }

        public synchronized String getMountPoint() {
            if (this.dir != null) {
                return this.dir.getAbsolutePath();
            }
            return null;
        }

        public synchronized void remove() {
            if (this.dir != null) {
                CacheDir.remove(this.dir);
                this.dir = null;
                this.refCount = 0;
            }
        }

        public synchronized int incRefCount() {
            return ++this.refCount;
        }

        public synchronized int decRefCount() {
            --this.refCount;
            if (this.refCount < 1) {
                this.remove();
            }
            return this.refCount;
        }

        public boolean classFiles() {
            return this.classFiles;
        }

        public void setClassFiles() {
            this.classFiles = true;
        }
    }
}

