/*****************************************************************************
 * npolibvlc.h: official Javascript APIs
 *****************************************************************************
 * Copyright (C) 2002-2012 VLC authors and VideoLAN
 *
 * Authors: Rafaël Carré <funman@videolan.org>
 *          JP Dinger <jpd@videolan.org>
 *          Cyril Mathé <cmathe@actech-innovation.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
** defined runtime script objects
*/
#include <vlc/vlc.h>

#include "nporuntime.h"

class LibvlcRootNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcRootNPObject>;

    LibvlcRootNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass),
    audioObj(NULL),
    inputObj(NULL),
    playlistObj(NULL),
    subtitleObj(NULL),
    videoObj(NULL),
    mediaDescriptionObj(NULL) { }

    virtual ~LibvlcRootNPObject();

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    InvokeResult getProperty(int index, npapi::OutVariant& result);

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;

private:
    NPObject *audioObj;
    NPObject *inputObj;
    NPObject *playlistObj;
    NPObject *subtitleObj;
    NPObject *videoObj;
    NPObject *mediaDescriptionObj;
};

class LibvlcAudioNPObject: public RuntimeNPObject
{
protected:
    LibvlcAudioNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) {};
    virtual ~LibvlcAudioNPObject() {};

    friend class RuntimeNPClass<LibvlcAudioNPObject>;

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result)  override;
};

class LibvlcInputNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcInputNPObject>;

    LibvlcInputNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass),
        titleObj(NULL), chapterObj(NULL) {};

    virtual ~LibvlcInputNPObject();

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, NPVariant &result);

private:
    NPObject *titleObj;
    NPObject *chapterObj;
};

class LibvlcMediaDescriptionNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcMediaDescriptionNPObject>;
    LibvlcMediaDescriptionNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) {};
    virtual ~LibvlcMediaDescriptionNPObject() {};

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];
};

class LibvlcPlaylistItemsNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcPlaylistItemsNPObject>;

    LibvlcPlaylistItemsNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) {};
    virtual ~LibvlcPlaylistItemsNPObject() {};

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};

class LibvlcPlaylistNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcPlaylistNPObject>;

    LibvlcPlaylistNPObject(NPP instance, const NPClass *aClass) :
    RuntimeNPObject(instance, aClass),
    playlistItemsObj(NULL) {};

    virtual ~LibvlcPlaylistNPObject();

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;

    void parseOptions(const NPString& s, int *i_options, char*** ppsz_options);
    void parseOptions(NPObject *obj, int *i_options, char*** ppsz_options);

private:
    NPObject*  playlistItemsObj;
};

class LibvlcSubtitleNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcSubtitleNPObject>;

    LibvlcSubtitleNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) {};
    virtual ~LibvlcSubtitleNPObject() {};

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};


class LibvlcVideoNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcVideoNPObject>;

    LibvlcVideoNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass),
        marqueeObj(NULL), logoObj(NULL), deintObj(NULL) { }
    virtual ~LibvlcVideoNPObject();

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;

private:
    NPObject *marqueeObj;
    NPObject *logoObj;
    NPObject *deintObj;
};

class LibvlcMarqueeNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcMarqueeNPObject>;

    LibvlcMarqueeNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) {};
    virtual ~LibvlcMarqueeNPObject() {};

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};

class LibvlcLogoNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcLogoNPObject>;

    LibvlcLogoNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) { }
    virtual ~LibvlcLogoNPObject() { }

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant& result) override;
};

class LibvlcDeinterlaceNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcDeinterlaceNPObject>;

    LibvlcDeinterlaceNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) { }
    virtual ~LibvlcDeinterlaceNPObject() { }

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};

class LibvlcTitleNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcTitleNPObject>;

    LibvlcTitleNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) { }
    virtual ~LibvlcTitleNPObject() { }

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};

class LibvlcChapterNPObject: public RuntimeNPObject
{
protected:
    friend class RuntimeNPClass<LibvlcChapterNPObject>;

    LibvlcChapterNPObject(NPP instance, const NPClass *aClass) :
        RuntimeNPObject(instance, aClass) { }
    virtual ~LibvlcChapterNPObject() { }

    static const int propertyCount;
    static const NPUTF8 * const propertyNames[];

    virtual InvokeResult getProperty(int index, npapi::OutVariant& result) override;
    virtual InvokeResult setProperty(int index, const NPVariant &value) override;

    static const int methodCount;
    static const NPUTF8 * const methodNames[];

    virtual InvokeResult invoke(int index, const NPVariant *args, uint32_t argCount, npapi::OutVariant &result) override;
};
