%define desktop_file 1
%define desktop_file_utils_version 0.2.93

%define _unpackaged_files_terminate_build 0
%define toolkit_options --enable-default-toolkit=gtk2 --disable-freetype2 --enable-xft
%define builddir %{_builddir}/mozilla

Name:        mozilla
Summary:     Web browser and mail reader
Version:     1.6
Release:     2
Epoch:       37
License:     MPL/NPL/GPL/LGPL
Source0:     mozilla-source-1.6.tar.bz2
Source1:     mozilla.sh.in
Source2:     mozilla-icon.png
Source4:     mozilla.desktop
Source7:     mozilla-make-package.pl
Source9:     mozicon16.xpm
Source10:    mozicon50.xpm
Source11:    mozilla-rebuild-databases.pl.in
Source12:    mozilla-mail.desktop
Source13:    mozilla-mail-icon.png
Source14:    mozilla-compose.desktop
Source15:    mozilla-compose-icon.png
Source17:    mozilla-psm-exclude-list
Source18:    mozilla-xpcom-exclude-list
Source19:    mozilla-redhat-default-bookmarks.html
Patch0:      mozilla-navigator-overlay-menu.patch
Patch1:      mozilla-editor-overlay-menu.patch
Patch6:      mozilla-prefs-debug.patch
Patch7:      mozilla-redhat-home-page.patch
Patch12:     mozilla-psfonts-7.2.patch
Patch13:     mozilla-nspr-packages.patch
Patch14:     mozilla-default-plugin-less-annoying.patch
Patch17:     mozilla-buildid-title.patch
Patch22:     mozilla-1.4-x86_64.patch
Patch23:     mozilla-1.6-gnome-uriloader.patch

Patch28:     mozilla-1.4.1-ppc64.patch
Patch29:     mozilla-1.4-prdtoa.patch

Buildroot:   %{_tmppath}/%{name}-root
Prefix:      /usr
Group:       Applications/Internet
Provides:    webclient
BuildPrereq: libpng-devel, libjpeg-devel, zlib-devel, zip, perl, indexhtml, libIDL-devel, glib2-devel, gtk2-devel, autoconf213
Prereq:      fileutils perl
Prereq:      /usr/bin/killall
Requires:    mozilla-nspr = %{epoch}:%{version}-%{release}
Requires:    mozilla-nss = %{epoch}:%{version}-%{release}
Requires:    indexhtml
Obsoletes:   mozilla-psm
ExclusiveArch: i386 x86_64 ia64 ppc s390 s390x

%if %{desktop_file}
BuildPrereq: desktop-file-utils >= %{desktop_file_utils_version}
%endif

%description
Mozilla is an open-source web browser, designed for standards
compliance, performance and portability.

%package nspr
Summary: Netscape Portable Runtime
Group: Applications/Internet
Conflicts: mozilla < 35:0.9.9

%description nspr
NSPR provides platform independence for non-GUI operating system
facilities. These facilities include threads, thread synchronization,
normal file and network I/O, interval timing and calendar time, basic
memory management (malloc and free) and shared library linking.

%package nspr-devel
Summary: Development Libraries for the Netscape Portable Runtime
Group: Development/Libraries
Requires: mozilla-nspr = %{epoch}:%{version}-%{release}

%description nspr-devel
Header files for doing development with the Netscape Portable Runtime.

%package nss
Summary: Network Security Services
Group: Applications/Internet
Requires: mozilla-nspr = %{epoch}:%{version}-%{release}

%description nss
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2 and v3,
TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

%package nss-devel
Summary: Development Libraries for Network Security Services
Group: Applications/Internet
Requires: mozilla-nspr-devel = %{epoch}:%{version}-%{release}
Requires: mozilla-nss = %{epoch}:%{version}-%{release}

%description nss-devel
Header files to doing development with Network Security Services.

%package devel
Summary: Development files for Mozilla
Group: Development/Libraries
Requires: mozilla = %{epoch}:%{version}-%{release}
Requires: mozilla-nspr-devel = %{epoch}:%{version}-%{release}
Requires: mozilla-nss-devel = %{epoch}:%{version}-%{release}

%description devel
Development header files for mozilla.

%package mail
Summary: Mozilla-based mail system
Group: Applications/Internet
Prereq:      fileutils mozilla = %{epoch}:%{version}-%{release}

%description mail
Mail/news client based on the Mozilla web browser.  The mail/news
client supports IMAP, POP, and NNTP and has an easy to use interface.

%package chat
Summary: IRC client integrated with Mozilla
Group: Applications/Internet
Prereq: fileutils mozilla = %{epoch}:%{version}-%{release}

%description chat
IRC client that is integrated with the Mozilla web browser.

%package js-debugger
Summary: JavaScript debugger for use with Mozilla
Group: Applications/Internet
Prereq: fileutils mozilla = %{epoch}:%{version}-%{release}

%description js-debugger
JavaScript debugger for use with Mozilla.

%package dom-inspector
Summary: A tool for inspecting the DOM of pages in Mozilla.
Group: Applications/Internet
Prereq: fileutils mozilla = %{epoch}:%{version}-%{release}

%description dom-inspector
This is a tool that allows you to inspect the DOM for web pages in
Mozilla.  This is of great use to people who are doing Mozilla chrome
development or web page development.

%prep

%setup -q -n mozilla

#%patch0 -p1
#%patch0 -p1 -R

#%patch1 -p1
#%patch1 -p1 -R

#%patch6 -p1
#%patch6 -p1 -R
#%patch17 -p1
#%patch17 -p1 -R

%patch7 -p1
#%patch7 -p1 -R

# Can't hurt to leave this in since the defaults are empty.
%patch12 -p1

%patch13 -p1

# make the plugin dialog less annoying and disable redirection to the
# plugin downloader page.
%patch14 -p1

# remove the annoying buildid from the titlebar
#%patch17 -p1
#%patch17 -p1 -R

%patch22 -p1 -b .x86_64

# make sure that the gnome uri handler isn't run during registration
%patch23 -p1 -b .gnome

# add nss build support for ppc64
%patch28 -p1

# work around problems with prdtoa.c
%patch29 -p1

# set up our default bookmarks
/bin/cp %{SOURCE19} $RPM_BUILD_DIR/mozilla/profile/defaults/bookmarks.html

%build

if [ -x /usr/bin/getconf ]; then
  CPUS=`getconf _NPROCESSORS_ONLN`
fi
if test "x$CPUS" = "x" -o "x$CPUS" = "x0"; then
  CPUS=1
fi

# build mozilla - XCFLAGS is for NSS which can't use CFLAGS for
# various reasons
%ifarch ia64
OPTFLAGS=-O0
%else
OPTFLAGS=-O2
%endif

XCFLAGS=-g \
CFLAGS=-g \
%ifarch ia64 ppc
CXXFLAGS="-fno-inline -g" \
%else
CXXFLAGS=-g \
%endif
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 \
	./configure --prefix=%{_prefix} --libdir=%{_libdir} \
	--enable-optimize=$OPTFLAGS \
	--disable-debug \
	--with-default-mozilla-five-home=%{_libdir}/mozilla-%{version} \
	--disable-strip-libs \
	--disable-tests \
	--enable-xinerama \
	--enable-nspr-autoconf \
	--enable-extensions=default,irc \
	--without-mng \
	--enable-crypto \
	--disable-xprint \
	--without-system-nspr \
	--with-system-zlib \
	%{toolkit_options} \
	--mandir=%{_mandir}


BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make export
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make -j$CPUS libs

%install
/bin/rm -rf $RPM_BUILD_ROOT

BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 \
	DESTDIR=$RPM_BUILD_ROOT \
	make install

# create a list of all of the different package and the files that
# will hold them

/bin/rm -f %{builddir}/mozilla.list
/bin/rm -f %{builddir}/mozilla-mail.list
/bin/rm -f %{builddir}/mozilla-chat.list
/bin/rm -f %{builddir}/mozilla-js-debugger.list
/bin/rm -f %{builddir}/mozilla-dom-inspector.list

echo %defattr\(-,root,root\) > %{builddir}/mozilla.list
echo %defattr\(-,root,root\) > %{builddir}/mozilla-mail.list
echo %defattr\(-,root,root\) > %{builddir}/mozilla-chat.list
echo %defattr\(-,root,root\) > %{builddir}/mozilla-js-debugger.list
echo %defattr\(-,root,root\) > %{builddir}/mozilla-dom-inspector.list

# NSS and NSPR are both installed into /usr/lib instead of
# /usr/lib/mozilla-VERSION

pushd .
cd $RPM_BUILD_ROOT%{_libdir}/mozilla-%{version}
# move nspr
mv -v \
  libnspr4.so libplc4.so libplds4.so \
  $RPM_BUILD_ROOT%{_libdir}/

# move psm
mv -v \
  libnss3.so libsmime3.so libsoftokn3.so libsoftokn3.chk libssl3.so \
  $RPM_BUILD_ROOT%{_libdir}/

# libnssckbi.so must be in both places
cp -v libnssckbi.so $RPM_BUILD_ROOT%{_libdir}/
popd

# we don't want to ship mozilla's default sidebar components
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/bugzilla.gif
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/bugzilla.src
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/dmoz.gif
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/dmoz.src
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/lxrmozilla.gif
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/lxrmozilla.src
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/mozilla.gif
rm -f $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/searchplugins/mozilla.src

/bin/rm -f %{builddir}/mozilla-nspr.list
%{SOURCE7} --package nspr --output-file %{builddir}/mozilla-nspr.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir} \
    --install-root %{_libdir}

/bin/rm -f %{builddir}/mozilla-nss.list
%{SOURCE7} --package nss --output-file %{builddir}/mozilla-nss.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir} \
    --install-root %{_libdir}

# manually add the libnssckbi.so file
echo %{_libdir}/mozilla-%{version}/libnssckbi.so >> %{builddir}/mozilla-nss.list

# build all of the default browser components
# base mozilla package (mozilla.list)
%{SOURCE7} --package langenus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

%{SOURCE7} --package regus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

%{SOURCE7} --package deflenus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

%{SOURCE7} --package xpcom --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version} \
    --exclude-file=%{SOURCE18}

%{SOURCE7} --package browser --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

%{SOURCE7} --package spellcheck --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

%{SOURCE7} --package psm --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version} \
    --exclude-file=%{SOURCE17}

# mozilla mail (mozilla-mail.list)
%{SOURCE7} --package mail --output-file %{builddir}/mozilla-mail.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

# mozilla chat (mozilla-chat.list)
%{SOURCE7} --package chatzilla --output-file %{builddir}/mozilla-chat.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

# mozilla JS debugger (mozilla-js-debugger.list)
%{SOURCE7} --package venkman --output-file %{builddir}/mozilla-js-debugger.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

# mozilla DOM inspector (mozilla-dom-inspector.list)
%{SOURCE7} --package inspector --output-file %{builddir}/mozilla-dom-inspector.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version} \
    --install-root %{_libdir}/mozilla-%{version}

# build our initial component and chrome registry


pushd `pwd`
  cd $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}

  # save a copy of the default installed-chrome.txt file before we
  # muck with it
  mkdir chrome/lang
  cp chrome/installed-chrome.txt chrome/lang/

  # register our components
  LD_LIBRARY_PATH=`pwd`:`pwd`/.. MOZILLA_FIVE_HOME=`pwd` ./regxpcom

  # set up the default skin and locale to trigger the generation of
  # the user-locales and users-skins.rdf
  echo "skin,install,select,classic/1.0" >> chrome/installed-chrome.txt
  echo "locale,install,select,en-US" >> chrome/installed-chrome.txt

  # save the defaults in a file that will be used later to rebuild the
  # installed-chrome.txt file
  echo "skin,install,select,classic/1.0" >> chrome/lang/default.txt
  echo "locale,install,select,en-US" >> chrome/lang/default.txt

  # set up the chrome rdf files
  LD_LIBRARY_PATH=`pwd`:`pwd`/.. MOZILLA_FIVE_HOME=`pwd` MOZ_DISABLE_GNOME=1 ./regchrome

  # fix permissions of the chrome directories
  /usr/bin/find . -type d -perm 0700 -exec chmod 755 {} \; || :
popd

# cp -L (dereference all symlinks) is required for fileutils >= 2.0.27
# (POSIX compliance); prior versions don't understand -L, so fall back...

# copy the nss files to the right place
mkdir $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/nss/

/usr/bin/find security/nss/lib/ -name '*.h' -type f -exec /bin/cp {} \
 $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/nss/ \;

# build the list of include files
rm -f %{builddir}/mozilla-devel.list
rm -f %{builddir}/mozilla-nss-devel.list
rm -f %{builddir}/mozilla-nspr-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f | \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep -v "/%{prefix}/include/mozilla-%{version}/nss" | \
  grep -v "/%{prefix}/include/mozilla-%{version}/nspr" > \
  %{builddir}/mozilla-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f | \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep "/%{prefix}/include/mozilla-%{version}/nspr" > \
  %{builddir}/mozilla-nspr-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f| \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep "/%{prefix}/include/mozilla-%{version}/nss" > \
  %{builddir}/mozilla-nss-devel.list

# copy our idl into place
#mkdir -p $RPM_BUILD_ROOT/%{prefix}/share/idl/mozilla-%{version}
#(cd dist/idl ; tar chf - * | \
#  (cd $RPM_BUILD_ROOT/%{prefix}/share/idl/mozilla-%{version} ; \
#   tar xvf -))

# copy our devel tools
install -c -m 755 dist/bin/xpcshell \
  dist/bin/xpidl \
  dist/bin/xpt_dump \
  dist/bin/xpt_link \
  $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}

# set up our desktop files
mkdir -p $RPM_BUILD_ROOT/%{prefix}/share/pixmaps/

# install desktop files in correct directory
%if %{desktop_file}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications/
install -c -m 644  %{SOURCE12} %{SOURCE14} \
   $RPM_BUILD_ROOT%{_datadir}/applications/
%else
mkdir -p $RPM_BUILD_ROOT/etc/X11/applnk/Internet
install -c -m 644  %{SOURCE4} %{SOURCE12} %{SOURCE14} \
   $RPM_BUILD_ROOT/etc/X11/applnk/Internet
%endif

install -c -m 644 %{SOURCE2} %{SOURCE13} %{SOURCE15} \
  $RPM_BUILD_ROOT/%{prefix}/share/pixmaps/

if [ ! -d $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/icons/ ]; then
  mkdir -m 755 $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/icons
fi

if [ ! -d $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/plugins/ ]; then
  mkdir -m 755 $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/plugins
fi

# our icons are better!
install -c -m 644 %{SOURCE9} $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/icons/
install -c -m 644 %{SOURCE10} $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/icons/

# install our mozilla.sh file
cat %{SOURCE1} | sed -e 's/MOZILLA_VERSION/%{version}/g' \
		     -e 's,LIBDIR,%{_libdir},g' > \
  $RPM_BUILD_ROOT/usr/bin/mozilla

chmod 755 $RPM_BUILD_ROOT/usr/bin/mozilla

# install our rebuild file
cat %{SOURCE11} | sed -e 's/MOZILLA_VERSION/%{version}/g' \
		      -e 's,LIBDIR,%{_libdir},g' > \
  $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl

chmod 755 \
  $RPM_BUILD_ROOT/%{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl

# we own /usr/lib/mozilla/plugins which is the version-independent
# place that plugins can be installed
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins

# install the gre.conf file
mkdir -p $RPM_BUILD_ROOT/etc/
echo [%{version}] > \
  $RPM_BUILD_ROOT/etc/gre.conf
echo GRE_PATH=%{_libdir}/mozilla-%{version} >> \
  $RPM_BUILD_ROOT/etc/gre.conf

%clean
#/bin/rm -rf $RPM_BUILD_ROOT

%post
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun
/sbin/ldconfig >/dev/null 2>/dev/null
# was this an upgrade?
if [ "$1" == "2" ]; then
  if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
      %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
  fi
fi

%triggerpostun -- mozilla < 1.0
# Older packages will leave mozilla unusable after the postun script
# script is run for the old package.  Rebuild the databases after that
# has been run.
if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%preun
# is a final removal?
if [ "$1" == "0" ]; then
  /bin/rm -rf %{_libdir}/mozilla-%{version}/chrome/overlayinfo
  /bin/rm -f %{_libdir}/mozilla-%{version}/chrome/*.rdf
fi

%post nspr
/sbin/ldconfig >/dev/null 2>/dev/null

%postun nspr
/sbin/ldconfig >/dev/null 2>/dev/null

%post nss
/sbin/ldconfig >/dev/null 2>/dev/null

%postun nss
/sbin/ldconfig >/dev/null 2>/dev/null

%post mail
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun mail

# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post chat
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun chat
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post js-debugger
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun js-debugger
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post dom-inspector
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun dom-inspector
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    %{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%files -f mozilla.list
%defattr(-,root,root)
%{prefix}/bin/mozilla
%{_libdir}/mozilla-%{version}/mozilla-rebuild-databases.pl
/etc/gre.conf
%{prefix}/share/pixmaps/mozilla-icon.png
%{prefix}/share/pixmaps/mozilla-mail-icon.png
%{prefix}/share/pixmaps/mozilla-compose-icon.png

%verify (not md5 mtime size) %{_libdir}/mozilla-%{version}/components/compreg.dat
%verify (not md5 mtime size) %{_libdir}/mozilla-%{version}/components/xpti.dat

%{_mandir}/man1/mozilla.1.gz

%dir %{_libdir}/mozilla/plugins

%dir %{_libdir}/mozilla-%{version}/defaults/pref
%dir %{_libdir}/mozilla-%{version}/defaults/profile
%dir %{_libdir}/mozilla-%{version}/defaults/profile/US
%dir %{_libdir}/mozilla-%{version}/defaults/wallet
%dir %{_libdir}/mozilla-%{version}/defaults/autoconfig
%dir %{_libdir}/mozilla-%{version}/defaults/messenger/US
%dir %{_libdir}/mozilla-%{version}/defaults/messenger
%dir %{_libdir}/mozilla-%{version}/defaults

%dir %{_libdir}/mozilla-%{version}/chrome/icons/default
%dir %{_libdir}/mozilla-%{version}/chrome/icons
%dir %{_libdir}/mozilla-%{version}/chrome/lang
%dir %{_libdir}/mozilla-%{version}/chrome

%dir %{_libdir}/mozilla-%{version}/res/builtin
%dir %{_libdir}/mozilla-%{version}/res/rdf
%dir %{_libdir}/mozilla-%{version}/res/dtd
%dir %{_libdir}/mozilla-%{version}/res/fonts
%dir %{_libdir}/mozilla-%{version}/res

%dir %{_libdir}/mozilla-%{version}/components
%dir %{_libdir}/mozilla-%{version}/icons
%dir %{_libdir}/mozilla-%{version}/searchplugins

%dir %{_libdir}/mozilla-%{version}/plugins
%dir %{_libdir}/mozilla-%{version}/res/html
%dir %{_libdir}/mozilla-%{version}/res/samples
%dir %{_libdir}/mozilla-%{version}/res/entityTables

%verify (not md5 mtime size) %{_libdir}/mozilla-%{version}/chrome/installed-chrome.txt
%{_libdir}/mozilla-%{version}/chrome/lang/installed-chrome.txt
%{_libdir}/mozilla-%{version}/chrome/lang/default.txt

%dir %{_libdir}/mozilla-%{version}

%if ! %{desktop_file}
/etc/X11/applnk/Internet/mozilla.desktop
%endif

%files nspr -f mozilla-nspr.list
%defattr(-,root,root)

%files nspr-devel -f mozilla-nspr-devel.list
%defattr(-,root,root)
%{_libdir}/pkgconfig/mozilla-nspr.pc
%{prefix}/bin/mozilla-config

%files nss -f mozilla-nss.list
%defattr(-,root,root)

%files nss-devel -f mozilla-nss-devel.list
%defattr(-,root,root)
%{_libdir}/pkgconfig/mozilla-nss.pc

%files mail -f mozilla-mail.list
%defattr(-,root,root)
%dir %{_libdir}/mozilla-%{version}/chrome/icons/default
%dir %{_libdir}/mozilla-%{version}/chrome/icons
%dir %{_libdir}/mozilla-%{version}/chrome
%dir %{_libdir}/mozilla-%{version}/components
%dir %{_libdir}/mozilla-%{version}
%if %{desktop_file}
%{_datadir}/applications/*
%else
/etc/X11/applnk/Internet/mozilla-mail.desktop
/etc/X11/applnk/Internet/mozilla-compose.desktop
%endif

%files chat -f mozilla-chat.list
%defattr(-,root,root)

%files js-debugger -f mozilla-js-debugger.list
%defattr(-,root,root)

%files dom-inspector -f mozilla-dom-inspector.list
%defattr(-,root,root)

%files devel -f mozilla-devel.list
%defattr(-,root,root)
%{prefix}/share/idl/mozilla-%{version}/*
%{_libdir}/pkgconfig/mozilla-js.pc
%{_libdir}/pkgconfig/mozilla-plugin.pc
%{_libdir}/pkgconfig/mozilla-xpcom.pc
%{_libdir}/pkgconfig/mozilla-gtkmozembed.pc
%{_libdir}/mozilla-%{version}/xpcshell
%{_libdir}/mozilla-%{version}/xpidl
%{_libdir}/mozilla-%{version}/xpt_dump
%{_libdir}/mozilla-%{version}/xpt_link

%changelog
* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Jan 15 2004 Christopher Blizzard <blizzard@redhat.com> 37:1.6-0
- Update to 1.6 final

* Tue Dec 02 2003 Christopher Blizzard <blizzard@redhat.com> 37:1.6a-0
- Update to 1.6a
- Merge in changes from the dist-10 branch.

* Fri Oct 25 2003 Christopher Blizzard <blizzard@redhat.com> 37:1.4.1-2
- Make sure that mozilla-devel pulls in mozilla-nss-devel

* Thu Oct 02 2003 Christopher Blizzard <blizzard@redhat.com> 37:1.4.1-2
- Merges from dist-10 branch

* Fri Jun 13 2003 Christopher Blizzard <blizzard@redhat.com> 36:1.4-0
- --disable-short-wchar has to go
- --enable-xinerama should be safe now

* Mon Jun  9 2003 Tim Powers <timp@redhat.com> 36:1.4-2.3.1
- change Serial to Epoch 
- build for RHEL

* Tue Jun  3 2003 Jeff Johnson <jbj@redhat.com>
- add explicit epoch's where needed.

* Thu Feb 27 2003 Thomas Woerner <twoerner@redhat.com> 35:1.2.1-27
- enabled mozilla-gcc-3.2-libs.tar.bz2 for x86_64

* Tue Feb 25 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-26
- Updated es-ES pack

* Mon Feb 24 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 21 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-24
- Include /usr/lib/mozilla/plugins

* Fri Feb 21 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-23
- Try to fix reloc errors on x86_64

* Thu Feb 21 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-22
- Add notting's patch for respecting LANG at startup

* Thu Feb 06 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-20
- fix infinite-galeon-windows-of-doom

* Mon Feb 03 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-19
- Build on ppc

* Sun Feb 02 2003 Christopher Blizzard <blizzard@redhat.com> 35:1.2.1-18
- Remove devnet from the default bookmarks

* Fri Jan 31 2003 Matt Wilson <msw@redhat.com> 35:1.2.1-17
- add x86_64 port from Mandrake
- modify all /usr/lib paths to use %%{_libdir]

* Tue Jan 28 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-15
- use ifarch instead of gcc_32_libs in defines

* Mon Jan 27 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-14
- Add XUL.mfasl corruption fix

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Jan 22 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-12
- Only build gcc-3.2-specific libs on i386

* Wed Jan 22 2003 Phil Knirsch <pknirsch@redhat.com> 1.2.1-11
- Make s390 and s390x compile and work with xpcom.

* Mon Jan 20 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-9
- Moz doesn't build with gcc 3.2 on alpha. *gurgle* Back to just i386.

* Sun Jan 19 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-9
- Include gcc3.2-compiled version for OOo.

* Fri Jan 17 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-8
- It might help if patch18 were actually _applied_.

* Tue Jan 14 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-7
- Include the right installed-chrome.txt file

* Mon Jan 13 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-6
- Translations

* Thu Jan 02 2003 Christopher Blizzard <blizzard@redhat.com> 1.2.1-5
- New lang architecture

* Mon Dec 23 2002 Christopher Blizzard <blizzard@redhat.com> 1.2.1-4
- Forgot to include calls to killall in case regxpcom or regchrome
  hang on install.

* Wed Dec 18 2002 Christopher Blizzard <blizzard@redhat.com> 1.2.1-3
- change patch to also allow us to set the UI font height in points

* Tue Dec 17 2002 Christopher Blizzard <blizzard@redhat.com> 1.2.1-1
- add patch that allows us to set the UI font name

* Mon Dec 16 2002 Christopher Blizzard <blizzard@redhat.com> 1.2.1-0
- ExlusiveArch for i386 and alpha.

* Wed Jul 10 2002 Christopher Blizzard <blizzard@redhat.com>
- Use the components/*.dat files instead of component.reg both in
rebuild-databases.pl and in packaging.

* Mon Jul  1 2002 Chris Blizzard <blizzard@redhat.com>
- Move libs into the system that need to be there

* Tue Jun 25 2002 Christopher Blizzard <blizzard@redhat.com>
- Change mozilla-rebuild-databases.pl to remove compreg.dat as well as
  component.reg.

* Sun Jun 23 2002 Chris Blizzard <blizzard@redhat.com>
- Move nspr + nss back into /usr/lib

* Thu Jun 20 2002 Christopher Blizzard <blizzard@redhat.com>
- Time for a new changelog.
