#ifdef WAVEINBUILD

// Audio services implementation file
// Based on work by Angela Yueng for her Master's Project
// Modified for GOOM WAVE input on Win32 by Frederic Howell

#include "goomaudio.h"
#include <stdio.h>

static HANDLE recordDone;		// event of audio input completion 
static HWAVEIN hWaveIn;		// onput WAVE audio device handle 
static SAMPLE inbuf[NWAVE][BUFSIZE];	// WAVE input data buffer area 
static HANDLE audioFileHandle;		// handle for audio file

static WAVEHDR WaveHeader[NWAVE];	

static int iwavedone;

static BOOL finished;
static HANDLE RecordHandle;
static HANDLE loopDone;
static BOOL bLoopDone;

extern void jeko_mono_to_stereo_render(SAMPLE *);

/*
* Callback function when WAVE input buffer is full
*/
void CALLBACK recordCallBack(HWAVEIN hWaveIn, UINT uMsg, DWORD p1, DWORD p2, DWORD p3)
{
	if (uMsg != WIM_DATA)
		return;
	iwavedone++;
	SetEvent(recordDone);
}



BOOL goom_audio_finished()
{
	return bLoopDone;
}
void goom_audio_finish(int istage)
{
	if (istage == 0) {
		finished = TRUE;
//		WaitForSingleObject(RecordHandle, INFINITE);
	}
	if (istage == 1) {
		SetEvent(loopDone);
		bLoopDone = TRUE;
		ExitThread(0);
	}
}
void goom_audio_wait() {
	WaitForSingleObject(loopDone, INFINITE);
	if (hWaveIn != NULL) {
		waveInReset(hWaveIn);
		waveInClose(hWaveIn);
	}
}

UINT Recorder(void *p)
{
	int i; 
	BOOL success;
	DWORD numWrite;
	int iwave,iwave2;
	int iwavewrite,iwavemax;
	
	iwavewrite = 0;
	iwavedone = 0;
	iwave = 0;
	success = TRUE;
	for(i = 0; ;) // just record a little bit
	{
		WaitForSingleObject(recordDone, INFINITE); // wait till device has called back
		iwavemax = iwavedone;
		if (finished) break;
//		if (iwavemax == iwavewrite) continue;
//		iwave = iwavewrite % NWAVE;
//		for (iwave2 = iwavewrite; iwave2 < iwavemax; iwave2++) {
		if (iwavemax == 0) continue;
		for (iwave2 = 0; iwave2 < iwavemax; iwave2++) {
			if (!(WaveHeader[iwave].dwFlags & WHDR_DONE))
			{
				continue;
			}
		
			jeko_mono_to_stereo_render((SAMPLE *)WaveHeader[iwave].lpData);
//			printf("buflen=%d bytrec =%d\n",(int)WaveHeader[iwave].dwBufferLength,(int)WaveHeader[iwave].dwBytesRecorded);
			if (waveInUnprepareHeader(hWaveIn, &WaveHeader[iwave],
				sizeof(WAVEHDR)) != MMSYSERR_NOERROR)
			{
				//cerr << "WAVE unprepare input buffer error\n";
				//exit(1);
				success = FALSE;
				break;
			}
			WaveHeader[iwave].dwFlags = 0;
		
			if (waveInPrepareHeader(hWaveIn, &WaveHeader[iwave],
				sizeof(WAVEHDR)) != MMSYSERR_NOERROR)
			{
				success = FALSE;
				break;
			}
			if (waveInAddBuffer(hWaveIn, &WaveHeader[iwave],
				sizeof(WAVEHDR)) != MMSYSERR_NOERROR)
			{
				success = FALSE;
				break;
			}
		
			iwave = (iwave + 1) % NWAVE;
			i++;
			iwavedone--;
		}
		iwavewrite=iwavedone;
	}
	waveInReset(hWaveIn);
	waveInClose(hWaveIn);
	hWaveIn = NULL;
	SetEvent(loopDone);
	bLoopDone = TRUE;
	if (success) return 0;
	return 1;
}


/*
* Open WAVE devices
*/
BOOL openWaveDev()
{
	MMRESULT Rc;
	WAVEFORMATEX PCMWaveFmtRecord;
	int iwave;
	
	PCMWaveFmtRecord.wFormatTag = WAVE_FORMAT_PCM;
	PCMWaveFmtRecord.nChannels = 1;
	PCMWaveFmtRecord.nSamplesPerSec = 32000;
	PCMWaveFmtRecord.wBitsPerSample = 8*sizeof(SAMPLE);
	PCMWaveFmtRecord.nBlockAlign = (PCMWaveFmtRecord.nChannels *
		PCMWaveFmtRecord.wBitsPerSample) / 8;
	PCMWaveFmtRecord.nAvgBytesPerSec = PCMWaveFmtRecord.nBlockAlign * PCMWaveFmtRecord.nSamplesPerSec;
	
	Rc = waveInOpen(&hWaveIn, WAVE_MAPPER, &PCMWaveFmtRecord,
		(DWORD) recordCallBack, 0L,
		CALLBACK_FUNCTION);
	if (Rc != MMSYSERR_NOERROR)
	{
		return FALSE;
	}
	for (iwave = 0; iwave < NWAVE; iwave++) {
		WaveHeader[iwave].dwBufferLength = BUFSIZE*sizeof(SAMPLE);
		WaveHeader[iwave].lpData = (LPSTR) (inbuf[iwave]);
		WaveHeader[iwave].dwFlags = WaveHeader[iwave].reserved = 0;
		WaveHeader[iwave].dwLoops = 0;
		WaveHeader[iwave].lpNext = 0;
		Rc = waveInPrepareHeader(hWaveIn, &WaveHeader[iwave],
			sizeof(WAVEHDR));
		if (Rc != MMSYSERR_NOERROR)
		{
			waveInClose(hWaveIn);
			return FALSE;
		}	
		Rc = waveInAddBuffer(hWaveIn, &WaveHeader[iwave],
				     sizeof(WAVEHDR));
		if (Rc != MMSYSERR_NOERROR)
		{
			waveInClose(hWaveIn);
			return FALSE;
		}
	}
	
	
	ResetEvent(recordDone);
	
	Rc = waveInStart(hWaveIn);
	if (Rc != MMSYSERR_NOERROR)
	{
		waveInClose(hWaveIn);
		return FALSE;
	}
	return TRUE;
}

BOOL goom_audio_start()
{
	
	DWORD threadid;
	DWORD dwExit;
	
	recordDone = CreateEvent(0, FALSE, FALSE, 0);
	ResetEvent(recordDone);
	loopDone = CreateEvent(0, FALSE, FALSE, 0);
	ResetEvent(loopDone);
	bLoopDone = FALSE;
	finished = FALSE;
	RecordHandle = CreateThread(NULL, 0,
		(LPTHREAD_START_ROUTINE) Recorder, NULL, 0,
		&threadid);
	if (!openWaveDev()) return FALSE;
//	WaitForSingleObject(RecordHandle, INFINITE);
///	waveInClose(hWaveIn);
//	GetExitCodeThread(RecordHandle,&dwExit);
//	if (dwExit != 0) return FALSE;
    return TRUE;
}
#endif
