/* ***** BEGIN LICENSE BLOCK *****
*
* $Id: motion_arrows.h,v 1.3 2004/11/22 13:42:33 asuraparaju Exp $ $Name: Dirac_0_5_3 $
*
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License
* Version 1.1 (the "License"); you may not use this file except in compliance
* with the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
* the specific language governing rights and limitations under the License.
*
* The Original Code is BBC Research and Development code.
*
* The Initial Developer of the Original Code is the British Broadcasting
* Corporation.
* Portions created by the Initial Developer are Copyright (C) 2004.
* All Rights Reserved.
*
* Contributor(s): Chris Bowley (Original Author)
*
* Alternatively, the contents of this file may be used under the terms of
* the GNU General Public License Version 2 (the "GPL"), or the GNU Lesser
* Public License Version 2.1 (the "LGPL"), in which case the provisions of
* the GPL or the LGPL are applicable instead of those above. If you wish to
* allow use of your version of this file only under the terms of the either
* the GPL or LGPL and not to allow others to use your version of this file
* under the MPL, indicate your decision by deleting the provisions above
* and replace them with the notice and other provisions required by the GPL
* or LGPL. If you do not delete the provisions above, a recipient may use
* your version of this file under the terms of any one of the MPL, the GPL
* or the LGPL.
* ***** END LICENSE BLOCK ***** */

#ifndef _MOTION_ARROWS_H_
#define _MOTION_ARROWS_H_

#include <util/instrumentation/libdirac_instrument/draw_overlay.h>
namespace dirac_instr
{

    //! Class to carry out the overlay of motion vectors represented by arrows
    /*
        Sub-class of DrawOverlay.
        16 x 16 pixel arrows used to represent motion vectors
        Each arrow may represent a number of motion vectors, in which case
        their mean is used
    */
    class DrawMotionArrows : public DrawOverlay
    {
    public :
        //! Constructor
        /*
            Calls DrawOverlay constructor
        */    
        DrawMotionArrows(Frame &, DrawFrameMotionParams &, const MvArray &, int);

        //! Destructor
        ~DrawMotionArrows();

        ////////////////////////////////////////////////////////////
        //                                                        //
        //    Assumes default copy constructor and assignment =   //
        //                                                        //
        ////////////////////////////////////////////////////////////
            
        //! Manages drawing of motion vector arrows
        void DrawBlock(int, int);
        
        //! Does nothing, no legend for overlay
        /*
            Base class function required to be overridden
        */
        void DrawLegend();
        
    protected :
        //! Draws a single 16 x 16 pixel arrow
        void DrawArrow(int, int, int, int);
        
        //! Temporal motion vector scaling
        int m_mv_scale;
        
        //! Number of blocks per arrow
        int m_blocks_per_arrow_y, m_blocks_per_arrow_x;
        
        //! Reference to motion vector data for particular reference
        const MvArray & m_mv;
    };

} // namespace dirac_instr

#endif
