/*****************************************************************************
 * Copyright © 2011 VideoLAN
 * $Id: 6e74f64ba414cbc84b564d27c2bbb69a9264f158 $
 *
 * Authors: Ludovic Fauvet <etix@l0cal.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef TIMETOOLTIP_H
#define TIMETOOLTIP_H

#include <QWidget>
#include <QBitmap>

class QPaintEvent;
class QString;
class QFont;
class QRect;
class QPainterPath;

class TimeTooltip : public QWidget
{
    Q_OBJECT
public:
    explicit TimeTooltip( QWidget *parent = 0 );
    void setText( const QString& time, const QString& text );

protected:
    virtual void paintEvent( QPaintEvent * );

private:
    void buildPath();
    QString mTime;
    QString mText;
    QString mDisplayedText;
    QFont mFont;
    QRect mBox;
    QPainterPath mPainterPath;
    QBitmap mMask;
    int mPreviousMetricsWidth;
};

#endif // TIMETOOLTIP_H
