/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class TransactionSynchronizationUtils {
    private static final Log logger = LogFactory.getLog(TransactionSynchronizationUtils.class);

    public static void triggerBeforeCommit(boolean readOnly) {
        Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (it.hasNext()) {
            TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
            synchronization.beforeCommit(readOnly);
        }
    }

    public static void triggerBeforeCompletion() {
        Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (it.hasNext()) {
            TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable tsex) {
                logger.error("TransactionSynchronization.beforeCompletion threw exception", tsex);
            }
        }
    }

    public static void triggerAfterCommit() {
        List synchronizations = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCommit(synchronizations);
    }

    public static void invokeAfterCommit(List synchronizations) {
        if (synchronizations != null) {
            Iterator it = synchronizations.iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                try {
                    synchronization.afterCommit();
                }
                catch (AbstractMethodError tserr) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Spring 2.0's TransactionSynchronization.afterCommit method not implemented in synchronization class [" + synchronization.getClass().getName() + "]", tserr);
                }
            }
        }
    }

    public static void triggerAfterCompletion(int completionStatus) {
        List synchronizations = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    public static void invokeAfterCompletion(List synchronizations, int completionStatus) {
        if (synchronizations != null) {
            Iterator it = synchronizations.iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                try {
                    synchronization.afterCompletion(completionStatus);
                }
                catch (Throwable tsex) {
                    logger.error("TransactionSynchronization.afterCompletion threw exception", tsex);
                }
            }
        }
    }
}

