/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.monitor;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jrobin.core.Util;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.monitor.Monitor;

public class ServerMonitor
implements Monitor {
    private static final Logger logger = Logger.getLogger(ServerMonitor.class);
    private VLMaService vlmaService;
    public static final int TIME_INTERVAL = 300;
    private Thread updateSNMPDataThread;
    private Thread serverMonitorDaemonThread;
    private AtomicBoolean shouldRun = new AtomicBoolean(false);
    Runnable snmpDataUpdater = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerMonitor serverMonitor = ServerMonitor.this;
            synchronized (serverMonitor) {
                ArrayList<UpdateThread> updateThreads = new ArrayList<UpdateThread>();
                for (Server server : ServerMonitor.this.vlmaService.getServers()) {
                    UpdateThread updateThread = new UpdateThread(ServerMonitor.this.vlmaService, server);
                    updateThreads.add(updateThread);
                    updateThread.start();
                }
                for (Thread thread : updateThreads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    };
    Runnable serverMonitorDaemon = new Runnable(){

        public void run() {
            ServerMonitor.this.shouldRun.set(true);
            while (ServerMonitor.this.shouldRun.get()) {
                try {
                    Thread.sleep(1000L * (300L - Util.getTime() % 300L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ServerMonitor.this.shouldRun.get()) continue;
                ServerMonitor.this.startUpdateSNMPDataThread();
            }
            logger.debug((Object)"ServerMonitor thread stopped.");
        }
    };

    public boolean isUpdatingSNMPData() {
        return this.updateSNMPDataThread != null && this.updateSNMPDataThread.isAlive();
    }

    public boolean isDaemonMonitoring() {
        return this.serverMonitorDaemonThread != null && this.serverMonitorDaemonThread.isAlive();
    }

    public synchronized void startUpdateSNMPDataThread() {
        if (!this.isUpdatingSNMPData()) {
            this.updateSNMPDataThread = new Thread(this.snmpDataUpdater);
            this.updateSNMPDataThread.setName("updateSNMPDataThread");
            this.updateSNMPDataThread.start();
        }
    }

    public synchronized void start() {
        if (!this.isDaemonMonitoring()) {
            logger.info((Object)("Starting " + this.getClass().getSimpleName()));
            this.serverMonitorDaemonThread = new Thread(this.serverMonitorDaemon);
            this.serverMonitorDaemonThread.setName("serverMonitorThread");
            this.serverMonitorDaemonThread.start();
        }
    }

    public synchronized void stop() {
        logger.info((Object)("Stopping " + this.getClass().getSimpleName()));
        this.shouldRun.set(false);
        this.serverMonitorDaemonThread.interrupt();
    }

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }

    private class UpdateThread
    extends Thread {
        private VLMaService vlmaService;
        private Server server;

        public UpdateThread(VLMaService vlmaService, Server server) {
            this.vlmaService = vlmaService;
            this.server = server;
        }

        public void run() {
            logger.debug((Object)("Update RRD file of " + this.server.getName()));
            this.vlmaService.updateSnmpData(this.server);
            this.vlmaService.updateRrdGraph(this.server);
        }
    }
}

