/*******************************************************************************
* buffer.h: Buffer classes definitions
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: buffer.h,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _SERVER_BUFFER_H_
#define _SERVER_BUFFER_H_


//------------------------------------------------------------------------------
// class C_SyncFifo
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_SyncFifo
{
 public:
  C_SyncFifo(unsigned int uiSize);

  unsigned int Capacity() const
  { return m_cFifo.Capacity(); }
  unsigned int Size() const
  { return m_cFifo.Size(); }
     
  void Push(C_TsPacket* pPacket);
  C_TsPacket* Pop();
  
 private:
  // Thread synchro objects
  C_Semaphore m_cNotEmptySignal;
  C_Semaphore m_cNotFullSignal;
    
  // Fifo
  C_Fifo<C_TsPacket> m_cFifo;
};



//------------------------------------------------------------------------------
// Class C_NetList
//------------------------------------------------------------------------------
// The netlist doe not inherit from any buffer for several reasons:
// * this has been tried, and ununderstandable problems occurred
// * it must be possible to implement it as LIFO if it is proved that it's
// more efficient and there is no LIFO class
//------------------------------------------------------------------------------
class C_NetList
{
 public:
  C_NetList(unsigned int iSize = 65536);
  ~C_NetList();
  
  C_TsPacket* GetPacket();
  void ReleasePacket(C_TsPacket* pPacket);

  unsigned int Capacity()
  { return iBuffSize; }

 protected:
  // The buffer of TS packets itself
  C_TsPacket* aPackets;
  // Array of pointers to the free packets (ie that never were poped) and
  // index of the first element of the table that points to a such packet
  C_TsPacket** apFreePackets;
  unsigned int iFirstFree;
  // Size of the 2 previous arrays
  unsigned int iBuffSize;

 private:
  // Mutex used to allow the netlist to be used by several threads at the same
  // time
  C_Mutex m_sMutex;
};


#else
#error "Multiple inclusions of buffer.h"
#endif

